var net = require('net');
var HOST = 'localhost';
var PORT = 31337;
var client = new net.Socket();

var map;
var pizzaid;
var parDiv = 8;
var myPath;

function Connect()
{
	client.connect(PORT, HOST);
}

client.on('connect', function()
{
	console.log('CONNECTED TO: ' + HOST + ':' + PORT);
	client.write("pizzaBot");
	client.write('32\n');
});

client.on('error', function(data) {
	console.log('ERROR: ' + data);
	client.destroy();
});

client.on('close', function(error) {
	if (error == true)
	{
		console.log("Unexpected disconnect");
	} else {
        	console.log("Disconnected. Trying reconnect in 1 second");
		setTimeout(function()
		{
			Connect();
		} , 1000);
		client.destroy();
	}
});

Connect();

var iter = 0

client.on('data', function(data) {
	iter++;

	var parsedData = JSON.parse(data.toString("utf-8"));

	if (iter == 1) {
		pizzaid = parsedData.id;
		initMap(parsedData.map);
	} else {
		moveOpti(parsedData);
	}
});

function initMap(parsed)
{
	map = parsed;
	myPath = 0;
}

function checkMod(minx,maxx,miny,maxy,dirE)
{
	/*var c;
	for(c = 0; c < map.modifiers.length; c++)
	{
		
	}*/
	var asd = {es:false,x:0,y:0,width:0,height:0};
	return asd;
}

function checkDirB(nPath)
{
	var next;	
	if((map.path.length-1) == nPath)
	{
		next = 0;
	}
	else
	{
		next = nPath + 1;
	}

	var cX = map.path[nPath].tile_x;
	var cY = map.path[nPath].tile_y;
	var nX = map.path[next].tile_x;
	var nY = map.path[next].tile_y;
	
	if(cY == nY)
		switch(map.tiles[nY][nX])
		{
			// 1 = destra, 2 = sinistra
			// x0 = curva verso l'alto, x1 = curva verso il basso
			case '-':
				return (cX < nX) ? 1 : 2;
			
			case ',':
				return 10;
			case '`': 
				return 11;
			
			case '\\':
				return 20;
			case '/': 
				return 21;
		}																																		
	
	if(cX == nX)
		switch(map.tiles[nY][nX])
		{
			// 3 = giù, 4 = su
			// x0 = curva verso destra, x1 = curva verso sinistra
			case '|':
				return (cY < nY) ? 3 : 4;
			
			case '\\':
				return 30;			
			case ',':
				return 31;

			case '/': 
				return 40;
			case '`': 
				return 41;
		}
	return 0;
}

function checkDir(nPath)
{
	var next;	

	if(map.path.length == (nPath + 1))
	{
		next = 0;
	}
	else
	{
		next = nPath + 1;
	}

	if((map.path[nPath].tile_x == map.path[next].tile_x) && (map.path[nPath].tile_y < map.path[next].tile_y))
	{
			/* GIU */
                        return 3;
	}
        else
        {
        	if((map.path[nPath].tile_x == map.path[next].tile_x) && (map.path[nPath].tile_y > map.path[next].tile_y))
		{
			/* SU */
                	return 4;
		}
                else
                {
                        if((map.path[nPath].tile_x < map.path[next].tile_x) && (map.path[nPath].tile_y == map.path[next].tile_y))
			{
				/* DX */
                        	return 1;
			}
                        else
                        {
                                if((map.path[nPath].tile_x > map.path[next].tile_x) && (map.path[nPath].tile_y == map.path[next].tile_y))
				{
					/* SX */
                                        return 2;
				}
                                else
                                {
						/* Random mode */
                                                return 0;
                                }
                        }
                }
          }
}

function moveOpti(gData)
{	
	var myCar, i;
	for(i = 0; i < gData.cars.length; i++)
	{
		if(gData.cars[i].id == pizzaid)
		{
			myCar = gData.cars[i];
		}
	}

	var nPath = iminpath(myCar.pos);
	var nOpti,next;	

	var cars = gData.cars;

	if(nPath != -1 || true)
	{
		if(!rnd(cars, nPath))
		{

			next = (myPath+1) % (map.path.length-1);

			if(nPath == next)
			{
				myPath = next;
			}	

			if(!isThereObs())			
			{	
				if(!isThereCurve())
				{					
					var xu = checkDirB(next);
					switch(xu){
						case 0:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width/2, map.path[next].tile_y*map.tile_height+map.tile_height/2,myCar.direction);
							break;
						case 1:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width/2, map.path[next].tile_y*map.tile_height+map.tile_height/2,myCar.direction);
							break;
						case 10:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width/4, map.path[next].tile_y*map.tile_height+map.tile_height*3/4,myCar.direction);
							break;
						case 11:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width*3/4, map.path[next].tile_y*map.tile_height+map.tile_height/4,myCar.direction);
							break;
						case 2:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width/2, map.path[next].tile_y*map.tile_height+map.tile_height/2,myCar.direction);
							break;
						case 20:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width/4, map.path[next].tile_y*map.tile_height+map.tile_height*3/4,myCar.direction);
							break;
						case 21:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width*3/4, map.path[next].tile_y*map.tile_height+map.tile_height/4,myCar.direction);
							break;
						case 3:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width/2, map.path[next].tile_y*map.tile_height+map.tile_height/2,myCar.direction);
							break;
						case 30:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width/4, map.path[next].tile_y*map.tile_height+map.tile_height*3/4,myCar.direction);
							break;
						case 31:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width*3/4, map.path[next].tile_y*map.tile_height+map.tile_height/4,myCar.direction);
							break;
						case 4:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width/2, map.path[next].tile_y*map.tile_height+map.tile_height/2,myCar.direction);
							break;
						case 40:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width/4, map.path[next].tile_y*map.tile_height+map.tile_height*3/4,myCar.direction);
							break;
						case 41:
							gobacktopath(myCar.pos,map.path[next].tile_x*map.tile_width+map.tile_width*3/4, map.path[next].tile_y*map.tile_height+map.tile_height/4,myCar.direction);
							break;
					}
				}
			}
			
			
		}
	}	
	else
	{
gobacktopath(myCar.pos,map.path[myPath].tile_x*map.tile_width+map.tile_width/2,
	map.path[myPath].tile_y*map.tile_height+map.tile_height/2,myCar.direction);		
	}
}

function isThereObs()
{


	return false;
}

function isThereCurve()
{

	return false;
}

function gobacktopath(pos,x,y,dir)
{
	var parSpace = ((map.tile_width + map.tile_height)/2)/parDiv;
	
	var posPath = {x: x, y: y};

	var anglepath = Math.atan2(posPath.y - pos.y, posPath.x - pos.x)  * 180 / Math.PI;

	var myAngle = Math.atan2(dir.y, dir.x)  * 180 / Math.PI;

	if(anglepath < 180)
		myAngle = myAngle + (180 - anglepath);
	else
		myAngle = myAngle - (180 - anglepath);

	anglepath = 180;

	myAngle = Math.round(myAngle);
	anglepath = Math.round(anglepath);		


	myAngle = myAngle % 360;
	anglepath = anglepath % 360; 

	if(myAngle < 0)
		myAngle = myAngle + 360;
	if(anglepath < 0) 
                anglepath = anglepath + 360;

	if((myAngle < 178) && (myAngle > 2))
	{
		client.write("9\n");
	}
	else
	{
		if((myAngle > 182) && (myAngle < 358)){
			client.write("5\n");
		}
		else{
			client.write("1\n");
		}
	}
	
}

function iminpath(myPos)
{
	var i,n;
	
	n=-1;
	for(i = 0; i < map.path.length; i++)
	{
		if((myPos.x >= (map.path[i].tile_x * map.tile_width))&&(myPos.x < ((map.path[i].tile_x * map.tile_width) + map.tile_width))&&
		(myPos.y >= (map.path[i].tile_y * map.tile_height))&&(myPos.y < ((map.path[i].tile_y * map.tile_height) + map.tile_height)))
			n = i;
	}
	return n;
}

function rnd(cars, nPath)
{
	var powerup,car;
	var fo;
	for(fo = 0; fo < cars.length; fo++)
	{
		if(cars[fo].id == pizzaid)
			powerup = cars[fo].powerup;
	}

	if(powerup == undefined )//|| powerup == "blueshell")
	{
		return false;
	}
	if(powerup == "blueshell" || powerup == "redshell" || powerup == "greenshell"){
		client.write('32\n');
		return true;
	}

	if(powerup == "oil" || powerup == "banana" || powerup == "mushroom" || powerup == "bigmushroom" || powerup == "star")
	{
		client.write('32\n');
		return true;
	}
		
	if(powerup == "lightning")
	{
		if(checkCurve(nPath, 2))
		{
			client.write('32\n');
			return true;
		}
		return false;
	}

	
	if((powerup == "redshell" || powerup == "greenshell") && checkEnemy(nPath, cars))
	{
		client.write('32\n');
		return true;
	}
	
	return false;
}

function checkEnemy(nPath, cars)
{
	var next;
	if(nPath == (map.path.length - 1))
		next = 0;
	else
		next = nPath+1;
	nX = map.path[next].tile_x;
	nY = map.path[next].tile_y;

	for(fo = 0; fo < cars.length; fo++)
        {
                if(cars[fo].id == pizzaid)
		{
			if(cars[fo].pos.x/map.tile_width == nX && cars[fo].pos.y/map.tile_height == nY)
				return true;			
		}
	}

	return false;
}

function checkCurve(nPath, distance)
{
	for(var i = 0; i < distance; i++)
	{
		next = map.path[(nPath+i) % map.path.length];
		if(map.tiles[next.tile_y][next.tile_x] != '-' || map.tiles[next.tile_y][next.tile_x] != '|')
			return false;
	}

	return true;
}
