package artificialstupidity;

import Structures.Car;
import Structures.Game;
import Structures.MapPacket;
import Structures.VectorF2D;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Networking {
    private PrintWriter output;
    private BufferedReader input;
    private boolean mapPacket = true;
    public GameManager game;
    public Gson json = new Gson();
    public String serverMessage;
    private int CPS = 0; //Commands per second.
    private long nano_timer_start = 0;
    private List<String> powerups_detected;
    
    public Networking(String host, int port, String name) {
        powerups_detected = new ArrayList<String>();
        
        try {
            Socket socket = new Socket(host, port);
            
            output = new PrintWriter(socket.getOutputStream(), true);
            input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            
            Write(name);
        }catch (IOException ex) {
            Logger.getLogger(ArtificialStupidity.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    public void map_packet() {
        game = new GameManager();
        
        game.game_info = json.fromJson(serverMessage, MapPacket.class);
        game.game_info.map.map_width = game.game_info.map.tiles[0].length;
        game.game_info.map.map_height = game.game_info.map.tiles.length;
    }
    
    public void status_update() {
        game.kartening = json.fromJson(serverMessage, Game.class);
        
        game.local_car = game.kartening.cars[game.game_info.id];
        game.local_car.pos.x = game.local_car.pos.x / 128;
        game.local_car.pos.y = game.local_car.pos.y / 128;
        
        game.UpdateLocales(game.game_info.map.map_width);
    }
    
    public void SetSpeed(float speed, VectorF2D direction) {
        float SpeedX = direction.x * speed;
        float SpeedY = direction.y * speed;
        Car local_car = this.game.local_car;
        
        if(SpeedX >= 0 && local_car.velocity.x <= SpeedX || SpeedX <= 0 && local_car.velocity.x > SpeedX && SpeedY >= 0 && local_car.velocity.y <= SpeedY || SpeedY <= 0 && local_car.velocity.y >= SpeedY) {
            Accelerate();
        }
    }
    
    public void SetDirection(VectorF2D newDirection) {
        float currentAngle = (float) Math.toDegrees(Math.atan2(this.game.local_car.direction.y, this.game.local_car.direction.x));
        float target_angle = (float) Math.toDegrees(Math.atan2(newDirection.y, newDirection.x));
        
        if(currentAngle < 0) {
            currentAngle = (180 - Math.abs(currentAngle)) + 180;
        }
        
        if(target_angle < 0) {
            target_angle = (180 - Math.abs(target_angle)) + 180;
        }
        
        while(currentAngle < target_angle - 3 || currentAngle > target_angle + 3) {
            if(currentAngle >= 270 && target_angle >= 0 && target_angle <= 90) {
                AccelerateRight();
            }
            
            else if(currentAngle >= 0 && target_angle >= 270 && currentAngle <= 90) {
                AccelerateLeft();
            }
            
            else if(currentAngle < target_angle) {
                AccelerateRight();
            }else {
                AccelerateLeft();
            }
            
            currentAngle = (float) Math.toDegrees(Math.atan2(this.game.local_car.direction.y, this.game.local_car.direction.x));
            
            if(currentAngle < 0) {
                currentAngle = (180 - Math.abs(currentAngle)) + 180;
            }
        }
        
        Stop();
    }
    
    public void Read() {
        try {
            serverMessage = input.readLine();
        } catch (IOException ex) {
            Logger.getLogger(Networking.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        if(mapPacket) {
            map_packet();
            mapPacket = false;
            Write("0");
        }else {
            status_update();
        }
    }
    
    public void Write(String toWrite) {
        if(nano_timer_start == 0) {
            nano_timer_start = System.nanoTime();
        }
        CPS++;
        output.write(toWrite);
        output.flush();
        Read();
        
        if(System.nanoTime() / 1000000 > (nano_timer_start / 1000000) + 1000) {
            nano_timer_start = 0;
            
            if(CPS >= 60) {
                System.out.println("Max commands per second hit!\n");
            }
            
            CPS = 0;
        }
    }
    
    public void Stop() {
        Write("0\n");
    }
    
    public void Write(int toWrite) {
        output.write(toWrite + "\n");
        output.flush();
        Read();
    }
    
    public void Accelerate() {
        Write(1<<0);
    }
    
    public void Decelerate() {
        Write(1<<1);
    }
    
    public void TurnLeft() {
        Write(1<<2);
    }
    
    public void TurnRight() {
        Write(1<<3);
    }
    
    public void AccelerateRight() {
        Write(1<<3|1<<0);
    }
    
    public void AccelerateLeft() {
        Write(1<<2|1<<0);
    }
    
    public void DecelerateRight() {
        Write(1<<1|1<<3);
    }
    
    public void DecelerateLeft() {
        Write(1<<1|1<<2);
    }
    
    public void Drift() {
        Write(1<<4);
    }
    
    public void Powerup() {
        char terrain = this.game.game_info.map.GetTerrain((int)this.game.local_car.pos.x, (int)this.game.local_car.pos.y);
        
        switch(this.game.local_car.powerup) {
            case "lightning":
                Write(1<<5);
                break;
            case "oil":
                if(terrain != '-' && terrain != '|') {
                    Write(1<<5);
                }
                break;
            case "blueshell":
                if(terrain != '/' && terrain != '\\' && terrain != ',' && terrain != '`') {
                    Write(1<<5);
                }
                break;
            case "banana":
                if(terrain != '-' && terrain != '|') {
                    Write(1<<5);
                }
                break;
            case "none":
                break;
        }
    }
}
