package Structures;

public class VectorF2D {
    public float x;
    public float y;
    public double length;
    
    public VectorF2D(float x, float y) {
        this.x = x;
        this.y = y;
        this.length = Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
    }
    
    public VectorF2D normalized() {
        return new VectorF2D((float)(1 / this.length) * this.x, (float)(1 / this.length) * this.y);
    }
    
    public VectorF2D Intersects(VectorF2D PointA, VectorF2D DirectionA, VectorF2D PointB, VectorF2D DirectionB) {
        float Ax = PointA.x - DirectionA.x;
        float Ay = PointA.y - DirectionA.y;
        float Ac = Ay * PointA.x + Ax * PointA.y;
        
        float Bx = PointB.x - DirectionB.x;
        float By = PointB.y - DirectionB.y;
        float Bc = By * PointB.x + Bx * PointB.y;
        
        float Delta = Ay * Bx - By * Ax;
        
        if(Delta == 0) {
            return new VectorF2D(0, 0); //lines are paralell and will never intersect
        }else {
            float x = (Ax - Bx) / Delta;
            float y = (Ay - By) / Delta;
            return new VectorF2D(x, y); //lines intersect
        }
        
    }
    
    public VectorF2D CrossProduct(VectorF2D otherVector) {
        VectorF2D newVector;
        
        newVector = new VectorF2D(this.x - otherVector.y, this.y - otherVector.x);
        
        return newVector;
    }
    
    public float DotProduct(VectorF2D otherVector) {
        return (this.x * otherVector.x) + (this.y * otherVector.y);
    }
}
