package Structures;

public class Node {
    private Node parent;
    private int H;
    private int G;
    private int F;
    private int x;
    private int y;
    private float fx;
    private float fy;
    private int id;
    public VectorF2D pos;
    public boolean adjustedx = false;
    public boolean adjustedy = false;
    public boolean checkpoint = false;
    public boolean corner = false;
    public boolean walkable = false;
    
    public Node(int x, int y, Node parent, int G, int map_width) {
        this.x = x;
        this.y = y;
        this.fy = y;
        this.fx = x;
        this.id = (this.y * map_width) + this.x;
        this.parent = parent;
        this.G = G; 
        this.pos = new VectorF2D(this.fx, this.fy);
    }

    public Node() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    public boolean equals(Node target) {
        if(target.x == this.x && target.y == this.y)
            return true;
        return false;
    }
    
    public void Adjust(float x, float y) {
        if(!this.adjustedx && x != 0) {
            this.fx = this.fx + x;
            this.adjustedx = true;
        }
        
        if(!this.adjustedy && y != 0) {
            this.fy = this.fy + y;
            this.adjustedy = true;
        }
    }
    
    public int GetID() {
        return this.id;
    }
    
    public Node GetParent() {
        return this.parent;
    }
    
    public void SetParent(Node parent) {
        this.parent = parent;
    }
    
    public int GetY() {
        return this.y;
    }
    
    public int GetX() {
        return this.x;
    }
    
    public float GetFY() {
        return this.fy;
    }
    
    public float GetFX() {
        return this.fx;
    }
    
    public void SetFY(float f) {
        this.fy = f;
    }
    
    public void SetFX(float f) {
        this.fx = f;
    } 
    
    public int GetH() {
        return this.H;
    }
    
    public void SetH(int H) {
        this.H = H;
        this.F = this.G + this.H;
    }
    
    public int GetG() {
        return this.G;
    }
    
    public void SetG(int G) {
        this.G = G;
        this.F = this.H + this.G;
    }
    
    public int GetF() {
        return this.F;
    }
    
    public void CalculateF() {
        this.F = this.G + this.H;
    }
}
