/*
 * Decompiled with CFR 0.152.
 */
package artificialstupidity;

import Structures.Car;
import Structures.Game;
import Structures.MapPacket;
import Structures.VectorF2D;
import artificialstupidity.ArtificialStupidity;
import artificialstupidity.GameManager;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Networking {
    private PrintWriter output;
    private BufferedReader input;
    private boolean mapPacket = true;
    public GameManager game;
    public Gson json = new Gson();
    public String serverMessage;
    private int CPS = 0;
    private long nano_timer_start = 0L;
    private List<String> powerups_detected = new ArrayList<String>();

    public Networking(String host, int port, String name) {
        try {
            Socket socket = new Socket(host, port);
            this.output = new PrintWriter(socket.getOutputStream(), true);
            this.input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.Write(name);
        }
        catch (IOException ex) {
            Logger.getLogger(ArtificialStupidity.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void map_packet() {
        this.game = new GameManager();
        this.game.game_info = this.json.fromJson(this.serverMessage, MapPacket.class);
        this.game.game_info.map.map_width = this.game.game_info.map.tiles[0].length;
        this.game.game_info.map.map_height = this.game.game_info.map.tiles.length;
    }

    public void status_update() {
        this.game.kartening = this.json.fromJson(this.serverMessage, Game.class);
        this.game.local_car = this.game.kartening.cars[this.game.game_info.id];
        this.game.local_car.pos.x /= 128.0f;
        this.game.local_car.pos.y /= 128.0f;
        this.game.UpdateLocales(this.game.game_info.map.map_width);
    }

    public void SetSpeed(float speed, VectorF2D direction) {
        float SpeedX = direction.x * speed;
        float SpeedY = direction.y * speed;
        Car local_car = this.game.local_car;
        if (SpeedX >= 0.0f && local_car.velocity.x <= SpeedX || SpeedX <= 0.0f && local_car.velocity.x > SpeedX && SpeedY >= 0.0f && local_car.velocity.y <= SpeedY || SpeedY <= 0.0f && local_car.velocity.y >= SpeedY) {
            this.Accelerate();
        }
    }

    public void SetDirection(VectorF2D newDirection) {
        float currentAngle = (float)Math.toDegrees(Math.atan2(this.game.local_car.direction.y, this.game.local_car.direction.x));
        float target_angle = (float)Math.toDegrees(Math.atan2(newDirection.y, newDirection.x));
        if (currentAngle < 0.0f) {
            currentAngle = 180.0f - Math.abs(currentAngle) + 180.0f;
        }
        if (target_angle < 0.0f) {
            target_angle = 180.0f - Math.abs(target_angle) + 180.0f;
        }
        while (currentAngle < target_angle - 3.0f || currentAngle > target_angle + 3.0f) {
            if (currentAngle >= 270.0f && target_angle >= 0.0f && target_angle <= 90.0f) {
                this.AccelerateRight();
            } else if (currentAngle >= 0.0f && target_angle >= 270.0f && currentAngle <= 90.0f) {
                this.AccelerateLeft();
            } else if (currentAngle < target_angle) {
                this.AccelerateRight();
            } else {
                this.AccelerateLeft();
            }
            if (!((currentAngle = (float)Math.toDegrees(Math.atan2(this.game.local_car.direction.y, this.game.local_car.direction.x))) < 0.0f)) continue;
            currentAngle = 180.0f - Math.abs(currentAngle) + 180.0f;
        }
        this.Stop();
    }

    public void Read() {
        try {
            this.serverMessage = this.input.readLine();
        }
        catch (IOException ex) {
            Logger.getLogger(Networking.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.mapPacket) {
            this.map_packet();
            this.mapPacket = false;
            this.Write("0");
        } else {
            this.status_update();
        }
    }

    public void Write(String toWrite) {
        if (this.nano_timer_start == 0L) {
            this.nano_timer_start = System.nanoTime();
        }
        ++this.CPS;
        this.output.write(toWrite);
        this.output.flush();
        this.Read();
        if (System.nanoTime() / 1000000L > this.nano_timer_start / 1000000L + 1000L) {
            this.nano_timer_start = 0L;
            if (this.CPS >= 60) {
                System.out.println("Max commands per second hit!\n");
            }
            this.CPS = 0;
        }
    }

    public void Stop() {
        this.Write("0\n");
    }

    public void Write(int toWrite) {
        this.output.write(toWrite + "\n");
        this.output.flush();
        this.Read();
    }

    public void Accelerate() {
        this.Write(1);
    }

    public void Decelerate() {
        this.Write(2);
    }

    public void TurnLeft() {
        this.Write(4);
    }

    public void TurnRight() {
        this.Write(8);
    }

    public void AccelerateRight() {
        this.Write(9);
    }

    public void AccelerateLeft() {
        this.Write(5);
    }

    public void DecelerateRight() {
        this.Write(10);
    }

    public void DecelerateLeft() {
        this.Write(6);
    }

    public void Drift() {
        this.Write(16);
    }

    public void Powerup() {
        char terrain = this.game.game_info.map.GetTerrain((int)this.game.local_car.pos.x, (int)this.game.local_car.pos.y);
        switch (this.game.local_car.powerup) {
            case "lightning": {
                this.Write(32);
                break;
            }
            case "oil": {
                if (terrain == '-' || terrain == '|') break;
                this.Write(32);
                break;
            }
            case "blueshell": {
                if (terrain == '/' || terrain == '\\' || terrain == ',' || terrain == '`') break;
                this.Write(32);
                break;
            }
            case "banana": {
                if (terrain == '-' || terrain == '|') break;
                this.Write(32);
                break;
            }
        }
    }
}

