﻿using System.Collections.Generic;
using System.Linq;
using Interop;

namespace Fuseren
{
	public class ItemUsability
	{
		readonly MapInfo _mapInfo;
		const byte UseItemCode = 1 << 5;

		public ItemUsability(MapInfo mapInfo)
		{
			_mapInfo = mapInfo;
		}

		public byte CreateCommands(int curPlayer, Stack<TilePos> curPath, GameState gameState)
		{
			var useItem = false;
			switch (gameState.Cars[curPlayer].Powerup)
			{				
				case PowerupType.Banana:
				case PowerupType.Oil:
				case PowerupType.Lightning:
				case PowerupType.Blueshell:
				case PowerupType.Greenshell:
				case PowerupType.Redshell:
					useItem = true;
					break;
				case PowerupType.Bigmushroom:
				case PowerupType.Mushroom:
				case PowerupType.Star:
					useItem = ShouldUseVelocityIncreaser(curPath);
					break;
			}

			return useItem ? UseItemCode : (byte)0;
		}

		public bool ShouldUseVelocityIncreaser(Stack<TilePos> curPath)
		{
			if (curPath == null || curPath.Count == 0)
				return false;

			var firstTileType = _mapInfo.GetTileType(curPath.First());

			if (IsStraight(firstTileType))
			{
				return true;
			}
			else 
				return false;
		}

		bool IsStraight(TileType tileType)
		{
			return tileType == TileType.HorizontalStraight || tileType == TileType.VerticalStraight ||
			       tileType == TileType.Intersection;
		}
	}
}