﻿using System.Collections.Generic;
using Newtonsoft.Json;

namespace Interop
{
	public class Item
	{
		[JsonProperty(PropertyName = "oil"), JsonConverter(typeof(ServerStringEnumConverter))]
		public PowerupType Type;

		[JsonProperty(PropertyName = "x")]
		public int X;

		[JsonProperty(PropertyName = "y")]
		public int Y;

		[JsonProperty(PropertyName = "width")]
		public int Width;

		[JsonProperty(PropertyName = "height")]
		public int Height;
	}

    public class GameState
    {
        [JsonProperty(PropertyName = "cars")]
        public List<CarData> Cars;

        [JsonProperty(PropertyName = "shells")]
        public List<ShellData> Shells;

        [JsonProperty(PropertyName = "boxes")]
        public List<BoxData> Boxes;

	    [JsonProperty(PropertyName = "items")] 
		public List<Item> Items;
    }
}