﻿using Newtonsoft.Json;

namespace Interop
{
	public enum PowerupType
	{
		Unknown,
		None,
		Banana,
		Greenshell,
		Redshell,
		Blueshell,
		Oil,
		Mushroom,
		Bigmushroom,
		Lightning,
		Star,		
	}

    public class CarData
    {
        [JsonProperty(PropertyName = "id")]
        public int Id;

        [JsonProperty(PropertyName = "direction")]
        public VectorData Direction;

        [JsonProperty(PropertyName = "velocity")]
        public VectorData Velocity;

        [JsonProperty(PropertyName = "pos")]
        public VectorData Pos;

        [JsonProperty(PropertyName = "drift")]
        public int Drift;

        [JsonProperty(PropertyName = "width")]
        public int Width;

        [JsonProperty(PropertyName = "height")]
        public int Height;

		[JsonProperty(PropertyName = "powerup"), JsonConverter(typeof(ServerStringEnumConverter))]
	    public PowerupType Powerup;
    }

    public class BoxData
    {
        [JsonProperty(PropertyName = "x")]
        public double X;

        [JsonProperty(PropertyName = "y")] 
        public double Y;

        [JsonProperty(PropertyName = "width")] 
        public int Width;

        [JsonProperty(PropertyName = "height")] 
        public int Height;
    }
}