import math

from itertools import product
from astar_grid import AStarGrid, AStarGridNode
from coord import Coord


def clamp(n, minn, maxn):
    return max(min(maxn, n), minn)


class World(object):
    debug = False
    tiles = []
    r_tiles = []

    width = 0
    height = 0

    r_width = 0
    r_height = 0

    path = None
    pathIndex = 0
    nodes = None
    graph = None
    offsetAmount = 0

    directions = {
        'UP': Coord(x=0, y=-1),
        'DOWN': Coord(x=0, y=1),
        'LEFT': Coord(x=-1, y=0),
        'RIGHT': Coord(x=1, y=0),
    }

    def __init__(self, size, tiles, r_mapSize, r_mapTiles, Bot):
        self.Bot = Bot
        if self.debug:
            print "Constructing world object. Size: {0}".format(size)
        self.update(size, tiles, r_mapSize, r_mapTiles)

    def setTCoord(self, targetCoord):
        self.targetCoord = targetCoord

    def setTTile(self, targetTile):
        self.targetTile = targetTile

    def update(self, size, tiles, r_mapSize, r_mapTiles):
        if self.debug:
            print "Updating world object. Size: {0}".format(size)

        self.width = size.x
        self.height = size.y
        self.tiles = tiles
        self.r_tiles = r_mapTiles

    def updateTarget(self, currentCoords):

        currentTile = self.getTileFromCoords(currentCoords)
        targetTile = self.path[self.pathIndex]
        center_target_tile = self.getCenterForTile(targetTile).distance(currentCoords)
        # print "The distance is: %s " % center_target_tile

        #targetTile /= self.Bot.factor

        if center_target_tile < 65:
            self.pathIndex += 1
            self.pathIndex %= len(self.path)

        return self.path[self.pathIndex]

    def moveRequired(self, fromTile, toTile):
        for direction, move in self.directions.iteritems():
            if (fromTile + move) == toTile:
                return direction

        return None

    def getCenterForTile(self, tile):
        # XXX Need to find proper Eucledian Coords from array
        # return Coord(x = (tile.x * 2) + (2 / 2),
        #             y = (tile.y * 2) + (2 / 2))
        t_x = (((tile.x * 128) / self.Bot.factor) + (128 / (self.Bot.factor * 2)))
        t_y = (((tile.y * 128) / self.Bot.factor) + (128 / (self.Bot.factor * 2)))
        return Coord(x=t_x, y=t_y)

        # return Coord(x=tile.x, y=tile.y)
        # return Coord(x=(((tile.x * 128)/2)),
        #              y=(((tile.y * 128)/2)))

    def getCorneringPointForTile(self, tile):
        tt = self.tiles[tile.y][tile.x]
        # How much we should cut the corners for speeeeed
        of = self.offsetAmount

        if tt == ",":
            offset = Coord(x=-of, y=-of)
        elif tt == "/":
            offset = Coord(x=of, y=of)
        elif tt == "\\":
            offset = Coord(x=of, y=-of)
        elif tt == "`":
            offset = Coord(x=-of, y=of)
        else:
            offset = Coord(x=0, y=0)

        return (self.getCenterForTile(tile) + offset)

    def getTileFromCoords(self, coords):
        # XXX NEEDS FIXING MAGICAL CONASTAN
        c_x = int(math.floor((coords.x / (128.0 / self.Bot.factor))))
        c_y = int(math.floor((coords.y / (128.0 / self.Bot.factor))))

        # x = int(math.floor(((coords.x / 128.0))))
        # y = int(math.floor(((coords.y / 128.0))))
        # x = int((coords.x / 128) * self.Bot.factor)
        # y = int((coords.y / 128) * self.Bot.factor)
        # x = clamp(x, 0, self.width)
        # y = clamp(y, 0, self.height)

        return Coord(x=c_x, y=c_y)

    def isInsideMap(self, p):
        return (p.x < self.width and
                p.y < self.height and
                p.x > -1 and p.y > -1)

    def passableTile(self, tile):
        return True
        # return (self.tiles[tile.y][tile.x] != ".")

    def offsetTile(self, tile):
        try:
            for x in range(1, self.Bot.factor/2):
                a = self.tiles[tile.y+x][tile.x]
                a = self.tiles[tile.y-x][tile.x]
                a = self.tiles[tile.y][tile.x+x]
                a = self.tiles[tile.y][tile.x-x]
                a = self.tiles[tile.y+x][tile.x+x]
                a = self.tiles[tile.y-x][tile.x-x]
        except:
            return True

        if self.tiles[tile.y][tile.x] == r"|":
            for x in range(1, self.Bot.factor/2):
                if (self.tiles[tile.y][tile.x+x] == "." or
                   self.tiles[tile.y][tile.x-x] == "."):
                    return False
        elif self.tiles[tile.y][tile.x] == r"-":
            for x in range(1, self.Bot.factor/2):
                if (self.tiles[tile.y+x][tile.x] == "." or
                   self.tiles[tile.y-x][tile.x] == "."):
                    return False
        return True

    def possibleMoves(self, pos):
        moves = []
        # Iterates over all possible directions
        for direction, move in self.directions.iteritems():
            tile = pos + move

            # Check if the direction puts us outside map
            if self.isInsideMap(tile):

                # Check if the direction puts us on a passable tile
                if self.passableTile(tile):

                    if self.offsetTile(tile):
                        moves.append(direction)
        return moves

    def createGraph(self):
        graph = {}
        nodes = [[AStarGridNode(x, y, self, self.Bot.factor) for x in range(self.width)]
                 for y in range(self.height)]

        for y, x in product(range(self.height), range(self.width)):
            currentTile = Coord(x=x, y=y)
            node = nodes[y][x]
            graph[node] = []
            moves = self.possibleMoves(currentTile)
            # print "{0} possible moves for {1}".format(moves, currentTile)
            for move in moves:
                target = currentTile + self.directions[move]
                graph[node].append(nodes[target.y][target.x])

        return graph, nodes

    def search(self, start, end):
        if self.debug:
            print "Looking for path from {0} to {1}".format(start, end)

        if end is None:
            return []

        if (start == end):
            return []

        # if(self.graph == None or self.nodes == None):
        self.graph, self.nodes = self.createGraph()

        if self.nodes is None:
            return "No nodes"

        if self.graph is None:
            return "No Graph"

        astar = AStarGrid(self.graph)
        start, end = self.nodes[start.y][start.x], self.nodes[end.y][end.x]
        path = astar.search(start, end)

        if path is None:
            return None

        # Convert found path to sequence of coordinates
        path = [Coord(x=tile.x, y=tile.y) for tile in path]

        # Remove first tile since this is our starting point and is not needed
        return path[1::]
        # return path
