from astar import AStar, AStarNode
from math import sqrt
from coord import Coord


class AStarGrid(AStar):
    def heuristic(self, node, start, end):
        return sqrt((end.x - node.x) ** 2 + (end.y - node.y) ** 2)


class AStarGridNode(AStarNode):
    def __init__(self, x, y, World, factor):
        self.World = World
        self.factor = factor
        self.tiles = self.World.tiles
        self.x, self.y = x, y
        super(AStarGridNode, self).__init__()

    def move_cost(self, other):
        # print "[x=%d y=%d]" % (self.x, self.y),
        diagonal = abs(self.x-other.x) == 1 and abs(self.y-other.y) == 1
        return 9 if diagonal else self.offsetTile(Coord(x=self.x, y=self.y))

    def offsetTile(self, tile):
        try:
            x_p = tile.x % self.factor
            y_p = tile.y % self.factor

            if self.tiles[tile.y][tile.x] == r"/":
                if y_p == 0 or x_p == 0:
                    return 100
                elif y_p == self.factor - 1 and x_p == self.factor-1:
                    return 100
            elif self.tiles[tile.y][tile.x] == r"|":
                if x_p == 0 or x_p == self.factor - 1:
                    return 100
            elif self.tiles[tile.y][tile.x] == r"+":
                if x_p == 0 and y_p == 0:
                    return 100
                if x_p == 0 and y_p == self.factor -1:
                    return 100
                if x_p == self.factor - 1 and y_p == self.factor -1:
                    return 100
                if x_p == self.factor - 1 and y_p == 0:
                    return 100
            elif self.tiles[tile.y][tile.x] == r"-":
                if y_p == 0 or y_p == self.factor - 1:
                    return 100
            elif self.tiles[tile.y][tile.x] == r"`":
                if y_p == 0 or x_p == self.factor - 1:
                    return 100
                elif y_p == self.factor -1 and x_p == 0:
                    return 100
            elif self.tiles[tile.y][tile.x] == r",":
                if y_p == self.factor - 1 or x_p == self.factor - 1:
                    return 100
                elif y_p == 0 and x_p == 0:
                    return 100
            elif self.tiles[tile.y][tile.x] == r".":
                return 400
            elif self.tiles[tile.y][tile.x] == r"\\":
                if y_p == self.factor - 1 or x_p == 0:
                    return 100
                elif y_p == 0 and x_p == self.factor-1:
                    return 100
            return 10
        except:
            return 10

    def __repr__(self):
        return "{0}x{1}".format(self.x, self.y)

    def __str__(self):
        return "{0}x{1}".format(self.x, self.y)
