#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER
#extension GL_EXT_gpu_shader4 : enable

uniform float iGlobalTime;
uniform sampler2D texture;

varying vec4 vertColor;
varying vec4 vertTexCoord;

float rand(vec2 co)
{
    return fract(sin(dot(co.xy, vec2(12.9898,78.233)) + iGlobalTime) * 43758.5453);
}

void main()
{
	vec4 coord = vertTexCoord;
	vec3 color = texture2D(texture, coord.xy);
	vec3 leftColor = texture2D(texture, vec2(coord.x - 0.005, coord.y));
	if ((color.x + color.y + color.z) / 3.0 > 0.8 &&
	    (leftColor.x + leftColor.y + leftColor.z) / 3.0 < 0.2)
	{
		gl_FragColor = vec4(color * rand(coord.xy), 1.0);
	}
	else
	{
		gl_FragColor = vec4(color, 1.0) * vertColor;
	}
}