/*
 * Decompiled with CFR 0.152.
 */
package processing.dxf;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import processing.core.PGraphics;

public class RawDXF
extends PGraphics {
    File file;
    PrintWriter writer;
    int currentLayer;

    public void setPath(String string) {
        this.path = string;
        if (string != null) {
            this.file = new File(string);
            if (!this.file.isAbsolute()) {
                this.file = null;
            }
        }
        if (this.file == null) {
            throw new RuntimeException("PGraphicsPDF requires an absolute path for the location of the output file.");
        }
    }

    protected void allocate() {
        this.setLayer(0);
    }

    public void dispose() {
        this.writeFooter();
        this.writer.flush();
        this.writer.close();
        this.writer = null;
    }

    public boolean displayable() {
        return false;
    }

    public boolean is2D() {
        return false;
    }

    public boolean is3D() {
        return true;
    }

    public void beginDraw() {
        if (this.writer == null) {
            try {
                this.writer = new PrintWriter(new FileWriter(this.file));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.writeHeader();
        }
    }

    public void endDraw() {
        this.writer.flush();
    }

    public void setLayer(int n) {
        this.currentLayer = n;
    }

    private void writeHeader() {
        this.writer.println("0");
        this.writer.println("SECTION");
        this.writer.println("2");
        this.writer.println("ENTITIES");
    }

    private void writeFooter() {
        this.writer.println("0");
        this.writer.println("ENDSEC");
        this.writer.println("0");
        this.writer.println("EOF");
    }

    public void write(String string, float f) {
        this.writer.println(string);
        this.writer.println(f);
    }

    public void println(String string) {
        this.writer.println(string);
    }

    protected void writeLine(int n, int n2) {
        this.writer.println("0");
        this.writer.println("LINE");
        this.writer.println("8");
        this.writer.println(String.valueOf(this.currentLayer));
        this.write("10", this.vertices[n][0]);
        this.write("20", this.vertices[n][1]);
        this.write("30", this.vertices[n][2]);
        this.write("11", this.vertices[n2][0]);
        this.write("21", this.vertices[n2][1]);
        this.write("31", this.vertices[n2][2]);
    }

    protected void writeTriangle() {
        this.writer.println("0");
        this.writer.println("3DFACE");
        this.writer.println("8");
        this.writer.println(String.valueOf(this.currentLayer));
        this.write("10", this.vertices[0][0]);
        this.write("20", this.vertices[0][1]);
        this.write("30", this.vertices[0][2]);
        this.write("11", this.vertices[1][0]);
        this.write("21", this.vertices[1][1]);
        this.write("31", this.vertices[1][2]);
        this.write("12", this.vertices[2][0]);
        this.write("22", this.vertices[2][1]);
        this.write("32", this.vertices[2][2]);
        this.write("13", this.vertices[2][0] + 1.0E-4f);
        this.write("23", this.vertices[2][1] + 1.0E-4f);
        this.write("33", this.vertices[2][2] + 1.0E-4f);
        this.vertexCount = 0;
    }

    public void beginShape(int n) {
        this.shape = n;
        if (this.shape != 5 && this.shape != 9 && this.shape != 20) {
            String string = "RawDXF can only be used with beginRaw(), because it only supports lines and triangles";
            throw new RuntimeException(string);
        }
        if (this.shape == 20 && this.fill) {
            throw new RuntimeException("RawDXF only supports non-filled shapes.");
        }
        this.vertexCount = 0;
    }

    public void vertex(float f, float f2) {
        this.vertex(f, f2, 0.0f);
    }

    public void vertex(float f, float f2, float f3) {
        float[] fArray = this.vertices[this.vertexCount];
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        if (this.fill) {
            fArray[3] = this.fillR;
            fArray[4] = this.fillG;
            fArray[5] = this.fillB;
            fArray[6] = this.fillA;
        }
        if (this.stroke) {
            fArray[13] = this.strokeR;
            fArray[14] = this.strokeG;
            fArray[15] = this.strokeB;
            fArray[16] = this.strokeA;
            fArray[17] = this.strokeWeight;
        }
        if (this.textureImage != null) {
            fArray[7] = this.textureU;
            fArray[8] = this.textureV;
        }
        ++this.vertexCount;
        if (this.shape == 5 && this.vertexCount == 2) {
            this.writeLine(0, 1);
            this.vertexCount = 0;
        } else if (this.shape == 9 && this.vertexCount == 3) {
            this.writeTriangle();
        }
    }

    public void endShape(int n) {
        if (this.shape == 20) {
            int n2 = 0;
            while (n2 < this.vertexCount - 1) {
                this.writeLine(n2, n2 + 1);
                ++n2;
            }
            if (n == 2) {
                this.writeLine(this.vertexCount - 1, 0);
            }
        }
    }
}

