/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.app.contrib.ModeContribution;
import processing.core.PApplet;
import processing.mode.java.JavaBuild;
import processing.mode.java.JavaMode;
import processing.mode.java.runner.Runner;

public class Commander
implements RunnerListener {
    static final String helpArg = "--help";
    static final String buildArg = "--build";
    static final String runArg = "--run";
    static final String presentArg = "--present";
    static final String sketchArg = "--sketch=";
    static final String forceArg = "--force";
    static final String outputArg = "--output=";
    static final String exportApplicationArg = "--export";
    static final String noJavaArg = "--no-java";
    static final String platformArg = "--platform=";
    static final String bitsArg = "--bits=";
    static final int HELP = -1;
    static final int PREPROCESS = 0;
    static final int BUILD = 1;
    static final int RUN = 2;
    static final int PRESENT = 3;
    static final int EXPORT = 4;
    Sketch sketch;
    PrintStream systemOut;
    PrintStream systemErr;

    public static void main(String[] args) {
        Base.setCommandLine();
        Base.initPlatform();
        Base.initRequirements();
        new Commander(args);
    }

    public Commander(String[] args) {
        String sketchPath = null;
        File sketchFolder = null;
        String pdePath = null;
        String outputPath = null;
        File outputFolder = null;
        boolean force = false;
        int platform = PApplet.platform;
        int platformBits = Base.getNativeBits();
        int task = -1;
        boolean embedJava = true;
        try {
            this.systemOut = new PrintStream((OutputStream)System.out, true, "UTF-8");
            this.systemErr = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.length() != 0 && !arg.equals(helpArg)) {
                if (arg.equals(buildArg)) {
                    task = 1;
                } else if (arg.equals(runArg)) {
                    task = 2;
                } else if (arg.equals(presentArg)) {
                    task = 3;
                } else if (arg.equals(exportApplicationArg)) {
                    task = 4;
                } else if (arg.equals(noJavaArg)) {
                    embedJava = false;
                } else if (arg.startsWith(platformArg)) {
                    this.complainAndQuit("The --platform option has been removed from Processing 2.1.", false);
                } else if (arg.startsWith(bitsArg)) {
                    this.complainAndQuit("The --bits option has been removed from Processing 2.1.", false);
                } else if (arg.startsWith(sketchArg)) {
                    File pdeFile;
                    sketchPath = arg.substring(sketchArg.length());
                    sketchFolder = new File(sketchPath);
                    if (!sketchFolder.exists()) {
                        this.complainAndQuit(sketchFolder + " does not exist.", false);
                    }
                    if (!(pdeFile = new File(sketchFolder, String.valueOf(sketchFolder.getName()) + ".pde")).exists()) {
                        this.complainAndQuit("Not a valid sketch folder. " + pdeFile + " does not exist.", true);
                    }
                    pdePath = pdeFile.getAbsolutePath();
                } else if (arg.startsWith(outputArg)) {
                    outputPath = arg.substring(outputArg.length());
                } else if (arg.equals(forceArg)) {
                    force = true;
                } else {
                    this.complainAndQuit("I don't know anything about " + arg + ".", true);
                }
            }
            ++n2;
        }
        if (task == -1) {
            Commander.printCommandLine(this.systemOut);
            System.exit(0);
        }
        if (outputPath == null) {
            this.complainAndQuit("An output path must be specified.", true);
        }
        if ((outputFolder = new File(outputPath)).exists()) {
            if (force) {
                Base.removeDir(outputFolder);
            } else {
                this.complainAndQuit("The output folder already exists. Use --force to remove it.", false);
            }
        }
        if (!outputFolder.mkdirs()) {
            this.complainAndQuit("Could not create the output folder.", false);
        }
        Preferences.init();
        Base.locateSketchbookFolder();
        if (sketchPath == null) {
            this.complainAndQuit("No sketch path specified.", true);
        } else if (outputPath.equals(sketchPath)) {
            this.complainAndQuit("The sketch path and output path cannot be identical.", false);
        } else {
            boolean success = false;
            JavaMode javaMode = (JavaMode)ModeContribution.load(null, Base.getContentFile("modes/java"), "processing.mode.java.JavaMode").getMode();
            try {
                this.sketch = new Sketch(pdePath, javaMode);
                if (task == 1 || task == 2 || task == 3) {
                    JavaBuild build = new JavaBuild(this.sketch);
                    File srcFolder = new File(outputFolder, "source");
                    String className = build.build(srcFolder, outputFolder, true);
                    if (className != null) {
                        success = true;
                        if (task == 2 || task == 3) {
                            Runner runner = new Runner(build, this);
                            runner.launch(task == 3);
                        }
                    } else {
                        success = false;
                    }
                } else if (task == 4) {
                    if (outputPath == null) {
                        javaMode.handleExportApplication(this.sketch);
                    } else {
                        JavaBuild build = new JavaBuild(this.sketch);
                        build.build(true);
                        if (build != null) {
                            success = build.exportApplication(outputFolder, platform, platformBits, embedJava);
                        }
                    }
                }
                if (!success) {
                    System.exit(1);
                }
                this.systemOut.println("Finished.");
                System.exit(0);
            }
            catch (SketchException re) {
                this.statusError(re);
                System.exit(1);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    @Override
    public void statusNotice(String message) {
        this.systemErr.println(message);
    }

    @Override
    public void statusError(String message) {
        this.systemErr.println(message);
    }

    @Override
    public void statusError(Exception exception) {
        if (exception instanceof SketchException) {
            SketchException re = (SketchException)exception;
            int codeIndex = re.getCodeIndex();
            if (codeIndex != -1) {
                String filename = this.sketch.getCode(codeIndex).getFileName();
                int line = re.getCodeLine() + 1;
                int column = re.getCodeColumn() + 1;
                this.systemErr.println(String.valueOf(filename) + ":" + line + ":" + column + ":" + line + ":" + column + ":" + " " + re.getMessage());
            } else {
                exception.printStackTrace();
            }
        } else {
            exception.printStackTrace();
        }
    }

    void complainAndQuit(String lastWords, boolean schoolEmFirst) {
        if (schoolEmFirst) {
            Commander.printCommandLine(this.systemErr);
        }
        this.systemErr.println(lastWords);
        System.exit(1);
    }

    static void printCommandLine(PrintStream out) {
        out.println();
        out.println("Command line edition for Processing " + Base.getVersionName() + " (Java Mode)");
        out.println();
        out.println("--help               Show this help text. Congratulations.");
        out.println();
        out.println("--sketch=<name>      Specify the sketch folder (required)");
        out.println("--output=<name>      Specify the output folder (required and");
        out.println("                     cannot be the same as the sketch folder.)");
        out.println();
        out.println("--force              The sketch will not build if the output");
        out.println("                     folder already exists, because the contents");
        out.println("                     will be replaced. This option erases the");
        out.println("                     folder first. Use with extreme caution!");
        out.println();
        out.println("--build              Preprocess and compile a sketch into .class files.");
        out.println("--run                Preprocess, compile, and run a sketch.");
        out.println("--present            Preprocess, compile, and run a sketch full screen.");
        out.println();
        out.println("--export             Export an application.");
        out.println("--no-java            Do not embed Java. Use at your own risk!");
        out.println();
    }

    @Override
    public void startIndeterminate() {
    }

    @Override
    public void stopIndeterminate() {
    }

    @Override
    public void statusHalt() {
    }

    @Override
    public boolean isHalted() {
        return false;
    }
}

