/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Sketch;
import processing.app.tools.Tool;
import processing.core.PApplet;

public class Archiver
implements Tool {
    Editor editor;
    boolean useDate;
    int digits = 3;
    NumberFormat numberFormat;
    SimpleDateFormat dateFormat;

    @Override
    public String getMenuTitle() {
        return "Archive Sketch";
    }

    @Override
    public void init(Editor editor) {
        this.editor = editor;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMinimumIntegerDigits(this.digits);
        this.dateFormat = new SimpleDateFormat("yyMMdd");
    }

    @Override
    public void run() {
        Sketch sketch = this.editor.getSketch();
        if (sketch.isModified()) {
            Base.showWarning("Save", "Please save the sketch before archiving.", null);
            return;
        }
        File location = sketch.getFolder();
        String name = location.getName();
        File parent = new File(location.getParent());
        File newbie = null;
        String namely = null;
        int index = 0;
        do {
            boolean bl = this.useDate = !name.startsWith("sketch_");
            if (this.useDate) {
                String purty = this.dateFormat.format(new Date());
                String stamp = String.valueOf(purty) + (char)(97 + index);
                namely = String.valueOf(name) + "-" + stamp;
                newbie = new File(parent, String.valueOf(namely) + ".zip");
            } else {
                String diggie = this.numberFormat.format(index + 1);
                namely = String.valueOf(name) + "-" + diggie;
                newbie = new File(parent, String.valueOf(namely) + ".zip");
            }
            ++index;
        } while (newbie.exists());
        PApplet.selectOutput((String)"Archive sketch as...", (String)"fileSelected", (File)newbie, (Object)this, (Frame)this.editor);
    }

    public void fileSelected(File newbie) {
        if (newbie != null) {
            try {
                if (!newbie.getName().toLowerCase().endsWith(".zip")) {
                    newbie = new File(String.valueOf(newbie.getAbsolutePath()) + ".zip");
                }
                FileOutputStream zipOutputFile = new FileOutputStream(newbie);
                ZipOutputStream zos = new ZipOutputStream(zipOutputFile);
                File sketchFolder = this.editor.getSketch().getFolder();
                this.buildZip(sketchFolder, sketchFolder.getName(), zos);
                zos.flush();
                zos.close();
                this.editor.statusNotice("Created archive " + newbie.getName() + ".");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.editor.statusNotice("Archive sketch canceled.");
        }
    }

    public void buildZip(File dir, String sofar, ZipOutputStream zos) throws IOException {
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            if (!files[i].equals(".") && !files[i].equals("..")) {
                ZipEntry entry;
                String nowfar;
                File sub = new File(dir, files[i]);
                String string = nowfar = sofar == null ? files[i] : String.valueOf(sofar) + "/" + files[i];
                if (sub.isDirectory()) {
                    entry = new ZipEntry(String.valueOf(nowfar) + "/");
                    zos.putNextEntry(entry);
                    zos.closeEntry();
                    this.buildZip(sub, nowfar, zos);
                } else {
                    entry = new ZipEntry(nowfar);
                    entry.setTime(sub.lastModified());
                    zos.putNextEntry(entry);
                    zos.write(Base.loadBytesRaw(sub));
                    zos.closeEntry();
                }
            }
            ++i;
        }
    }
}

