/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShlObj;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.io.UnsupportedEncodingException;
import processing.app.Base;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.platform.WindowsRegistry;
import processing.core.PApplet;

public class WindowsPlatform
extends Platform {
    static final String APP_NAME = "Processing";
    static final String REG_OPEN_COMMAND = String.valueOf(System.getProperty("user.dir").replace('/', '\\')) + "\\" + "Processing".toLowerCase() + ".exe \"%1\"";
    static final String REG_DOC = "Processing.Document";
    static WinLibC clib = (WinLibC)Native.loadLibrary((String)"msvcrt", WinLibC.class);

    @Override
    public void init(Base base) {
        super.init(base);
        this.checkAssociations();
        this.checkPath();
    }

    protected void checkAssociations() {
        try {
            String knownCommand;
            if (Preferences.getBoolean("platform.auto_file_type_associations") && ((knownCommand = WindowsRegistry.getStringValue(WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER, "Software\\Classes\\Processing.Document\\shell\\open\\command", "")) == null || !knownCommand.equals(REG_OPEN_COMMAND))) {
                this.setAssociations();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setAssociations() throws UnsupportedEncodingException {
        WindowsRegistry.REGISTRY_ROOT_KEY rootKey = WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER;
        if (!(WindowsRegistry.createKey(rootKey, "Software\\Classes", ".pde") && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\.pde", "", REG_DOC) && WindowsRegistry.createKey(rootKey, "Software\\Classes", REG_DOC) && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\Processing.Document", "", "Processing Source Code") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document", "shell") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document\\shell", "open") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document\\shell\\open", "command") && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\Processing.Document\\shell\\open\\command", "", REG_OPEN_COMMAND))) {
            Base.log("Could not associate files, turning off auto-associate pref.");
            Preferences.setBoolean("platform.auto_file_type_associations", false);
        }
    }

    protected void checkPath() {
        String path = System.getProperty("java.library.path");
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        String[] legit = new String[pieces.length];
        int legitCount = 0;
        String[] stringArray = pieces;
        int n = pieces.length;
        int n2 = 0;
        while (n2 < n) {
            File directory;
            String item = stringArray[n2];
            if (item.startsWith("\"")) {
                item = item.substring(1);
            }
            if (item.endsWith("\"")) {
                item = item.substring(0, item.length() - 1);
            }
            if (item.endsWith(File.separator)) {
                item = item.substring(0, item.length() - File.separator.length());
            }
            if ((directory = new File(item)).exists() && item.trim().length() != 0) {
                legit[legitCount++] = item;
            }
            ++n2;
        }
        String newPath = PApplet.join((String[])(legit = PApplet.subset((String[])legit, (int)0, (int)legitCount)), (String)File.pathSeparator);
        if (!newPath.equals(path)) {
            System.setProperty("java.library.path", newPath);
        }
    }

    @Override
    public File getSettingsFolder() throws Exception {
        String appData = WindowsPlatform.getAppDataPath();
        if (appData != null) {
            return new File(appData, APP_NAME);
        }
        return null;
    }

    private static String getAppDataPath() throws Exception {
        char[] pszPath = new char[260];
        WinNT.HRESULT hResult = Shell32.INSTANCE.SHGetFolderPath(null, 26, null, ShlObj.SHGFP_TYPE_CURRENT, pszPath);
        if (!hResult.equals((Object)WinError.S_OK)) {
            System.err.println(Kernel32Util.formatMessageFromHR((WinNT.HRESULT)hResult));
            throw new Exception("Problem city, population: your computer.");
        }
        String appDataPath = new String(pszPath);
        int len = appDataPath.indexOf("\u0000");
        return appDataPath.substring(0, len);
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        String documentsPath = WindowsPlatform.getDocumentsPath();
        if (documentsPath != null) {
            return new File(documentsPath, APP_NAME);
        }
        return null;
    }

    private static String getDocumentsPath() throws Exception {
        char[] pszPath = new char[260];
        WinNT.HRESULT hResult = Shell32.INSTANCE.SHGetFolderPath(null, 5, null, ShlObj.SHGFP_TYPE_CURRENT, pszPath);
        if (!hResult.equals((Object)WinError.S_OK)) {
            System.err.println(Kernel32Util.formatMessageFromHR((WinNT.HRESULT)hResult));
            throw new Exception("Problem city, population: your computer.");
        }
        String personalPath = new String(pszPath);
        int len = personalPath.indexOf("\u0000");
        return personalPath.substring(0, len);
    }

    @Override
    public void setenv(String variable, String value) {
        clib._putenv(String.valueOf(variable) + "=" + value);
    }

    @Override
    public String getenv(String variable) {
        return System.getenv(variable);
    }

    @Override
    public int unsetenv(String variable) {
        return clib._putenv(String.valueOf(variable) + "=");
    }

    public static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

