/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ProgressMonitor;
import processing.app.contrib.StatusPanel;

public abstract class LocalContribution
extends Contribution {
    public static final String DELETION_FLAG = "marked_for_deletion";
    public static final String RESTART_FLAG = "requires_restart";
    protected String id;
    protected int latestVersion;
    protected File folder;
    protected HashMap<String, String> properties;
    protected ClassLoader loader;

    public LocalContribution(File folder) {
        this.folder = folder;
        File propertiesFile = new File(folder, String.valueOf(this.getTypeName()) + ".properties");
        if (propertiesFile.exists()) {
            this.properties = Base.readSettings(propertiesFile);
            this.name = this.properties.get("name");
            this.id = this.properties.get("id");
            this.categories = LocalContribution.parseCategories(this.properties.get("category"));
            if (this.name == null) {
                this.name = folder.getName();
            }
            this.authorList = this.properties.get("authorList");
            this.url = this.properties.get("url");
            this.sentence = this.properties.get("sentence");
            this.paragraph = this.properties.get("paragraph");
            try {
                this.version = Integer.parseInt(this.properties.get("version"));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("The version number for the \u201c" + this.name + "\u201d library is not set properly.");
                System.err.println("Please contact the library author to fix it according to the guidelines.");
            }
            this.prettyVersion = this.properties.get("prettyVersion");
        } else {
            Base.log("No properties file at " + propertiesFile.getAbsolutePath());
            this.name = folder.getName();
            this.categories = LocalContribution.defaultCategory();
        }
    }

    public String initLoader(String className) throws Exception {
        File modeDirectory = new File(this.folder, this.getTypeName());
        if (modeDirectory.exists()) {
            File[] archives;
            Base.log("checking mode folder regarding " + className);
            if (className == null) {
                String shortName = this.folder.getName();
                File mainJar = new File(modeDirectory, String.valueOf(shortName) + ".jar");
                if (!mainJar.exists()) {
                    throw new IgnorableException(String.valueOf(mainJar.getAbsolutePath()) + " does not exist.");
                }
                className = LocalContribution.findClassInZipFile(shortName, mainJar);
                if (className == null) {
                    throw new IgnorableException("Could not find " + shortName + " class inside " + mainJar.getAbsolutePath());
                }
            }
            if ((archives = Base.listJarFiles(modeDirectory)) != null && archives.length > 0) {
                URL[] urlList = new URL[archives.length];
                int j = 0;
                while (j < urlList.length) {
                    Base.log("Found archive " + archives[j] + " for " + this.getName());
                    urlList[j] = archives[j].toURI().toURL();
                    ++j;
                }
                this.loader = new URLClassLoader(urlList);
                Base.log("loading above JARs with loader " + this.loader);
            }
        }
        if (this.loader == null) {
            this.loader = Thread.currentThread().getContextClassLoader();
        }
        return className;
    }

    LocalContribution copyAndLoad(Editor editor, boolean confirmReplace, StatusPanel status) {
        ArrayList<LocalContribution> oldContribs = this.getType().listContributions(editor);
        String contribFolderName = this.getFolder().getName();
        File contribTypeFolder = this.getType().getSketchbookFolder();
        File contribFolder = new File(contribTypeFolder, contribFolderName);
        for (LocalContribution oldContrib : oldContribs) {
            if ((!oldContrib.getFolder().exists() || !oldContrib.getFolder().equals(contribFolder)) && (oldContrib.getId() == null || !oldContrib.getId().equals(this.getId()))) continue;
            if (oldContrib.getType().requiresRestart()) {
                if (oldContrib.backup(editor, false, status)) continue;
                return null;
            }
            int result = 0;
            boolean doBackup = Preferences.getBoolean("contribution.backup.on_install");
            if (!(confirmReplace ? (doBackup ? (result = Base.showYesNoQuestion(editor, "Replace", "Replace pre-existing \"" + oldContrib.getName() + "\" library?", "A pre-existing copy of the \"" + oldContrib.getName() + "\" library<br>" + "has been found in your sketchbook. Clicking \u201cYes\u201d<br>" + "will move the existing library to a backup folder<br>" + "in <i>libraries/old</i> before replacing it.")) != 0 || !oldContrib.backup(editor, true, status) : (result = Base.showYesNoQuestion(editor, "Replace", "Replace pre-existing \"" + oldContrib.getName() + "\" library?", "A pre-existing copy of the \"" + oldContrib.getName() + "\" library<br>" + "has been found in your sketchbook. Clicking \u201cYes\u201d<br>" + "will permanently delete this library and all of its contents<br>" + "before replacing it.")) != 0 || !oldContrib.getFolder().delete()) : doBackup && !oldContrib.backup(editor, true, status) || !doBackup && !oldContrib.getFolder().delete())) continue;
            return null;
        }
        if (contribFolder.exists()) {
            Base.removeDir(contribFolder);
        }
        File oldFolder = this.getFolder();
        try {
            Base.copyDir(oldFolder, contribFolder);
        }
        catch (IOException e) {
            status.setErrorMessage("Could not copy " + this.getTypeName() + " \"" + this.getName() + "\" to the sketchbook.");
            e.printStackTrace();
            return null;
        }
        return this.getType().load(editor.getBase(), contribFolder);
    }

    boolean backup(Editor editor, boolean deleteOriginal, StatusPanel status) {
        File backupFolder = this.getType().createBackupFolder(status);
        boolean success = false;
        if (backupFolder != null) {
            String libFolderName = this.getFolder().getName();
            String prefix = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            String backupName = String.valueOf(prefix) + " " + libFolderName;
            File backupSubFolder = ContributionManager.getUniqueName(backupFolder, backupName);
            if (deleteOriginal) {
                success = this.getFolder().renameTo(backupSubFolder);
            } else {
                try {
                    Base.copyDir(this.getFolder(), backupSubFolder);
                    success = true;
                }
                catch (IOException iOException) {}
            }
            if (!success) {
                status.setErrorMessage("Could not move contribution to backup folder.");
            }
        }
        return success;
    }

    void removeContribution(final Editor editor, final ProgressMonitor pm, final StatusPanel status) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LocalContribution.this.remove(editor, pm, status, ContributionListing.getInstance());
            }
        }).start();
    }

    void remove(Editor editor, ProgressMonitor pm, StatusPanel status, ContributionListing contribListing) {
        pm.startTask("Removing", -1);
        boolean doBackup = Preferences.getBoolean("contribution.backup.on_remove");
        if (this.getType().requiresRestart()) {
            if ((!doBackup || doBackup && this.backup(editor, false, status)) && this.setDeletionFlag(true)) {
                contribListing.replaceContribution(this, this);
            }
        } else {
            boolean success = false;
            if (doBackup) {
                success = this.backup(editor, true, status);
            } else {
                Base.removeDir(this.getFolder());
                boolean bl = success = !this.getFolder().exists();
            }
            if (success) {
                AvailableContribution advertisedVersion = contribListing.getAvailableContribution(this);
                if (advertisedVersion == null) {
                    contribListing.removeContribution(this);
                } else {
                    contribListing.replaceContribution(this, advertisedVersion);
                }
            } else if (!doBackup) {
                status.setErrorMessage("Could not delete the contribution's files");
            }
        }
        ContributionManager.refreshInstalled(editor);
        pm.finished();
    }

    public File getFolder() {
        return this.folder;
    }

    @Override
    public boolean isInstalled() {
        return this.folder != null;
    }

    public String getId() {
        return this.id;
    }

    public int getLatestVersion() {
        return this.latestVersion;
    }

    boolean setDeletionFlag(boolean flag) {
        return this.setFlag(DELETION_FLAG, flag);
    }

    @Override
    boolean isDeletionFlagged() {
        return LocalContribution.isDeletionFlagged(this.getFolder());
    }

    static boolean isDeletionFlagged(File folder) {
        return LocalContribution.isFlagged(folder, DELETION_FLAG);
    }

    boolean setRestartFlag() {
        return this.setFlag(RESTART_FLAG, true);
    }

    @Override
    boolean isRestartFlagged() {
        return LocalContribution.isFlagged(this.getFolder(), RESTART_FLAG);
    }

    static void clearRestartFlags(File folder) {
        File restartFlag = new File(folder, RESTART_FLAG);
        if (restartFlag.exists()) {
            restartFlag.delete();
        }
    }

    private boolean setFlag(String flagFilename, boolean flag) {
        if (flag) {
            try {
                new File(this.getFolder(), flagFilename).createNewFile();
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return new File(this.getFolder(), flagFilename).delete();
    }

    private static boolean isFlagged(File folder, String flagFilename) {
        return new File(folder, flagFilename).exists();
    }

    protected static String findClassInZipFile(String base, File file) {
        String classFileName = "/" + base + ".class";
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(classFileName)) continue;
                zipFile.close();
                return name.substring(0, name.length() - 6).replace('/', '.');
            }
            zipFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static class IgnorableException
    extends Exception {
        public IgnorableException(String msg) {
            super(msg);
        }
    }
}

