/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import processing.app.Base;
import processing.app.Editor;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.JProgressMonitor;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ProgressMonitor;
import processing.app.contrib.StatusPanel;

public class ContributionManager {
    public static final ContributionListing contribListing = ContributionListing.getInstance();

    static boolean download(URL source, File dest, ProgressMonitor progress) {
        boolean success = false;
        try {
            int amount;
            HttpURLConnection conn = (HttpURLConnection)source.openConnection();
            HttpURLConnection.setFollowRedirects(true);
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(60000);
            conn.setRequestMethod("GET");
            conn.connect();
            int fileSize = conn.getContentLength();
            progress.startTask("Downloading", fileSize);
            InputStream in = conn.getInputStream();
            FileOutputStream out = new FileOutputStream(dest);
            byte[] b = new byte[8192];
            int total = 0;
            while (!progress.isCanceled() && (amount = in.read(b)) != -1) {
                out.write(b, 0, amount);
                progress.setProgress(total += amount);
            }
            out.flush();
            out.close();
            success = true;
        }
        catch (SocketTimeoutException ste) {
            progress.error(ste);
        }
        catch (IOException ioe) {
            progress.error(ioe);
            ioe.printStackTrace();
        }
        progress.finished();
        return success;
    }

    static void downloadAndInstall(final Editor editor, final URL url, final AvailableContribution ad, final JProgressMonitor downloadProgress, final JProgressMonitor installProgress, final StatusPanel status) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String filename = url.getFile();
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                try {
                    File contribZip = File.createTempFile("download", filename);
                    contribZip.setWritable(true);
                    try {
                        ContributionManager.download(url, contribZip, downloadProgress);
                        if (!downloadProgress.isCanceled() && !downloadProgress.isError()) {
                            installProgress.startTask("Installing...", -1);
                            LocalContribution contribution = ad.install(editor, contribZip, false, status);
                            if (contribution != null) {
                                contribListing.replaceContribution(ad, contribution);
                                ContributionManager.refreshInstalled(editor);
                            }
                            installProgress.finished();
                        }
                        contribZip.delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        status.setErrorMessage("Error during download and install.");
                    }
                }
                catch (IOException iOException) {
                    status.setErrorMessage("Could not write to temporary directory.");
                }
            }
        }).start();
    }

    public static void refreshInstalled(Editor editor) {
        editor.getMode().rebuildImportMenu();
        editor.getMode().resetExamples();
        editor.rebuildToolMenu();
    }

    public static File getUniqueName(File parentFolder, String fileName) {
        String folderName;
        File backupFolderForLib;
        int i = 1;
        do {
            folderName = fileName;
            if (i >= 2) {
                folderName = String.valueOf(folderName) + "(" + i + ")";
            }
            ++i;
        } while ((backupFolderForLib = new File(parentFolder, folderName)).exists());
        return backupFolderForLib;
    }

    public static String getFileName(File libFile) {
        String path = libFile.getPath();
        int lastSeparator = path.lastIndexOf(File.separatorChar);
        String fileName = lastSeparator != -1 ? path.substring(lastSeparator + 1) : path;
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot != -1) {
            return fileName.substring(0, lastDot);
        }
        return fileName;
    }

    public static void cleanup() throws Exception {
        ContributionManager.deleteFlagged(Base.getSketchbookLibrariesFolder());
        ContributionManager.deleteFlagged(Base.getSketchbookModesFolder());
        ContributionManager.deleteFlagged(Base.getSketchbookToolsFolder());
        ContributionManager.clearRestartFlags(Base.getSketchbookModesFolder());
        ContributionManager.clearRestartFlags(Base.getSketchbookToolsFolder());
    }

    private static void deleteFlagged(File root) throws Exception {
        File[] markedForDeletion;
        File[] fileArray = markedForDeletion = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File folder) {
                return folder.isDirectory() && LocalContribution.isDeletionFlagged(folder);
            }
        });
        int n = markedForDeletion.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            Base.removeDir(folder);
            ++n2;
        }
    }

    private static void clearRestartFlags(File root) throws Exception {
        File[] folderList;
        File[] fileArray = folderList = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File folder) {
                return folder.isDirectory();
            }
        });
        int n = folderList.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            LocalContribution.clearRestartFlags(folder);
            ++n2;
        }
    }
}

