/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import processing.app.Base;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionChangeListener;
import processing.app.contrib.ContributionFilter;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ProgressMonitor;
import processing.core.PApplet;

public class ContributionListing {
    static final String LISTING_URL = "http://download.processing.org/contributions.txt";
    static ContributionListing singleInstance;
    File listingFile;
    ArrayList<ContributionChangeListener> listeners = new ArrayList();
    ArrayList<AvailableContribution> advertisedContributions = new ArrayList();
    Map<String, List<Contribution>> librariesByCategory = new HashMap<String, List<Contribution>>();
    ArrayList<Contribution> allContributions = new ArrayList();
    boolean hasDownloadedLatestList;
    ReentrantLock downloadingListingLock = new ReentrantLock();
    static Comparator<Contribution> nameComparator;

    static {
        nameComparator = new Comparator<Contribution>(){

            @Override
            public int compare(Contribution o1, Contribution o2) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        };
    }

    private ContributionListing() {
        this.listingFile = Base.getSettingsFile("contributions.txt");
        this.listingFile.setWritable(true);
        if (this.listingFile.exists()) {
            this.setAdvertisedList(this.listingFile);
        }
    }

    static ContributionListing getInstance() {
        if (singleInstance == null) {
            singleInstance = new ContributionListing();
        }
        return singleInstance;
    }

    void setAdvertisedList(File file) {
        this.listingFile = file;
        this.advertisedContributions.clear();
        this.advertisedContributions.addAll(this.parseContribList(this.listingFile));
        for (Contribution contribution : this.advertisedContributions) {
            this.addContribution(contribution);
        }
        Collections.sort(this.allContributions, nameComparator);
    }

    protected void updateInstalledList(List<Contribution> installedContributions) {
        for (Contribution contribution : installedContributions) {
            Contribution existingContribution = this.getContribution(contribution);
            if (existingContribution != null) {
                this.replaceContribution(existingContribution, contribution);
                continue;
            }
            this.addContribution(contribution);
        }
    }

    protected void replaceContribution(Contribution oldLib, Contribution newLib) {
        if (oldLib != null && newLib != null) {
            for (String category : oldLib.getCategories()) {
                if (!this.librariesByCategory.containsKey(category)) continue;
                List<Contribution> list = this.librariesByCategory.get(category);
                int i = 0;
                while (i < list.size()) {
                    if (list.get(i) == oldLib) {
                        list.set(i, newLib);
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < this.allContributions.size()) {
                if (this.allContributions.get(i) == oldLib) {
                    this.allContributions.set(i, newLib);
                }
                ++i;
            }
            this.notifyChange(oldLib, newLib);
        }
    }

    private void addContribution(Contribution contribution) {
        for (String category : contribution.getCategories()) {
            List<Object> list;
            if (this.librariesByCategory.containsKey(category)) {
                list = this.librariesByCategory.get(category);
                list.add(contribution);
                Collections.sort(list, nameComparator);
            } else {
                list = new ArrayList<Contribution>();
                ((ArrayList)list).add(contribution);
                this.librariesByCategory.put(category, list);
            }
            this.allContributions.add(contribution);
            this.notifyAdd(contribution);
            Collections.sort(this.allContributions, nameComparator);
        }
    }

    protected void removeContribution(Contribution contribution) {
        for (String category : contribution.getCategories()) {
            if (!this.librariesByCategory.containsKey(category)) continue;
            this.librariesByCategory.get(category).remove(contribution);
        }
        this.allContributions.remove(contribution);
        this.notifyRemove(contribution);
    }

    private Contribution getContribution(Contribution contribution) {
        for (Contribution c : this.allContributions) {
            if (!c.getName().equals(contribution.getName()) || c.getType() != contribution.getType()) continue;
            return c;
        }
        return null;
    }

    protected AvailableContribution getAvailableContribution(Contribution info) {
        for (AvailableContribution advertised : this.advertisedContributions) {
            if (advertised.getType() != info.getType() || !advertised.getName().equals(info.getName())) continue;
            return advertised;
        }
        return null;
    }

    protected Set<String> getCategories(ContributionFilter filter) {
        HashSet<String> outgoing = new HashSet<String>();
        Set<String> categorySet = this.librariesByCategory.keySet();
        block0: for (String categoryName : categorySet) {
            for (Contribution contrib : this.librariesByCategory.get(categoryName)) {
                if (!filter.matches(contrib)) continue;
                if (categoryName == null || categoryName.trim().length() == 0) continue block0;
                outgoing.add(categoryName);
                continue block0;
            }
        }
        return outgoing;
    }

    protected List<Contribution> getFilteredLibraryList(String category, List<String> filters) {
        ArrayList<Contribution> filteredList = new ArrayList<Contribution>(this.allContributions);
        Iterator<Contribution> it = filteredList.iterator();
        block0: while (it.hasNext()) {
            Contribution libInfo = it.next();
            if (category != null && !libInfo.hasCategory(category)) {
                it.remove();
                continue;
            }
            for (String filter : filters) {
                if (this.matches(libInfo, filter)) continue;
                it.remove();
                continue block0;
            }
        }
        return filteredList;
    }

    private boolean matches(Contribution contrib, String filter) {
        int colon = filter.indexOf(":");
        if (colon != -1) {
            String isText = filter.substring(0, colon);
            String property = filter.substring(colon + 1);
            if (!this.isProperty(property)) {
                return true;
            }
            if ("is".equals(isText) || "has".equals(isText)) {
                return this.hasProperty(contrib, filter.substring(colon + 1));
            }
            if ("not".equals(isText)) {
                return !this.hasProperty(contrib, filter.substring(colon + 1));
            }
        }
        filter = ".*" + filter.toLowerCase() + ".*";
        return contrib.getAuthorList() != null && contrib.getAuthorList().toLowerCase().matches(filter) || contrib.getSentence() != null && contrib.getSentence().toLowerCase().matches(filter) || contrib.getParagraph() != null && contrib.getParagraph().toLowerCase().matches(filter) || contrib.hasCategory(filter) || contrib.getName() != null && contrib.getName().toLowerCase().matches(filter);
    }

    private boolean isProperty(String property) {
        return property.startsWith("updat") || property.startsWith("upgrad") || property.startsWith("instal") && !property.startsWith("installabl") || property.equals("tool") || property.startsWith("lib") || property.equals("mode") || property.equals("compilation");
    }

    private boolean hasProperty(Contribution contrib, String property) {
        if (property.startsWith("updat") || property.startsWith("upgrad")) {
            return this.hasUpdates(contrib);
        }
        if (property.startsWith("instal") && !property.startsWith("installabl")) {
            return contrib.isInstalled();
        }
        if (property.equals("tool")) {
            return contrib.getType() == ContributionType.TOOL;
        }
        if (property.startsWith("lib")) {
            return contrib.getType() == ContributionType.LIBRARY;
        }
        if (property.equals("mode")) {
            return contrib.getType() == ContributionType.MODE;
        }
        return false;
    }

    private void notifyRemove(Contribution contribution) {
        for (ContributionChangeListener listener : this.listeners) {
            listener.contributionRemoved(contribution);
        }
    }

    private void notifyAdd(Contribution contribution) {
        for (ContributionChangeListener listener : this.listeners) {
            listener.contributionAdded(contribution);
        }
    }

    private void notifyChange(Contribution oldLib, Contribution newLib) {
        for (ContributionChangeListener listener : this.listeners) {
            listener.contributionChanged(oldLib, newLib);
        }
    }

    protected void addContributionListener(ContributionChangeListener listener) {
        for (Contribution contrib : this.allContributions) {
            listener.contributionAdded(contrib);
        }
        this.listeners.add(listener);
    }

    protected void downloadAvailableList(final ProgressMonitor progress) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ContributionListing.this.downloadingListingLock.lock();
                URL url = null;
                try {
                    url = new URL(ContributionListing.LISTING_URL);
                }
                catch (MalformedURLException e) {
                    progress.error(e);
                    progress.finished();
                }
                if (!progress.isFinished()) {
                    ContributionManager.download(url, ContributionListing.this.listingFile, progress);
                    if (!progress.isCanceled() && !progress.isError()) {
                        ContributionListing.this.hasDownloadedLatestList = true;
                        ContributionListing.this.setAdvertisedList(ContributionListing.this.listingFile);
                    }
                }
                ContributionListing.this.downloadingListingLock.unlock();
            }
        }).start();
    }

    boolean hasUpdates() {
        for (Contribution info : this.allContributions) {
            if (!this.hasUpdates(info)) continue;
            return true;
        }
        return false;
    }

    boolean hasUpdates(Contribution contribution) {
        if (contribution.isInstalled()) {
            AvailableContribution advertised = this.getAvailableContribution(contribution);
            if (advertised == null) {
                return false;
            }
            return advertised.getVersion() > contribution.getVersion();
        }
        return false;
    }

    boolean hasDownloadedLatestList() {
        return this.hasDownloadedLatestList;
    }

    ArrayList<AvailableContribution> parseContribList(File file) {
        ArrayList<AvailableContribution> outgoing = new ArrayList<AvailableContribution>();
        if (file != null && file.exists()) {
            String[] lines = PApplet.loadStrings((File)file);
            int start = 0;
            while (start < lines.length) {
                String type = lines[start];
                ContributionType contribType = ContributionType.fromName(type);
                if (contribType == null) {
                    System.err.println("Error in contribution listing file on line " + (start + 1));
                    return outgoing;
                }
                int end2 = ++start;
                while (end2 < lines.length && !lines[end2].equals("")) {
                    ++end2;
                }
                int length = end2 - start;
                String[] contribLines = new String[length];
                System.arraycopy(lines, start, contribLines, 0, length);
                HashMap<String, String> contribParams = new HashMap<String, String>();
                Base.readSettings(file.getName(), contribLines, contribParams);
                outgoing.add(new AvailableContribution(contribType, contribParams));
                start = end2 + 1;
            }
        }
        return outgoing;
    }

    public Comparator<? super Contribution> getComparator() {
        return nameComparator;
    }
}

