/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import processing.app.Base;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionChangeListener;
import processing.app.contrib.ContributionFilter;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManagerDialog;
import processing.app.contrib.ContributionPanel;
import processing.app.contrib.StatusPanel;

public class ContributionListPanel
extends JPanel
implements Scrollable,
ContributionChangeListener {
    public static final String INSTALL_FAILURE_TITLE = "Install Failed";
    public static final String MALFORMED_URL_MESSAGE = "The link fetched from Processing.org is not valid.\nYou can still install this library manually by visiting\nthe library's website.";
    ContributionManagerDialog contribManager;
    TreeMap<Contribution, ContributionPanel> panelByContribution;
    static HyperlinkListener nullHyperlinkListener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
        }
    };
    private ContributionPanel selectedPanel;
    private StatusPanel status;
    private ContributionFilter filter;
    private ContributionListing contribListing = ContributionListing.getInstance();

    public ContributionListPanel(ContributionManagerDialog libraryManager, ContributionFilter filter) {
        this.contribManager = libraryManager;
        this.filter = filter;
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        if (Base.isLinux()) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(UIManager.getColor("List.background"));
        }
        this.panelByContribution = new TreeMap(this.contribListing.getComparator());
        this.status = new StatusPanel();
    }

    private void updatePanelOrdering() {
        int row = 0;
        for (Map.Entry<Contribution, ContributionPanel> entry : this.panelByContribution.entrySet()) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.gridx = 0;
            c.gridy = row++;
            c.anchor = 11;
            this.add((Component)entry.getValue(), c);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = row++;
        c.anchor = 11;
        this.add((Component)this.status, c);
    }

    @Override
    public void contributionAdded(final Contribution contribution) {
        if (this.filter.matches(contribution)) {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!ContributionListPanel.this.panelByContribution.containsKey(contribution)) {
                        ContributionPanel newPanel = new ContributionPanel(ContributionListPanel.this);
                        TreeMap<Contribution, ContributionPanel> treeMap = ContributionListPanel.this.panelByContribution;
                        synchronized (treeMap) {
                            ContributionListPanel.this.panelByContribution.put(contribution, newPanel);
                        }
                        if (newPanel != null) {
                            newPanel.setContribution(contribution);
                            ContributionListPanel.this.add(newPanel);
                            ContributionListPanel.this.updatePanelOrdering();
                            ContributionListPanel.this.updateColors();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void contributionRemoved(final Contribution contribution) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TreeMap<Contribution, ContributionPanel> treeMap = ContributionListPanel.this.panelByContribution;
                synchronized (treeMap) {
                    ContributionPanel panel = ContributionListPanel.this.panelByContribution.get(contribution);
                    if (panel != null) {
                        ContributionListPanel.this.remove(panel);
                        ContributionListPanel.this.panelByContribution.remove(contribution);
                    }
                }
                ContributionListPanel.this.updatePanelOrdering();
                ContributionListPanel.this.updateColors();
                ContributionListPanel.this.updateUI();
            }
        });
    }

    @Override
    public void contributionChanged(final Contribution oldContrib, final Contribution newContrib) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TreeMap<Contribution, ContributionPanel> treeMap = ContributionListPanel.this.panelByContribution;
                synchronized (treeMap) {
                    ContributionPanel panel = ContributionListPanel.this.panelByContribution.get(oldContrib);
                    if (panel == null) {
                        ContributionListPanel.this.contributionAdded(newContrib);
                    } else {
                        ContributionListPanel.this.panelByContribution.remove(oldContrib);
                        panel.setContribution(newContrib);
                        ContributionListPanel.this.panelByContribution.put(newContrib, panel);
                        ContributionListPanel.this.updatePanelOrdering();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterLibraries(List<Contribution> filteredContributions) {
        TreeMap<Contribution, ContributionPanel> treeMap = this.panelByContribution;
        synchronized (treeMap) {
            ContributionPanel panel;
            TreeSet<? super Contribution> hiddenPanels = new TreeSet<Contribution>(this.contribListing.getComparator());
            hiddenPanels.addAll((Collection<? super Contribution>)this.panelByContribution.keySet());
            for (Contribution contribution : filteredContributions) {
                panel = this.panelByContribution.get(contribution);
                if (panel == null) continue;
                panel.setVisible(true);
                hiddenPanels.remove(contribution);
            }
            for (Contribution contribution : hiddenPanels) {
                panel = this.panelByContribution.get(contribution);
                if (panel == null) continue;
                panel.setVisible(false);
            }
        }
    }

    protected void setSelectedPanel(ContributionPanel panel) {
        if (this.selectedPanel == panel) {
            this.selectedPanel.setSelected(true);
        } else {
            ContributionPanel lastSelected = this.selectedPanel;
            this.selectedPanel = panel;
            if (lastSelected != null) {
                lastSelected.setSelected(false);
            }
            panel.setSelected(true);
            this.updateColors();
            this.requestFocusInWindow();
        }
    }

    protected ContributionPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateColors() {
        int count = 0;
        TreeMap<Contribution, ContributionPanel> treeMap = this.panelByContribution;
        synchronized (treeMap) {
            for (Map.Entry<Contribution, ContributionPanel> entry : this.panelByContribution.entrySet()) {
                ContributionPanel panel = entry.getValue();
                if (panel.isVisible() && panel.isSelected()) {
                    panel.setBackground(UIManager.getColor("List.selectionBackground"));
                    panel.setForeground(UIManager.getColor("List.selectionForeground"));
                    panel.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
                    ++count;
                    continue;
                }
                Border border = null;
                if (panel.isVisible()) {
                    if (Base.isMacOS()) {
                        border = count % 2 == 1 ? UIManager.getBorder("List.oddRowBackgroundPainter") : UIManager.getBorder("List.evenRowBackgroundPainter");
                    } else if (count % 2 == 1) {
                        panel.setBackground(new Color(219, 224, 229));
                    } else {
                        panel.setBackground(new Color(241, 241, 241));
                    }
                    ++count;
                }
                if (border == null) {
                    border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
                }
                panel.setBorder(border);
                panel.setForeground(UIManager.getColor("List.foreground"));
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int blockAmount = visibleRect.height;
            visibleRect.y = direction > 0 ? (visibleRect.y += blockAmount) : (visibleRect.y -= blockAmount);
            return blockAmount += this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 0;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int lastHeight = 0;
            int height = 0;
            int bottomOfScrollArea = visibleRect.y + visibleRect.height;
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c.isVisible() && c instanceof ContributionPanel) {
                    Dimension d = c.getPreferredSize();
                    int nextHeight = height + d.height;
                    if (direction > 0) {
                        if (nextHeight > bottomOfScrollArea) {
                            return nextHeight - bottomOfScrollArea;
                        }
                    } else if (nextHeight > visibleRect.y) {
                        if (visibleRect.y != height) {
                            return visibleRect.y - height;
                        }
                        return visibleRect.y - lastHeight;
                    }
                    lastHeight = height;
                    height = nextHeight;
                }
                ++n2;
            }
        }
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }
}

