/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.app.contrib.ContributionType;
import processing.core.PApplet;

public abstract class Contribution {
    static final List validCategories = Arrays.asList("3D", "Animation", "Data", "Geometry", "GUI", "Hardware", "I/O", "Math", "Simulation", "Sound", "Typography", "Utilities", "Video & Vision", "Other");
    protected List<String> categories;
    protected String name;
    protected String authorList;
    protected String url;
    protected String sentence;
    protected String paragraph;
    protected int version;
    protected String prettyVersion;

    protected List<String> getCategories() {
        return this.categories;
    }

    protected String getCategoryStr() {
        StringBuilder sb = new StringBuilder();
        for (String category : this.categories) {
            sb.append(category);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    protected boolean hasCategory(String category) {
        if (category != null) {
            for (String c : this.categories) {
                if (!category.equalsIgnoreCase(c)) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthorList() {
        return this.authorList;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public int getVersion() {
        return this.version;
    }

    public String getPrettyVersion() {
        return this.prettyVersion;
    }

    public abstract ContributionType getType();

    public String getTypeName() {
        return this.getType().toString();
    }

    public abstract boolean isInstalled();

    boolean isRestartFlagged() {
        return false;
    }

    boolean isDeletionFlagged() {
        return false;
    }

    static List<String> defaultCategory() {
        ArrayList<String> outgoing = new ArrayList<String>();
        outgoing.add("Unknown");
        return outgoing;
    }

    static List<String> parseCategories(String categoryStr) {
        ArrayList<String> outgoing = new ArrayList<String>();
        if (categoryStr != null) {
            String[] listing;
            String[] stringArray = listing = PApplet.trim((String[])PApplet.split((String)categoryStr, (char)','));
            int n = listing.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                if (validCategories.contains(category)) {
                    outgoing.add(category);
                }
                ++n2;
            }
        }
        if (outgoing.size() == 0) {
            return Contribution.defaultCategory();
        }
        return outgoing;
    }
}

