/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import processing.app.Base;
import processing.app.Toolkit;
import processing.core.PApplet;

public class Settings {
    HashMap<String, String> defaults;
    HashMap<String, String> table = new HashMap();
    File file;

    public Settings(File file) throws IOException {
        this.file = file;
        if (file.exists()) {
            this.load();
        }
        this.defaults = (HashMap)this.table.clone();
    }

    public void load() {
        this.load(this.file);
    }

    public void load(File additions) {
        String[] lines = PApplet.loadStrings((File)additions);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            int equals;
            String line = stringArray[n2];
            if (line.length() != 0 && line.charAt(0) != '#' && (equals = line.indexOf(61)) != -1) {
                String key = line.substring(0, equals).trim();
                String value = line.substring(equals + 1).trim();
                this.table.put(key, value);
            }
            ++n2;
        }
        String platformExt = "." + Base.getPlatformName();
        int platformExtLength = platformExt.length();
        for (String key : this.table.keySet()) {
            if (!key.endsWith(platformExt)) continue;
            String actualKey = key.substring(0, key.length() - platformExtLength);
            String value = this.get(key);
            this.table.put(actualKey, value);
        }
    }

    public void save() {
        PrintWriter writer = PApplet.createWriter((File)this.file);
        for (String key : this.table.keySet()) {
            writer.println(String.valueOf(key) + "=" + this.table.get(key));
        }
        writer.flush();
        writer.close();
    }

    public String get(String attribute) {
        return this.table.get(attribute);
    }

    public String getDefault(String attribute) {
        return this.defaults.get(attribute);
    }

    public void set(String attribute, String value) {
        this.table.put(attribute, value);
    }

    public boolean getBoolean(String attribute) {
        String value = this.get(attribute);
        if (value == null) {
            System.err.println("Boolean not found: " + attribute);
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public void setBoolean(String attribute, boolean value) {
        this.set(attribute, value ? "true" : "false");
    }

    public int getInteger(String attribute) {
        String value = this.get(attribute);
        if (value == null) {
            System.err.println("Integer not found: " + attribute);
            return 0;
        }
        return Integer.parseInt(value);
    }

    public void setInteger(String key, int value) {
        this.set(key, String.valueOf(value));
    }

    public Color getColor(String attribute) {
        Color parsed = null;
        String s = this.get(attribute);
        if (s != null && s.indexOf("#") == 0) {
            try {
                int v = Integer.parseInt(s.substring(1), 16);
                parsed = new Color(v);
            }
            catch (Exception exception) {}
        }
        return parsed;
    }

    public void setColor(String attr, Color what) {
        this.set(attr, "#" + PApplet.hex((int)(what.getRGB() & 0xFFFFFF), (int)6));
    }

    public Font getFont(String attr) {
        try {
            String[] pieces;
            boolean replace = false;
            String value = this.get(attr);
            if (value == null) {
                value = this.getDefault(attr);
                replace = true;
            }
            if ((pieces = PApplet.split((String)value, (char)',')).length != 3) {
                value = this.getDefault(attr);
                pieces = PApplet.split((String)value, (char)',');
                replace = true;
            }
            String name = pieces[0];
            int style = 0;
            if (pieces[1].indexOf("bold") != -1) {
                style |= 1;
            }
            if (pieces[1].indexOf("italic") != -1) {
                style |= 2;
            }
            int size = PApplet.parseInt((String)pieces[2], (int)12);
            if (replace) {
                this.set(attr, value);
            }
            if (!name.startsWith("processing.")) {
                return new Font(name, style, size);
            }
            if (pieces[0].equals("processing.sans")) {
                return Toolkit.getSansFont(size, style);
            }
            if (pieces[0].equals("processing.mono")) {
                return Toolkit.getMonoFont(size, style);
            }
        }
        catch (Exception exception) {
            Base.log("Error with font " + this.get(attr) + " for attribute " + attr);
        }
        return new Font("Dialog", 0, 12);
    }
}

