/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Sketch;
import processing.app.Toolkit;

public class FindReplace
extends JFrame {
    static final int EDGE = Base.isMacOS() ? 20 : 13;
    static final int SMALL = 6;
    static final int BUTTON_GAP = 12;
    Editor editor;
    JTextField findField;
    JTextField replaceField;
    static String findString;
    static String replaceString;
    JButton replaceButton;
    JButton replaceAllButton;
    JButton replaceAndFindButton;
    JButton previousButton;
    JButton findButton;
    JCheckBox ignoreCaseBox;
    static boolean ignoreCase;
    JCheckBox allTabsBox;
    static boolean allTabs;
    JCheckBox wrapAroundBox;
    static boolean wrapAround;

    static {
        ignoreCase = true;
        allTabs = false;
        wrapAround = true;
    }

    public FindReplace(Editor editor) {
        super("Find");
        this.setResizable(false);
        this.editor = editor;
        Container pain = this.getContentPane();
        pain.setLayout(null);
        JLabel findLabel = new JLabel("Find:");
        JLabel replaceLabel = new JLabel("Replace with:");
        Dimension labelDimension = replaceLabel.getPreferredSize();
        pain.add(findLabel);
        pain.add(replaceLabel);
        this.findField = new JTextField();
        pain.add(this.findField);
        this.replaceField = new JTextField();
        pain.add(this.replaceField);
        int fieldHeight = this.findField.getPreferredSize().height;
        if (findString != null) {
            this.findField.setText(findString);
        }
        if (replaceString != null) {
            this.replaceField.setText(replaceString);
        }
        this.ignoreCaseBox = new JCheckBox("Ignore Case");
        this.ignoreCaseBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ignoreCase = FindReplace.this.ignoreCaseBox.isSelected();
            }
        });
        this.ignoreCaseBox.setSelected(ignoreCase);
        pain.add(this.ignoreCaseBox);
        this.allTabsBox = new JCheckBox("All Tabs");
        this.allTabsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                allTabs = FindReplace.this.allTabsBox.isSelected();
            }
        });
        this.allTabsBox.setSelected(allTabs);
        this.allTabsBox.setEnabled(true);
        pain.add(this.allTabsBox);
        this.wrapAroundBox = new JCheckBox("Wrap Around");
        this.wrapAroundBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                wrapAround = FindReplace.this.wrapAroundBox.isSelected();
            }
        });
        this.wrapAroundBox.setSelected(wrapAround);
        pain.add(this.wrapAroundBox);
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(1, 12, 0));
        this.replaceAllButton = new JButton("Replace All");
        this.replaceButton = new JButton("Replace");
        this.replaceAndFindButton = new JButton("Replace & Find");
        this.previousButton = new JButton("Previous");
        this.findButton = new JButton("Find");
        if (Base.isMacOS()) {
            buttons.add(this.replaceAllButton);
            buttons.add(this.replaceButton);
            buttons.add(this.replaceAndFindButton);
            buttons.add(this.previousButton);
            buttons.add(this.findButton);
            buttons.setBorder(null);
        } else {
            buttons.add(this.findButton);
            buttons.add(this.previousButton);
            buttons.add(this.replaceAndFindButton);
            buttons.add(this.replaceButton);
            buttons.add(this.replaceAllButton);
        }
        pain.add(buttons);
        this.setFound(false);
        Dimension buttonsDimension = buttons.getPreferredSize();
        int visibleButtonWidth = buttonsDimension.width - 24;
        int fieldWidth = visibleButtonWidth - (labelDimension.width + 6);
        int yoff = (1 + fieldHeight - labelDimension.height) / 2;
        int ypos = EDGE;
        int labelWidth = findLabel.getPreferredSize().width;
        findLabel.setBounds(EDGE + (labelDimension.width - labelWidth), ypos + yoff, labelWidth, labelDimension.height);
        this.findField.setBounds(EDGE + labelDimension.width + 6, ypos, fieldWidth, fieldHeight);
        labelWidth = replaceLabel.getPreferredSize().width;
        replaceLabel.setBounds(EDGE + (labelDimension.width - labelWidth), (ypos += fieldHeight + 6) + yoff, labelWidth, labelDimension.height);
        this.replaceField.setBounds(EDGE + labelDimension.width + 6, ypos, fieldWidth, fieldHeight);
        int third = (fieldWidth - 12) / 3;
        this.ignoreCaseBox.setBounds(EDGE + labelDimension.width + 6, ypos += fieldHeight + 6, third, fieldHeight);
        this.allTabsBox.setBounds(EDGE + labelDimension.width + 6 + third + 6, ypos, third, fieldHeight);
        this.wrapAroundBox.setBounds(EDGE + labelDimension.width + 6 + third * 2 + 12, ypos, third, fieldHeight);
        buttons.setBounds(EDGE - 12, ypos += fieldHeight + 6, buttonsDimension.width, buttonsDimension.height);
        int wide = visibleButtonWidth + EDGE * 2;
        int high = ypos += buttonsDimension.height + EDGE;
        this.pack();
        Insets insets = this.getInsets();
        this.setSize(wide + insets.left + insets.right, high + insets.top + insets.bottom);
        this.setLocationRelativeTo(null);
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.replace();
            }
        });
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.replaceAll();
            }
        });
        this.replaceAndFindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.replaceAndFindNext();
            }
        });
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.findNext();
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.findPrevious();
            }
        });
        this.getRootPane().setDefaultButton(this.findButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindReplace.this.handleClose();
            }
        });
        Toolkit.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplace.this.handleClose();
            }
        });
        Toolkit.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                FindReplace.this.findField.requestFocusInWindow();
                FindReplace.this.findField.selectAll();
            }
        });
    }

    public void handleClose() {
        findString = this.findField.getText();
        replaceString = this.replaceField.getText();
        this.setVisible(false);
    }

    private boolean find(boolean wrap, boolean backwards) {
        String searchTerm = this.findField.getText();
        if (searchTerm.length() != 0) {
            int nextIndex;
            String text = this.editor.getText();
            Sketch sketch = this.editor.getSketch();
            int tabIndex = sketch.getCurrentCodeIndex();
            if (ignoreCase) {
                searchTerm = searchTerm.toLowerCase();
                text = text.toLowerCase();
            }
            if (!backwards) {
                int selectionEnd = this.editor.getSelectionStop();
                nextIndex = text.indexOf(searchTerm, selectionEnd);
                if (nextIndex == -1 && wrap && !allTabs) {
                    nextIndex = text.indexOf(searchTerm, 0);
                } else if (nextIndex == -1 && allTabs) {
                    int tempIndex = tabIndex;
                    while (tabIndex <= sketch.getCodeCount() - 1) {
                        if (tabIndex == sketch.getCodeCount() - 1) {
                            tabIndex = -1;
                        } else if (tabIndex == sketch.getCodeCount() - 1) break;
                        try {
                            Document doc = sketch.getCode(tabIndex + 1).getDocument();
                            text = doc != null ? doc.getText(0, doc.getLength()) : sketch.getCode(tabIndex + 1).getProgram();
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        ++tabIndex;
                        if (ignoreCase) {
                            text = text.toLowerCase();
                        }
                        if ((nextIndex = text.indexOf(searchTerm, 0)) != -1 || tabIndex == tempIndex) break;
                    }
                    if (nextIndex == -1) {
                        tabIndex = tempIndex;
                    }
                }
            } else {
                int selectionStart = this.editor.getSelectionStart() - 1;
                nextIndex = selectionStart >= 0 ? text.lastIndexOf(searchTerm, selectionStart) : -1;
                if (wrap && !allTabs && nextIndex == -1) {
                    nextIndex = text.lastIndexOf(searchTerm);
                } else if (nextIndex == -1 && allTabs) {
                    int tempIndex = tabIndex;
                    while (tabIndex >= 0) {
                        if (tabIndex == 0) {
                            tabIndex = sketch.getCodeCount();
                        } else if (tabIndex == 0) break;
                        try {
                            Document doc = sketch.getCode(tabIndex - 1).getDocument();
                            text = doc != null ? doc.getText(0, doc.getLength()) : sketch.getCode(tabIndex - 1).getProgram();
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        --tabIndex;
                        if (ignoreCase) {
                            text = text.toLowerCase();
                        }
                        if ((nextIndex = text.lastIndexOf(searchTerm)) != -1 || tabIndex == tempIndex) break;
                    }
                    if (nextIndex == -1) {
                        tabIndex = tempIndex;
                    }
                }
            }
            if (nextIndex != -1) {
                if (allTabs) {
                    sketch.setCurrentCode(tabIndex);
                }
                this.editor.setSelection(nextIndex, nextIndex + searchTerm.length());
            }
            if (nextIndex != -1) {
                this.setFound(true);
                return true;
            }
        }
        this.setFound(false);
        return false;
    }

    protected void setFound(boolean found) {
        this.replaceButton.setEnabled(found);
        this.replaceAndFindButton.setEnabled(found);
    }

    public void replace() {
        this.editor.setSelectedText(this.replaceField.getText());
        this.editor.getSketch().setModified(true);
        this.setFound(false);
    }

    public void replaceAndFindNext() {
        this.replace();
        this.findNext();
    }

    public void replaceAll() {
        this.editor.setSelection(0, 0);
        boolean foundAtLeastOne = false;
        int startTab = -1;
        int startIndex = -1;
        int c = 50000;
        while (--c > 0) {
            if (!this.find(false, false)) break;
            if (this.editor.getSketch().getCurrentCodeIndex() == startTab && this.editor.getSelectionStart() == startIndex) {
                Toolkit.beep();
                this.editor.statusNotice("Reached beginning of search!");
                break;
            }
            if (!foundAtLeastOne) {
                foundAtLeastOne = true;
                startTab = this.editor.getSketch().getCurrentCodeIndex();
                startIndex = this.editor.getSelectionStart();
            }
            this.replace();
        }
        if (!foundAtLeastOne) {
            Toolkit.beep();
        }
        this.setFound(false);
    }

    public void setFindText(String t) {
        this.findField.setText(t);
        findString = t;
    }

    public void findNext() {
        if (!this.find(wrapAround, false)) {
            Toolkit.beep();
        }
    }

    public void findPrevious() {
        if (!this.find(wrapAround, true)) {
            Toolkit.beep();
        }
    }
}

