/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import processing.app.Editor;
import processing.app.Mode;

public class EditorLineStatus
extends JComponent {
    Editor editor;
    int start = -1;
    int stop;
    Color foreground;
    Color background;
    Font font;
    int high;
    String text = "";

    public EditorLineStatus(Editor editor) {
        this.editor = editor;
        editor.getTextArea().editorLineStatus = this;
        this.updateMode();
    }

    public void updateMode() {
        Mode mode = this.editor.getMode();
        this.background = mode.getColor("linestatus.bgcolor");
        this.font = mode.getFont("linestatus.font");
        this.foreground = mode.getColor("linestatus.color");
        this.high = mode.getInteger("linestatus.height");
    }

    public void set(int newStart, int newStop) {
        if (newStart == this.start && newStop == this.stop) {
            return;
        }
        this.start = newStart;
        this.stop = newStop;
        this.text = this.start == this.stop ? String.valueOf(this.start + 1) : String.valueOf(this.start + 1) + " - " + (this.stop + 1);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(this.background);
        Dimension size = this.getSize();
        g.fillRect(0, 0, size.width, size.height);
        g.setFont(this.font);
        g.setColor(this.foreground);
        int baseline = (this.high + g.getFontMetrics().getAscent()) / 2;
        g.drawString(this.text, 6, baseline - 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, this.high);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(3000, this.high);
    }
}

