/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import processing.app.Base;
import processing.app.EditorConsole;
import processing.app.EditorHeader;
import processing.app.EditorLineStatus;
import processing.app.EditorState;
import processing.app.EditorStatus;
import processing.app.EditorToolbar;
import processing.app.FindReplace;
import processing.app.Formatter;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.Toolkit;
import processing.app.contrib.ToolContribution;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.SyntaxDocument;
import processing.app.tools.Tool;
import processing.core.PApplet;

public abstract class Editor
extends JFrame
implements RunnerListener {
    protected Base base;
    protected EditorState state;
    protected Mode mode;
    protected static final String EMPTY = "                                                                                                                                                                                                               ";
    private PageFormat pageFormat;
    private PrinterJob printerJob;
    private JMenu fileMenu;
    private JMenu sketchMenu;
    protected EditorHeader header;
    protected EditorToolbar toolbar;
    protected JEditTextArea textarea;
    protected EditorStatus status;
    protected JSplitPane splitPane;
    protected JPanel consolePanel;
    protected EditorConsole console;
    protected EditorLineStatus lineStatus;
    protected Sketch sketch;
    private Point sketchWindowLocation;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    private UndoManager undo;
    private CompoundEdit compoundEdit;
    private Timer timer;
    private TimerTask endUndoEvent;
    private boolean isInserting;
    private final Stack<Integer> caretUndoStack = new Stack();
    private final Stack<Integer> caretRedoStack = new Stack();
    private FindReplace find;
    JMenu toolsMenu;
    JMenu modeMenu;
    ArrayList<ToolContribution> coreTools;
    public ArrayList<ToolContribution> contribTools;

    protected Editor(final Base base, String path, EditorState state, final Mode mode) {
        super("Processing", state.checkConfig());
        this.base = base;
        this.state = state;
        this.mode = mode;
        Toolkit.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                base.handleClose(Editor.this, false);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                base.handleActivated(Editor.this);
                Editor.this.fileMenu.insert(base.getSketchbookMenu(), 2);
                Editor.this.fileMenu.insert(base.getRecentMenu(), 3);
                Editor.this.sketchMenu.insert(mode.getImportMenu(), 4);
                mode.insertToolbarRecentMenu();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                Editor.this.fileMenu.remove(base.getSketchbookMenu());
                Editor.this.fileMenu.remove(base.getRecentMenu());
                Editor.this.sketchMenu.remove(mode.getImportMenu());
                mode.removeToolbarRecentMenu();
            }
        });
        this.timer = new Timer();
        this.buildMenuBar();
        Container contentPain = this.getContentPane();
        contentPain.setLayout(new BorderLayout());
        JPanel pain = new JPanel();
        pain.setLayout(new BorderLayout());
        contentPain.add((Component)pain, "Center");
        Box box = Box.createVerticalBox();
        Box upper = Box.createVerticalBox();
        this.initModeMenu();
        this.toolbar = this.createToolbar();
        upper.add(this.toolbar);
        this.header = new EditorHeader(this);
        upper.add(this.header);
        this.textarea = this.createTextArea();
        this.textarea.setRightClickPopup(new TextAreaPopup());
        this.textarea.setHorizontalOffset(6);
        this.consolePanel = new JPanel();
        this.consolePanel.setLayout(new BorderLayout());
        this.status = new EditorStatus(this);
        this.consolePanel.add((Component)this.status, "North");
        this.console = new EditorConsole(this);
        this.console.setBorder(null);
        this.consolePanel.add((Component)this.console, "Center");
        this.lineStatus = new EditorLineStatus(this);
        this.consolePanel.add((Component)this.lineStatus, "South");
        upper.add(this.textarea);
        this.splitPane = new JSplitPane(0, upper, this.consolePanel);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setBorder(null);
        int dividerSize = Preferences.getInteger("editor.divider.size");
        if (dividerSize != 0) {
            this.splitPane.setDividerSize(dividerSize);
        }
        box.add(this.splitPane);
        pain.add(box);
        this.textarea.addKeyListener(this.toolbar);
        this.textarea.addCaretListener(new CaretListener(){
            String lastText;
            {
                this.lastText = Editor.this.textarea.getText();
            }

            @Override
            public void caretUpdate(CaretEvent e) {
                String newText = Editor.this.textarea.getText();
                if (this.lastText.equals(newText) && Editor.this.isDirectEdit()) {
                    Editor.this.endTextEditHistory();
                }
                this.lastText = newText;
            }
        });
        pain.setTransferHandler(new FileDropHandler());
        this.pack();
        state.apply(this);
        this.setMinimumSize(new Dimension(Preferences.getInteger("editor.window.width.min"), Preferences.getInteger("editor.window.height.min")));
        this.applyPreferences();
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                Editor.this.textarea.requestFocusInWindow();
            }
        });
        boolean loaded = this.handleOpenInternal(path);
        if (!loaded) {
            this.sketch = null;
        }
    }

    protected JEditTextArea createTextArea() {
        return new JEditTextArea(new PdeTextAreaDefaults(this.mode));
    }

    public EditorState getEditorState() {
        return this.state;
    }

    public void removeRecent() {
        this.base.removeRecent(this);
    }

    public void addRecent() {
        this.base.handleRecent(this);
    }

    public Base getBase() {
        return this.base;
    }

    public Mode getMode() {
        return this.mode;
    }

    protected void initModeMenu() {
        this.modeMenu = new JMenu();
        for (final Mode m : this.base.getModeList()) {
            JMenuItem item;
            if (this.mode == m) {
                item = new JRadioButtonMenuItem(m.getTitle());
                item.setSelected(true);
                this.modeMenu.add(item);
                continue;
            }
            item = new JMenuItem(m.getTitle());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.changeMode(m);
                }
            });
            this.modeMenu.add(item);
        }
        this.modeMenu.addSeparator();
        JMenuItem addLib = new JMenuItem("Add Mode...");
        addLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleOpenModeManager();
            }
        });
        this.modeMenu.add(addLib);
    }

    public JMenu getModeMenu() {
        return this.modeMenu;
    }

    public abstract EditorToolbar createToolbar();

    public abstract Formatter createFormatter();

    protected void setDividerLocation(int pos) {
        this.splitPane.setDividerLocation(pos);
    }

    protected int getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    protected void applyPreferences() {
        this.textarea.getPainter().updateAppearance();
        this.textarea.repaint();
        this.console.updateAppearance();
    }

    protected void buildMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar = new JMenuBar();
        this.fileMenu = this.buildFileMenu();
        menubar.add(this.fileMenu);
        menubar.add(this.buildEditMenu());
        menubar.add(this.buildSketchMenu());
        this.rebuildToolMenu();
        menubar.add(this.getToolMenu());
        JMenu modeMenu = this.buildModeMenu();
        if (modeMenu != null) {
            menubar.add(modeMenu);
        }
        menubar.add(this.buildHelpMenu());
        this.setJMenuBar(menubar);
    }

    public abstract JMenu buildFileMenu();

    protected JMenu buildFileMenu(JMenuItem[] exportItems) {
        JMenu fileMenu = new JMenu("File");
        JMenuItem item = Toolkit.newJMenuItem("New", 78);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleNew();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItem("Open...", 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleOpenPrompt();
            }
        });
        fileMenu.add(item);
        fileMenu.add(this.base.getSketchbookMenu());
        item = Toolkit.newJMenuItemShift("Examples...", 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.mode.showExamplesFrame();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItem("Close", 87);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleClose(Editor.this, false);
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItem("Save", 83);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSave(false);
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItemShift("Save As...", 83);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSaveAs();
            }
        });
        fileMenu.add(item);
        if (exportItems != null) {
            JMenuItem[] jMenuItemArray = exportItems;
            int n = exportItems.length;
            int n2 = 0;
            while (n2 < n) {
                JMenuItem ei = jMenuItemArray[n2];
                fileMenu.add(ei);
                ++n2;
            }
        }
        fileMenu.addSeparator();
        item = Toolkit.newJMenuItemShift("Page Setup", 80);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handlePageSetup();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItem("Print", 80);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handlePrint();
            }
        });
        fileMenu.add(item);
        if (!Base.isMacOS()) {
            fileMenu.addSeparator();
            item = Toolkit.newJMenuItem("Preferences", 44);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handlePrefs();
                }
            });
            fileMenu.add(item);
            fileMenu.addSeparator();
            item = Toolkit.newJMenuItem("Quit", 81);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handleQuit();
                }
            });
            fileMenu.add(item);
        }
        return fileMenu;
    }

    protected JMenu buildEditMenu() {
        JMenu menu = new JMenu("Edit");
        this.undoItem = Toolkit.newJMenuItem("Undo", 90);
        this.undoAction = new UndoAction();
        this.undoItem.addActionListener(this.undoAction);
        menu.add(this.undoItem);
        this.redoItem = Base.isWindows() ? Toolkit.newJMenuItem("Redo", 89) : Toolkit.newJMenuItemShift("Redo", 90);
        this.redoAction = new RedoAction();
        this.redoItem.addActionListener(this.redoAction);
        menu.add(this.redoItem);
        menu.addSeparator();
        JMenuItem item = Toolkit.newJMenuItem("Cut", 88);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCut();
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItem("Copy", 67);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.copy();
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItemShift("Copy as HTML", 67);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCopyAsHTML();
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItem("Paste", 86);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.paste();
                Editor.this.sketch.setModified(true);
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItem("Select All", 65);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.selectAll();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Toolkit.newJMenuItem("Auto Format", 84);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleAutoFormat();
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItem("Comment/Uncomment", 47);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCommentUncomment();
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItem("Increase Indent", 93);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleIndentOutdent(true);
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItem("Decrease Indent", 91);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleIndentOutdent(false);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Toolkit.newJMenuItem("Find...", 70);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                Editor.this.find.setVisible(true);
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItem("Find Next", 71);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find != null) {
                    Editor.this.find.findNext();
                }
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItemShift("Find Previous", 71);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find != null) {
                    Editor.this.find.findPrevious();
                }
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItemAlt("Use Selection for Find", 70);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                Editor.this.find.setFindText(Editor.this.getSelectedText());
            }
        });
        menu.add(item);
        return menu;
    }

    public abstract JMenu buildSketchMenu();

    protected JMenu buildSketchMenu(JMenuItem[] runItems) {
        this.sketchMenu = new JMenu("Sketch");
        JMenuItem[] jMenuItemArray = runItems;
        int n = runItems.length;
        int n2 = 0;
        while (n2 < n) {
            JMenuItem mi = jMenuItemArray[n2];
            this.sketchMenu.add(mi);
            ++n2;
        }
        this.sketchMenu.addSeparator();
        this.sketchMenu.add(this.mode.getImportMenu());
        JMenuItem item = Toolkit.newJMenuItem("Show Sketch Folder", 75);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.openFolder(Editor.this.sketch.getFolder());
            }
        });
        this.sketchMenu.add(item);
        item.setEnabled(Base.openFolderAvailable());
        item = new JMenuItem("Add File...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.sketch.handleAddFile();
            }
        });
        this.sketchMenu.add(item);
        return this.sketchMenu;
    }

    public abstract void handleImportLibrary(String var1);

    public JMenu getToolMenu() {
        if (this.toolsMenu == null) {
            this.rebuildToolMenu();
        }
        return this.toolsMenu;
    }

    public void rebuildToolMenu() {
        if (this.toolsMenu == null) {
            this.toolsMenu = new JMenu("Tools");
        } else {
            this.toolsMenu.removeAll();
        }
        this.coreTools = ToolContribution.loadAll(Base.getToolsFolder());
        this.contribTools = ToolContribution.loadAll(Base.getSketchbookToolsFolder());
        this.addInternalTools(this.toolsMenu);
        this.addTools(this.toolsMenu, this.coreTools);
        this.addTools(this.toolsMenu, this.contribTools);
        this.toolsMenu.addSeparator();
        JMenuItem item = new JMenuItem("Add Tool...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleOpenToolManager();
            }
        });
        this.toolsMenu.add(item);
    }

    void addToolItem(final Tool tool, HashMap<String, JMenuItem> toolItems) {
        String title = tool.getMenuTitle();
        final JMenuItem item = new JMenuItem(title);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    tool.run();
                }
                catch (NoSuchMethodError nsme) {
                    Editor.this.statusError("\"" + tool.getMenuTitle() + "\" is not" + "compatible with this version of Processing");
                    Base.log("Incompatible tool found during tool.run()", nsme);
                    item.setEnabled(false);
                }
                catch (Exception ex) {
                    Editor.this.statusError("An error occurred inside \"" + tool.getMenuTitle() + "\"");
                    ex.printStackTrace();
                    item.setEnabled(false);
                }
            }
        });
        toolItems.put(title, item);
    }

    protected void addTools(JMenu menu, ArrayList<ToolContribution> tools) {
        HashMap<String, JMenuItem> toolItems = new HashMap<String, JMenuItem>();
        for (ToolContribution tool : tools) {
            try {
                tool.init(this);
                this.addToolItem(tool, toolItems);
            }
            catch (NoSuchMethodError nsme) {
                System.err.println("\"" + tool.getMenuTitle() + "\" is not " + "compatible with this version of Processing");
                System.err.println("The " + nsme.getMessage() + " method no longer exists.");
                Base.log("Incompatible Tool found during tool.init()", nsme);
            }
            catch (NoClassDefFoundError ncdfe) {
                System.err.println("\"" + tool.getMenuTitle() + "\" is not " + "compatible with this version of Processing");
                System.err.println("The " + ncdfe.getMessage() + " class is no longer available.");
                Base.log("Incompatible Tool found during tool.init()", ncdfe);
            }
            catch (Error err) {
                System.err.println("An error occurred inside \"" + tool.getMenuTitle() + "\"");
                err.printStackTrace();
            }
            catch (Exception ex) {
                System.err.println("An exception occurred inside \"" + tool.getMenuTitle() + "\"");
                ex.printStackTrace();
            }
        }
        ArrayList toolList = new ArrayList(toolItems.keySet());
        if (toolList.size() > 0) {
            menu.addSeparator();
            Collections.sort(toolList);
            for (String title : toolList) {
                menu.add(toolItems.get(title));
            }
        }
    }

    public JMenu buildModeMenu() {
        return null;
    }

    protected void addToolMenuItem(JMenu menu, String className) {
        try {
            Class<?> toolClass = Class.forName(className);
            final Tool tool = (Tool)toolClass.newInstance();
            JMenuItem item = new JMenuItem(tool.getMenuTitle());
            tool.init(this);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventQueue.invokeLater(tool);
                }
            });
            menu.add(item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected JMenu addInternalTools(JMenu menu) {
        this.addToolMenuItem(menu, "processing.app.tools.CreateFont");
        this.addToolMenuItem(menu, "processing.app.tools.ColorSelector");
        this.addToolMenuItem(menu, "processing.app.tools.Archiver");
        if (Base.isMacOS()) {
            this.addToolMenuItem(menu, "processing.app.tools.InstallCommander");
        }
        return menu;
    }

    public abstract JMenu buildHelpMenu();

    public void showReference(String filename) {
        File file = new File(this.mode.getReferenceFolder(), filename);
        Base.openURL(file.toURI().toString());
    }

    public static void showChanges() {
        if (!Base.isCommandLine()) {
            Base.openURL("http://wiki.processing.org/w/Changes");
        }
    }

    public Sketch getSketch() {
        return this.sketch;
    }

    public JEditTextArea getTextArea() {
        return this.textarea;
    }

    public String getText() {
        return this.textarea.getText();
    }

    public String getText(int start, int stop) {
        return this.textarea.getText(start, stop - start);
    }

    public void setText(String what) {
        this.startCompoundEdit();
        this.textarea.setText(what);
        this.stopCompoundEdit();
    }

    public void insertText(String what) {
        this.startCompoundEdit();
        int caret = this.getCaretOffset();
        this.setSelection(caret, caret);
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public String getSelectedText() {
        return this.textarea.getSelectedText();
    }

    public void setSelectedText(String what) {
        this.textarea.setSelectedText(what);
    }

    public void setSelection(int start, int stop) {
        start = PApplet.constrain((int)start, (int)0, (int)this.textarea.getDocumentLength());
        stop = PApplet.constrain((int)stop, (int)0, (int)this.textarea.getDocumentLength());
        this.textarea.select(start, stop);
    }

    public int getCaretOffset() {
        return this.textarea.getCaretPosition();
    }

    public boolean isSelectionActive() {
        return this.textarea.isSelectionActive();
    }

    public int getSelectionStart() {
        return this.textarea.getSelectionStart();
    }

    public int getSelectionStop() {
        return this.textarea.getSelectionStop();
    }

    public String getLineText(int line) {
        return this.textarea.getLineText(line);
    }

    public void setLineText(int line, String what) {
        this.startCompoundEdit();
        this.textarea.select(this.getLineStartOffset(line), this.getLineStopOffset(line));
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public int getLineStartOffset(int line) {
        return this.textarea.getLineStartOffset(line);
    }

    public int getLineStopOffset(int line) {
        return this.textarea.getLineStopOffset(line);
    }

    public int getLineCount() {
        return this.textarea.getLineCount();
    }

    public void startCompoundEdit() {
        this.stopCompoundEdit();
        this.compoundEdit = new CompoundEdit();
    }

    public void stopCompoundEdit() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.undo.addEdit(this.compoundEdit);
            this.caretUndoStack.push(this.textarea.getCaretPosition());
            this.caretRedoStack.clear();
            this.undoAction.updateUndoState();
            this.redoAction.updateRedoState();
            this.compoundEdit = null;
        }
    }

    public int getScrollPosition() {
        return this.textarea.getVerticalScrollPosition();
    }

    protected void setCode(SketchCode code) {
        SyntaxDocument document = (SyntaxDocument)code.getDocument();
        if (document == null) {
            document = new SyntaxDocument();
            code.setDocument(document);
            document.setTokenMarker(this.mode.getTokenMarker());
            try {
                document.insertString(0, code.getProgram(), null);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            document.addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    if (Editor.this.isInserting && Editor.this.isDirectEdit()) {
                        Editor.this.endTextEditHistory();
                    }
                    Editor.this.isInserting = false;
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (!Editor.this.isInserting && Editor.this.isDirectEdit()) {
                        Editor.this.endTextEditHistory();
                    }
                    Editor.this.isInserting = true;
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    Editor.this.endTextEditHistory();
                }
            });
            document.addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent e) {
                    if (Editor.this.endUndoEvent != null) {
                        Editor.this.endUndoEvent.cancel();
                        Editor.this.endUndoEvent = null;
                        Editor.this.startTimerEvent();
                    }
                    if (Editor.this.compoundEdit == null) {
                        Editor.this.startCompoundEdit();
                        Editor.this.startTimerEvent();
                    }
                    Editor.this.compoundEdit.addEdit(e.getEdit());
                    Editor.this.undoAction.updateUndoState();
                    Editor.this.redoAction.updateRedoState();
                }
            });
        }
        this.textarea.setDocument(document, code.getSelectionStart(), code.getSelectionStop(), code.getScrollPosition());
        this.textarea.requestFocusInWindow();
        this.undo = code.getUndo();
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    boolean isDirectEdit() {
        return this.endUndoEvent != null;
    }

    void startTimerEvent() {
        this.endUndoEvent = new TimerTask(){

            @Override
            public void run() {
                Editor.this.endTextEditHistory();
            }
        };
        this.timer.schedule(this.endUndoEvent, 3000L);
        this.timer.purge();
    }

    void endTextEditHistory() {
        if (this.endUndoEvent != null) {
            this.endUndoEvent.cancel();
            this.endUndoEvent = null;
        }
        this.stopCompoundEdit();
    }

    public void handleCut() {
        this.textarea.cut();
        this.sketch.setModified(true);
    }

    public void handleCopy() {
        this.textarea.copy();
    }

    public void handleCopyAsHTML() {
        this.textarea.copyAsHTML();
        this.statusNotice("Code formatted as HTML has been copied to the clipboard.");
    }

    public void handlePaste() {
        this.textarea.paste();
        this.sketch.setModified(true);
    }

    public void handleSelectAll() {
        this.textarea.selectAll();
    }

    public void handleAutoFormat() {
        String source = this.getText();
        try {
            String formattedText = this.createFormatter().format(source);
            int selectionEnd = this.getSelectionStop();
            if (formattedText.length() < selectionEnd - 1) {
                selectionEnd = formattedText.length() - 1;
            }
            if (formattedText.equals(source)) {
                this.statusNotice("No changes necessary for Auto Format.");
            } else {
                int scrollPos = this.textarea.getVerticalScrollPosition();
                this.setText(formattedText);
                this.setSelection(selectionEnd, selectionEnd);
                if (scrollPos != this.textarea.getVerticalScrollPosition()) {
                    this.textarea.setVerticalScrollPosition(scrollPos);
                }
                this.getSketch().setModified(true);
                this.statusNotice("Auto Format finished.");
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
    }

    public abstract String getCommentPrefix();

    protected void handleCommentUncomment() {
        this.startCompoundEdit();
        String prefix = this.getCommentPrefix();
        int prefixLen = prefix.length();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        int length = this.textarea.getDocumentLength();
        boolean commented = true;
        int i = startLine;
        while (commented && i <= stopLine) {
            int pos = this.textarea.getLineStartOffset(i);
            if (pos + prefixLen > length) {
                commented = false;
            } else {
                String begin = this.textarea.getText(pos, prefixLen);
                commented = begin.equals(prefix);
            }
            ++i;
        }
        int line = startLine;
        while (line <= stopLine) {
            int location = this.textarea.getLineStartOffset(line);
            if (commented) {
                this.textarea.select(location, location + prefixLen);
                if (this.textarea.getSelectedText().equals(prefix)) {
                    this.textarea.setSelectedText("");
                }
            } else {
                this.textarea.select(location, location);
                this.textarea.setSelectedText(prefix);
            }
            ++line;
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
        this.sketch.setModified(true);
    }

    public void handleIndent() {
        this.handleIndentOutdent(true);
    }

    public void handleOutdent() {
        this.handleIndentOutdent(false);
    }

    public void handleIndentOutdent(boolean indent) {
        int tabSize = Preferences.getInteger("editor.tabs.size");
        String tabString = EMPTY.substring(0, tabSize);
        this.startCompoundEdit();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        int line = startLine;
        while (line <= stopLine) {
            int location = this.textarea.getLineStartOffset(line);
            if (indent) {
                this.textarea.select(location, location);
                this.textarea.setSelectedText(tabString);
            } else {
                int last = Math.min(location + tabSize, this.textarea.getDocumentLength());
                this.textarea.select(location, last);
                if (this.textarea.getSelectedText().equals(tabString)) {
                    this.textarea.setSelectedText("");
                }
            }
            ++line;
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
        this.sketch.setModified(true);
    }

    public static boolean checkParen(char[] array, int index, int stop) {
        while (index < stop) {
            switch (array[index]) {
                case '(': {
                    return true;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++index;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    protected boolean functionable(char c) {
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    protected String referenceCheck(boolean selectIfFound) {
        int start = this.textarea.getSelectionStart();
        int stop = this.textarea.getSelectionStop();
        if (stop < start) {
            int temp = stop;
            stop = start;
            start = temp;
        }
        char[] c = this.textarea.getText().toCharArray();
        if (start == stop) {
            while (start > 0 && this.functionable(c[start - 1])) {
                --start;
            }
            while (stop < c.length && this.functionable(c[stop])) {
                ++stop;
            }
        }
        String text = new String(c, start, stop - start).trim();
        if (Editor.checkParen(c, stop, c.length)) {
            text = String.valueOf(text) + "_";
        }
        String ref = this.mode.lookupReference(text);
        if (selectIfFound) {
            this.textarea.select(start, stop);
        }
        return ref;
    }

    protected void handleFindReference() {
        String ref = this.referenceCheck(true);
        if (ref != null) {
            this.showReference(String.valueOf(ref) + ".html");
        } else {
            String text = this.textarea.getSelectedText().trim();
            if (text.length() == 0) {
                this.statusNotice("First select a word to find in the reference.");
            } else {
                this.statusNotice("No reference available for \"" + text + "\"");
            }
        }
    }

    public void setSketchLocation(Point p) {
        this.sketchWindowLocation = p;
    }

    public Point getSketchLocation() {
        return this.sketchWindowLocation;
    }

    protected boolean checkModified() {
        if (!this.sketch.isModified()) {
            return true;
        }
        this.toFront();
        String prompt = "Save changes to " + this.sketch.getName() + "?  ";
        if (!Base.isMacOS()) {
            int result = JOptionPane.showConfirmDialog(this, prompt, "Close", 1, 3);
            if (result == 0) {
                return this.handleSave(true);
            }
            if (result == 1) {
                return true;
            }
            if (result == 2 || result == -1) {
                return false;
            }
            throw new IllegalStateException();
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
        Object[] options = new String[]{"Save", "Cancel", "Don't Save"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog dialog = pane.createDialog(this, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return this.handleSave(true);
        }
        return result == options[2];
    }

    protected boolean handleOpenInternal(String path) {
        File file = new File(path);
        File parentFile = new File(file.getParent());
        String parentName = parentFile.getName();
        String defaultName = String.valueOf(parentName) + "." + this.mode.getDefaultExtension();
        File altFile = new File(file.getParent(), defaultName);
        if (!defaultName.equals(file.getName())) {
            if (altFile.exists()) {
                path = altFile.getAbsolutePath();
            } else {
                if (!this.mode.canEdit(file)) {
                    String modeName = this.mode.getTitle().equals("Java") ? "Processing" : this.mode.getTitle();
                    Base.showWarning("Bad file selected", String.valueOf(modeName) + " can only open its own sketches\nand other files ending in " + this.mode.getDefaultExtension(), null);
                    return false;
                }
                String properParent = file.getName().substring(0, file.getName().lastIndexOf(46));
                Object[] options = new Object[]{"OK", "Cancel"};
                String prompt = "The file \"" + file.getName() + "\" needs to be inside\n" + "a sketch folder named \"" + properParent + "\".\n" + "Create this folder, move the file, and continue?";
                int result = JOptionPane.showOptionDialog(this, prompt, "Moving", 0, 3, null, options, options[0]);
                if (result == 0) {
                    File properFolder = new File(file.getParent(), properParent);
                    if (properFolder.exists()) {
                        Base.showWarning("Error", "A folder named \"" + properParent + "\" " + "already exists. Can't open sketch.", null);
                        return false;
                    }
                    if (!properFolder.mkdirs()) {
                        Base.showWarning("Error", "Could not create the sketch folder.", null);
                        return false;
                    }
                    File properPdeFile = new File(properFolder, file.getName());
                    File origPdeFile = new File(path);
                    try {
                        Base.copyFile(origPdeFile, properPdeFile);
                    }
                    catch (IOException e) {
                        Base.showWarning("Error", "Could not copy to a proper location.", e);
                        return false;
                    }
                    origPdeFile.delete();
                    path = properPdeFile.getAbsolutePath();
                } else if (result == 1) {
                    return false;
                }
            }
        }
        try {
            this.sketch = new Sketch(path, this);
        }
        catch (IOException e) {
            Base.showWarning("Error", "Could not create the sketch.", e);
            return false;
        }
        this.header.rebuild();
        this.updateTitle();
        Preferences.save();
        return true;
    }

    public void updateTitle() {
        this.setTitle(String.valueOf(this.sketch.getName()) + " | Processing " + Base.getVersionName());
        if (!this.sketch.isUntitled()) {
            File sketchFile = this.sketch.getMainFile();
            this.getRootPane().putClientProperty("Window.documentFile", sketchFile);
        } else {
            this.getRootPane().putClientProperty("Window.documentFile", null);
        }
    }

    public boolean handleSave(boolean immediately) {
        if (this.sketch.isUntitled()) {
            return this.handleSaveAs();
        }
        if (immediately) {
            this.handleSaveImpl();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Editor.this.handleSaveImpl();
                }
            });
        }
        return true;
    }

    protected void handleSaveImpl() {
        this.statusNotice("Saving...");
        try {
            if (this.sketch.save()) {
                this.statusNotice("Done Saving.");
            } else {
                this.statusEmpty();
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
    }

    public boolean handleSaveAs() {
        block3: {
            this.statusNotice("Saving...");
            try {
                if (this.sketch.saveAs()) {
                    this.statusNotice("Done Saving.");
                    break block3;
                }
                this.statusNotice("Save Canceled.");
                return false;
            }
            catch (Exception e) {
                this.statusError(e);
            }
        }
        return true;
    }

    public void handlePageSetup() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void handlePrint() {
        this.statusNotice("Printing...");
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat != null) {
            this.printerJob.setPrintable(this.textarea.getPrintable(), this.pageFormat);
        } else {
            this.printerJob.setPrintable(this.textarea.getPrintable());
        }
        this.printerJob.setJobName(this.sketch.getCurrentCode().getPrettyName());
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
                this.statusNotice("Done printing.");
            }
            catch (PrinterException pe) {
                this.statusError("Error while printing.");
                pe.printStackTrace();
            }
        } else {
            this.statusNotice("Printing canceled.");
        }
    }

    public void prepareRun() {
        this.internalCloseRunner();
        this.statusEmpty();
        int i = 0;
        while (i < 10) {
            System.out.println();
            ++i;
        }
        if (Preferences.getBoolean("console.auto_clear")) {
            this.console.clear();
        }
        this.sketch.ensureExistence();
        this.sketch.getCurrentCode().setProgram(this.getText());
    }

    public abstract void internalCloseRunner();

    public abstract void deactivateRun();

    @Override
    public void statusError(String what) {
        this.status.error(what);
    }

    @Override
    public void statusError(Exception e) {
        String mess;
        e.printStackTrace();
        if (e instanceof SketchException) {
            SketchException re = (SketchException)e;
            if (re.hasCodeIndex()) {
                this.sketch.setCurrentCode(re.getCodeIndex());
            }
            if (re.hasCodeLine()) {
                int line = re.getCodeLine();
                if (line >= this.textarea.getLineCount() && this.textarea.getLineText(line = this.textarea.getLineCount() - 1).length() == 0) {
                    --line;
                }
                if (line < 0 || line >= this.textarea.getLineCount()) {
                    System.err.println("Bad error line: " + line);
                } else {
                    this.textarea.select(this.textarea.getLineStartOffset(line), this.textarea.getLineStopOffset(line) - 1);
                }
            }
        }
        if ((mess = e.getMessage()) != null) {
            String rxString;
            String javaLang = "java.lang.";
            if (mess.indexOf(javaLang) == 0) {
                mess = mess.substring(javaLang.length());
            }
            if (mess.startsWith(rxString = "RuntimeException: ")) {
                mess = mess.substring(rxString.length());
            }
            this.statusError(mess);
        }
    }

    @Override
    public void statusNotice(String msg) {
        this.status.notice(msg);
    }

    public void clearNotice(String msg) {
        if (this.status.message.equals(msg)) {
            this.statusEmpty();
        }
    }

    public String getStatusMessage() {
        return this.status.message;
    }

    public int getStatusMode() {
        return this.status.mode;
    }

    public void statusEmpty() {
        this.statusNotice(EMPTY);
    }

    @Override
    public void startIndeterminate() {
        this.status.startIndeterminate();
    }

    @Override
    public void stopIndeterminate() {
        this.status.stopIndeterminate();
    }

    @Override
    public void statusHalt() {
    }

    @Override
    public boolean isHalted() {
        return false;
    }

    class FileDropHandler
    extends TransferHandler {
        FileDropHandler() {
        }

        @Override
        public boolean canImport(JComponent dest, DataFlavor[] flavors) {
            return true;
        }

        @Override
        public boolean importData(JComponent src, Transferable transferable) {
            int successful = 0;
            try {
                DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    int i = 0;
                    while (i < list.size()) {
                        File file = (File)list.get(i);
                        if (Editor.this.sketch.addFile(file)) {
                            ++successful;
                        }
                        ++i;
                    }
                } else if (transferable.isDataFlavorSupported(uriListFlavor)) {
                    String data = (String)transferable.getTransferData(uriListFlavor);
                    String[] pieces = PApplet.splitTokens((String)data, (String)"\r\n");
                    int i = 0;
                    while (i < pieces.length) {
                        if (!pieces[i].startsWith("#")) {
                            String path = null;
                            if (pieces[i].startsWith("file:///")) {
                                path = pieces[i].substring(7);
                            } else if (pieces[i].startsWith("file:/")) {
                                path = pieces[i].substring(5);
                            }
                            if (Editor.this.sketch.addFile(new File(path))) {
                                ++successful;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Base.showWarning("Drag & Drop Problem", "An error occurred while trying to add files to the sketch.", e);
                return false;
            }
            if (successful == 0) {
                Editor.this.statusError("No files were added to the sketch.");
            } else if (successful == 1) {
                Editor.this.statusNotice("One file added to the sketch.");
            } else {
                Editor.this.statusNotice(String.valueOf(successful) + " files added to the sketch.");
            }
            return true;
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.stopCompoundEdit();
            try {
                Editor.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {}
            try {
                Integer caret = (Integer)Editor.this.caretRedoStack.pop();
                Editor.this.caretUndoStack.push(caret);
                Editor.this.textarea.setCaretPosition(caret);
            }
            catch (Exception exception) {}
            this.updateRedoState();
            Editor.this.undoAction.updateUndoState();
            if (Editor.this.sketch != null) {
                Editor.this.sketch.setModified(!Editor.this.getText().equals(Editor.this.sketch.getCurrentCode().getSavedProgram()));
            }
        }

        protected void updateRedoState() {
            if (Editor.this.undo.canRedo()) {
                Editor.this.redoItem.setEnabled(true);
                Editor.this.redoItem.setText(Editor.this.undo.getRedoPresentationName());
                this.putValue("Name", Editor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                Editor.this.redoItem.setEnabled(false);
                Editor.this.redoItem.setText("Redo");
                this.putValue("Name", "Redo");
            }
        }
    }

    class TextAreaPopup
    extends JPopupMenu {
        JMenuItem cutItem = new JMenuItem("Cut");
        JMenuItem copyItem;
        JMenuItem discourseItem;
        JMenuItem referenceItem;

        public TextAreaPopup() {
            this.cutItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCut();
                }
            });
            this.add(this.cutItem);
            this.copyItem = new JMenuItem("Copy");
            this.copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCopy();
                }
            });
            this.add(this.copyItem);
            this.discourseItem = new JMenuItem("Copy as HTML");
            this.discourseItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCopyAsHTML();
                }
            });
            this.add(this.discourseItem);
            JMenuItem item = new JMenuItem("Paste");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handlePaste();
                }
            });
            this.add(item);
            item = new JMenuItem("Select All");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleSelectAll();
                }
            });
            this.add(item);
            this.addSeparator();
            item = new JMenuItem("Comment/Uncomment");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCommentUncomment();
                }
            });
            this.add(item);
            item = new JMenuItem("Increase Indent");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleIndentOutdent(true);
                }
            });
            this.add(item);
            item = new JMenuItem("Decrease Indent");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleIndentOutdent(false);
                }
            });
            this.add(item);
            this.addSeparator();
            this.referenceItem = new JMenuItem("Find in Reference");
            this.referenceItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleFindReference();
                }
            });
            this.add(this.referenceItem);
        }

        @Override
        public void show(Component component, int x, int y) {
            boolean active = Editor.this.textarea.isSelectionActive();
            this.cutItem.setEnabled(active);
            this.copyItem.setEnabled(active);
            this.discourseItem.setEnabled(active);
            this.referenceItem.setEnabled(Editor.this.referenceCheck(false) != null);
            super.show(component, x, y);
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.stopCompoundEdit();
            try {
                Integer caret = (Integer)Editor.this.caretUndoStack.pop();
                Editor.this.caretRedoStack.push(caret);
                Editor.this.textarea.setCaretPosition(caret);
                Editor.this.textarea.scrollToCaret();
            }
            catch (Exception exception) {}
            try {
                Editor.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {}
            this.updateUndoState();
            Editor.this.redoAction.updateRedoState();
            if (Editor.this.sketch != null) {
                Editor.this.sketch.setModified(!Editor.this.getText().equals(Editor.this.sketch.getCurrentCode().getSavedProgram()));
            }
        }

        protected void updateUndoState() {
            if (Editor.this.undo.canUndo() || Editor.this.compoundEdit != null && Editor.this.compoundEdit.isInProgress()) {
                this.setEnabled(true);
                Editor.this.undoItem.setEnabled(true);
                Editor.this.undoItem.setText(Editor.this.undo.getUndoPresentationName());
                this.putValue("Name", Editor.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                Editor.this.undoItem.setEnabled(false);
                Editor.this.undoItem.setText("Undo");
                this.putValue("Name", "Undo");
            }
        }
    }
}

