/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import java.io.File;
import java.util.Properties;
import net.sf.launch4j.Builder;
import net.sf.launch4j.Log;
import net.sf.launch4j.Messages;
import net.sf.launch4j.Util;
import net.sf.launch4j.config.ConfigPersister;
import net.sf.launch4j.formimpl.MainFrame;

public class Main {
    private static String _name;
    private static String _description;

    public static void main(String[] args) {
        try {
            Properties props = Util.getProperties();
            Main.setDescription(props);
            if (args.length == 0) {
                ConfigPersister.getInstance().createBlank();
                MainFrame.createInstance();
            } else if (args.length == 1 && !args[0].startsWith("-")) {
                ConfigPersister.getInstance().load(new File(args[0]));
                Builder b = new Builder(Log.getConsoleLog());
                b.build();
            } else {
                System.out.println(_description + Messages.getString("Main.usage") + ": launch4j config.xml");
            }
        }
        catch (Exception e) {
            Log.getConsoleLog().append(e.getMessage());
        }
    }

    public static String getName() {
        return _name;
    }

    public static String getDescription() {
        return _description;
    }

    private static void setDescription(Properties props) {
        _name = "Launch4j " + props.getProperty("version");
        _description = _name + " (http://launch4j.sourceforge.net/)\n" + "Cross-platform Java application wrapper" + " for creating Windows native executables.\n\n" + "Copyright (C) 2004, 2014 Grzegorz Kowal\n\n" + "Launch4j comes with ABSOLUTELY NO WARRANTY.\n" + "This is free software, licensed under the BSD License.\n" + "This product includes software developed by the Apache Software Foundation" + " (http://www.apache.org/).";
    }
}

