/*
 * Decompiled with CFR 0.152.
 */
package treemap;

import treemap.MapLayout;
import treemap.MapModel;
import treemap.Mappable;
import treemap.PivotBySplitSize;
import treemap.Rect;

public class Treemap {
    private MapModel model;
    private MapLayout algorithm;
    private Rect bounds;

    public Treemap(MapModel model, double x, double y, double w, double h) {
        this.model = model;
        this.algorithm = new PivotBySplitSize();
        this.updateLayout(x, y, w, h);
    }

    public void setLayout(MapLayout algorithm) {
        this.algorithm = algorithm;
    }

    public void updateLayout() {
        this.algorithm.layout(this.model, this.bounds);
    }

    public void updateLayout(double x, double y, double w, double h) {
        this.bounds = new Rect(x, y, w, h);
        this.updateLayout();
    }

    public void draw() {
        Mappable[] items = this.model.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].draw();
            ++i;
        }
    }
}

