/*
 * Decompiled with CFR 0.152.
 */
package treemap;

import treemap.AbstractMapLayout;
import treemap.Mappable;
import treemap.Rect;
import treemap.SliceLayout;

public class SquarifiedLayout
extends AbstractMapLayout {
    public void layout(Mappable[] items, Rect bounds) {
        this.layout(this.sortDescending(items), 0, items.length - 1, bounds);
    }

    /*
     * Unable to fully structure code
     */
    public void layout(Mappable[] items, int start, int end, Rect bounds) {
        block4: {
            if (start > end) {
                return;
            }
            if (end - start < 2) {
                SliceLayout.layoutBest(items, start, end, bounds);
                return;
            }
            x = bounds.x;
            y = bounds.y;
            w = bounds.w;
            h = bounds.h;
            total = this.sum(items, start, end);
            mid = start;
            b = a = items[start].getSize() / total;
            if (!(w < h)) ** GOTO lbl29
            while (mid <= end) {
                aspect = this.normAspect(h, w, a, b);
                q = items[mid].getSize() / total;
                if (this.normAspect(h, w, a, b + q) > aspect) break;
                ++mid;
                b += q;
            }
            SliceLayout.layoutBest(items, start, mid, new Rect(x, y, w, h * b));
            this.layout(items, mid + 1, end, new Rect(x, y + h * b, w, h * (1.0 - b)));
            break block4;
lbl-1000:
            // 1 sources

            {
                aspect = this.normAspect(w, h, a, b);
                q = items[mid].getSize() / total;
                if (this.normAspect(w, h, a, b + q) > aspect) break;
                ++mid;
                b += q;
lbl29:
                // 2 sources

                ** while (mid <= end)
            }
lbl30:
            // 2 sources

            SliceLayout.layoutBest(items, start, mid, new Rect(x, y, w * b, h));
            this.layout(items, mid + 1, end, new Rect(x + w * b, y, w * (1.0 - b), h));
        }
    }

    private double aspect(double big, double small, double a, double b) {
        return big * b / (small * a / b);
    }

    private double normAspect(double big, double small, double a, double b) {
        double x = this.aspect(big, small, a, b);
        if (x < 1.0) {
            return 1.0 / x;
        }
        return x;
    }

    private double sum(Mappable[] items, int start, int end) {
        double s = 0.0;
        int i = start;
        while (i <= end) {
            s += items[i].getSize();
            ++i;
        }
        return s;
    }

    public String getName() {
        return "Squarified";
    }

    public String getDescription() {
        return "Algorithm used by J.J. van Wijk.";
    }
}

