/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicyMapKey;
import com.sun.xml.internal.ws.policy.PolicyMerger;
import com.sun.xml.internal.ws.policy.PolicySubject;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.subject.PolicyMapKeyConverter;
import com.sun.xml.internal.ws.policy.subject.WsdlBindingSubject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.namespace.QName;

public class PolicyMapUtil {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyMapUtil.class);
    private static final PolicyMerger MERGER = PolicyMerger.getMerger();

    private PolicyMapUtil() {
    }

    public static void rejectAlternatives(PolicyMap policyMap) throws PolicyException {
        for (Policy policy : policyMap) {
            if (policy.getNumberOfAssertionSets() <= 1) continue;
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0035_RECONFIGURE_ALTERNATIVES(policy.getIdOrName())));
        }
    }

    public static void insertPolicies(PolicyMap policyMap, Collection<PolicySubject> collection, QName qName, QName qName2) throws PolicyException {
        Object object;
        Object object2;
        LOGGER.entering(policyMap, collection, qName, qName2);
        HashMap hashMap = new HashMap();
        for (PolicySubject object3 : collection) {
            Object object4 = object3.getSubject();
            if (!(object4 instanceof WsdlBindingSubject)) continue;
            object2 = (WsdlBindingSubject)object4;
            object = new LinkedList<Policy>();
            object.add(object3.getEffectivePolicy(MERGER));
            Collection collection2 = hashMap.put((WsdlBindingSubject)object2, object);
            if (collection2 == null) continue;
            object.addAll(collection2);
        }
        PolicyMapKeyConverter policyMapKeyConverter = new PolicyMapKeyConverter(qName, qName2);
        for (Object object4 : hashMap.keySet()) {
            object2 = new PolicySubject(object4, (Collection)hashMap.get(object4));
            object = policyMapKeyConverter.getPolicyMapKey((WsdlBindingSubject)object4);
            if (((WsdlBindingSubject)object4).isBindingSubject()) {
                policyMap.putSubject(PolicyMap.ScopeType.ENDPOINT, (PolicyMapKey)object, (PolicySubject)object2);
                continue;
            }
            if (((WsdlBindingSubject)object4).isBindingOperationSubject()) {
                policyMap.putSubject(PolicyMap.ScopeType.OPERATION, (PolicyMapKey)object, (PolicySubject)object2);
                continue;
            }
            if (!((WsdlBindingSubject)object4).isBindingMessageSubject()) continue;
            switch (((WsdlBindingSubject)object4).getMessageType()) {
                case INPUT: {
                    policyMap.putSubject(PolicyMap.ScopeType.INPUT_MESSAGE, (PolicyMapKey)object, (PolicySubject)object2);
                    break;
                }
                case OUTPUT: {
                    policyMap.putSubject(PolicyMap.ScopeType.OUTPUT_MESSAGE, (PolicyMapKey)object, (PolicySubject)object2);
                    break;
                }
                case FAULT: {
                    policyMap.putSubject(PolicyMap.ScopeType.FAULT_MESSAGE, (PolicyMapKey)object, (PolicySubject)object2);
                }
            }
        }
        LOGGER.exiting();
    }
}

