/*
 * Decompiled with CFR 0.152.
 */
package treemap;

import treemap.MapLayout;
import treemap.MapModel;
import treemap.Mappable;
import treemap.PivotBySplitSize;
import treemap.Rect;
import treemap.SimpleMapItem;

public class RecursiveTreemap
extends SimpleMapItem {
    private MapModel model;
    private MapLayout algorithm;

    public RecursiveTreemap(MapModel model, double x, double y, double w, double h) {
        this.model = model;
        this.setLayout(new PivotBySplitSize());
        this.setBounds(x, y, w, h);
        this.calcSize();
    }

    public void setLayout(MapLayout algorithm) {
        this.algorithm = algorithm;
    }

    public void updateLayout() {
        this.algorithm.layout(this.model, this.bounds);
    }

    public void setBounds(Rect bounds) {
        super.setBounds(bounds);
        this.updateLayout();
    }

    public void setBounds(double x, double y, double w, double h) {
        super.setBounds(x, y, w, h);
        this.updateLayout();
    }

    public void draw() {
        Mappable[] items = this.model.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].draw();
            ++i;
        }
    }

    private void calcSize() {
        double sum = 0.0;
        Mappable[] items = this.model.getItems();
        int i = 0;
        while (i < items.length) {
            sum += items[i].getSize();
            ++i;
        }
        this.setSize(sum);
    }
}

