/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swt;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.IntBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.gstreamer.elements.RGBDataSink;

public class VideoComponent
extends Canvas {
    private BufferedImage currentImage = null;
    private final RGBDataSink videosink;
    private final Lock bufferLock = new ReentrantLock();
    private boolean updatePending = false;
    private int alpha = 255;
    private String ovText;
    private long start = System.currentTimeMillis();
    private boolean keepAspect = true;
    private boolean showOverlay = false;
    private boolean showFPS = false;
    private Color bgColor;
    private int sizeX = 0;
    private int sizeY = 0;
    private int newX = 0;
    private int newY = 0;
    private final Runnable update = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            VideoComponent.this.bufferLock.lock();
            try {
                if (!VideoComponent.this.isDisposed()) {
                    VideoComponent.this.redraw();
                }
                VideoComponent.this.updatePending = false;
            }
            finally {
                VideoComponent.this.bufferLock.unlock();
            }
        }
    };

    public VideoComponent(final Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.videosink = new RGBDataSink("GstVideoComponent", new RGBListener());
        this.videosink.setPassDirectBuffer(true);
        final Font font = new Font((Device)this.getDisplay(), "Arial", 13, 0);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Point cSize = VideoComponent.this.getSize();
                if (VideoComponent.this.currentImage != null) {
                    event.gc.setFont(font);
                    VideoComponent.this.newX = 0;
                    VideoComponent.this.newY = 0;
                    int fps = 0;
                    int[] Frame2 = ((DataBufferInt)VideoComponent.this.currentImage.getRaster().getDataBuffer()).getData();
                    ImageData imgdata = new ImageData(VideoComponent.this.currentImage.getWidth(), VideoComponent.this.currentImage.getHeight(), 24, new PaletteData(0xFF0000, 65280, 255));
                    imgdata.setPixels(0, 0, VideoComponent.this.currentImage.getWidth() * VideoComponent.this.currentImage.getHeight(), Frame2, 0);
                    if (VideoComponent.this.currentImage.getWidth() != cSize.x || VideoComponent.this.currentImage.getHeight() != cSize.y) {
                        VideoComponent.this.sizeX = cSize.x;
                        VideoComponent.this.sizeY = cSize.y;
                        event.gc.setInterpolation(2);
                        if (VideoComponent.this.keepAspect) {
                            if ((float)VideoComponent.this.currentImage.getWidth() / (float)cSize.x > (float)VideoComponent.this.currentImage.getHeight() / (float)cSize.y) {
                                VideoComponent.this.sizeY = cSize.x * VideoComponent.this.currentImage.getHeight() / VideoComponent.this.currentImage.getWidth();
                                VideoComponent.this.newY = (cSize.y - VideoComponent.this.sizeY) / 2;
                            } else {
                                VideoComponent.this.sizeX = cSize.y * VideoComponent.this.currentImage.getWidth() / VideoComponent.this.currentImage.getHeight();
                                VideoComponent.this.newX = (cSize.x - VideoComponent.this.sizeX) / 2;
                            }
                        }
                        imgdata = imgdata.scaledTo(VideoComponent.this.sizeX, VideoComponent.this.sizeY);
                    }
                    if (VideoComponent.this.alpha != event.gc.getAlpha()) {
                        event.gc.setAlpha(VideoComponent.this.alpha);
                    }
                    Image image = new Image((Device)parent.getDisplay(), imgdata);
                    event.gc.drawImage(image, VideoComponent.this.newX, VideoComponent.this.newY);
                    if (VideoComponent.this.showFPS) {
                        fps = (int)(1000L / (System.currentTimeMillis() - VideoComponent.this.start));
                    }
                    if (VideoComponent.this.showOverlay) {
                        event.gc.drawText(VideoComponent.this.ovText, VideoComponent.this.newX + 5, VideoComponent.this.newY + 5, false);
                        VideoComponent.this.newY += 20;
                    }
                    if (VideoComponent.this.showFPS) {
                        event.gc.drawText(" FPS:" + fps, VideoComponent.this.newX + 5, VideoComponent.this.newY + 5, false);
                    }
                    image.dispose();
                    if (VideoComponent.this.showFPS) {
                        VideoComponent.this.start = System.currentTimeMillis();
                    }
                } else if (VideoComponent.this.bgColor != null) {
                    event.gc.setBackground(VideoComponent.this.bgColor);
                    event.gc.fillRectangle(0, 0, cSize.x, cSize.y);
                }
            }
        });
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getNewX() {
        return this.newX;
    }

    public int getNewY() {
        return this.newY;
    }

    public RGBDataSink getElement() {
        return this.videosink;
    }

    public void setKeepAspect(boolean keepAspect) {
        this.keepAspect = keepAspect;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setOverlay(String text) {
        this.ovText = text;
    }

    public void showFPS(boolean bn) {
        this.showFPS = bn;
    }

    public void showOverlay(boolean bn) {
        this.showOverlay = bn;
    }

    public int getAlpha() {
        return this.alpha;
    }

    private BufferedImage getBufferedImage(int width, int height) {
        if (this.currentImage != null && this.currentImage.getWidth() == width && this.currentImage.getHeight() == height) {
            return this.currentImage;
        }
        if (this.currentImage != null) {
            this.currentImage.flush();
        }
        this.currentImage = new BufferedImage(width, height, 1);
        this.currentImage.setAccelerationPriority(0.0f);
        return this.currentImage;
    }

    public void setBackGroundColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public Color getBackGroundColorColor() {
        return this.bgColor;
    }

    private class RGBListener
    implements RGBDataSink.Listener {
        private RGBListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rgbFrame(boolean isPrerollFrame, int width, int height, IntBuffer rgb) {
            if (!VideoComponent.this.bufferLock.tryLock()) {
                return;
            }
            if (VideoComponent.this.updatePending && !isPrerollFrame) {
                VideoComponent.this.bufferLock.unlock();
                return;
            }
            try {
                BufferedImage renderImage = VideoComponent.this.getBufferedImage(width, height);
                int[] pixels = ((DataBufferInt)renderImage.getRaster().getDataBuffer()).getData();
                rgb.get(pixels, 0, width * height);
                VideoComponent.this.updatePending = true;
            }
            finally {
                VideoComponent.this.bufferLock.unlock();
            }
            if (!VideoComponent.this.isDisposed()) {
                VideoComponent.this.getDisplay().asyncExec(VideoComponent.this.update);
            }
        }
    }
}

