/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.event;

import com.sun.jna.Library;
import com.sun.jna.Pointer;
import org.gstreamer.Event;
import org.gstreamer.Structure;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.annotations.Invalidate;

public class NavigationEvent
extends Event {
    private static final API gst = GstNative.load(API.class);

    public NavigationEvent(NativeObject.Initializer init) {
        super(init);
    }

    public NavigationEvent(Structure structure) {
        this(NavigationEvent.initializer(gst.ptr_gst_event_new_navigation(structure)));
    }

    public String toString() {
        Structure s = this.getStructure();
        String event = s.getString("event");
        if (event.startsWith("key-")) {
            return String.format("%s: [key=%s]", event, s.getString("key"));
        }
        if (event.startsWith("mouse-")) {
            return String.format("%s: [x=%f, y=%f button=%x]", event, s.getDouble("pointer_x"), s.getDouble("pointer_y"), s.getInteger("button"));
        }
        return String.format("%s", s.getString("event"));
    }

    public static NavigationEvent createMouseEvent(String event, double x, double y, int button) {
        return new MouseEvent(event, x, y, button);
    }

    public static NavigationEvent createMouseMoveEvent(double x, double y, int button) {
        return NavigationEvent.createMouseEvent("mouse-move", x, y, button);
    }

    public static NavigationEvent createMouseButtonPressEvent(double x, double y, int button) {
        return NavigationEvent.createMouseEvent("mouse-button-press", x, y, button);
    }

    public static NavigationEvent createMouseButtonReleaseEvent(double x, double y, int button) {
        return NavigationEvent.createMouseEvent("mouse-button-release", x, y, button);
    }

    public static NavigationEvent createKeyEvent(String event, String key) {
        return new KeyEvent(event, key);
    }

    public static NavigationEvent createKeyPressEvent(String key) {
        return NavigationEvent.createKeyEvent("key-press", key);
    }

    public static NavigationEvent createKeyReleaseEvent(String key) {
        return NavigationEvent.createKeyEvent("key-release", key);
    }

    private static final class KeyEvent
    extends NavigationEvent {
        public KeyEvent(String event, String key) {
            super(new Structure("application/x-gst-navigation", "event", new Object[]{GType.STRING, event, "key", GType.STRING, key}));
        }

        public String toString() {
            Structure s = this.getStructure();
            return String.format("%s: [key=%s]", s.getString("event"), s.getString("key"));
        }
    }

    private static final class MouseEvent
    extends NavigationEvent {
        public MouseEvent(String event, double x, double y, int button) {
            super(new Structure("application/x-gst-navigation", "event", new Object[]{GType.STRING, event, "button", GType.INT, button, "pointer_x", GType.DOUBLE, x, "pointer_y", GType.DOUBLE, y}));
        }

        public String toString() {
            Structure s = this.getStructure();
            return String.format("%s: [x=%f, y=%f button=%x]", s.getString("event"), s.getDouble("pointer_x"), s.getDouble("pointer_y"), s.getInteger("button"));
        }
    }

    private static interface API
    extends Library {
        public Pointer ptr_gst_event_new_navigation(@Invalidate Structure var1);
    }
}

