import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import ddf.minim.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class simulaatio15 extends PApplet {



public interface Effect {
  public void setup(PGraphics pg);
  public void draw(PGraphics pg); 
}

  static Effect[] effects;
  static float partTimes[] = {600, 3500, 1000, 3000, 
                              4500, 5000, 14000};
  Minim minim;
  AudioPlayer player;
  float startTime = -1;
  int activePart = 0, lastPart = -1;
//  int frame = 0;

  PGraphics pg;

  public void setup() {
    pg = createGraphics(displayWidth, displayHeight);
    pg.background(0);
    pg.setSize(displayWidth, displayHeight);
    pg.smooth();
    frameRate(25);
    sketchFullScreen();
    minim = new Minim(this);
    print(dataPath("valmet_children_-_ohansevarma_demoedit.mp3"));
    player = minim.loadFile(dataPath("valmet_children_-_ohansevarma_demoedit.mp3"), 2048);
    effects = new Effect[7];
    effects[0] = new Sleeper();
    effects[1] = new Starfield3();
    effects[2] = new Starfield3();
    effects[3] = new Starfield3();
    effects[4] = new Starfield4();
    effects[5] = new Starfield5();
    effects[6] = new Starfield1();
    for (Effect fx: effects) {
      fx.setup(pg);
    }
    player.play();
  }  

  public void draw()
  {
    if (startTime == -1)
      startTime = millis();
    lastPart = activePart;
    float pastParts = 0;
    for (int i = 0; i < activePart; i++)
      pastParts += partTimes[i];
    if (millis() - pastParts - startTime > partTimes[activePart]) {
      println(millis()-pastParts-startTime + " greater than " + partTimes[activePart] + ", moving on to next part...");
      lastPart = activePart++;
    }
    if ((lastPart == 3 && activePart == 4) 
        || (lastPart == 4 && activePart == 5)
        || (lastPart == 5 && activePart == 6))
    {
      println("Last part: " + lastPart + ", active: " + activePart + ", clearing...");
      pg.clear();      
      clear();
    }
    if (activePart < effects.length)
      effects[activePart].draw(pg);
    else
      exit();
    image(((PImage)pg), 0, 0);
//    save(frame + ".png");
//    frame++;
  }
  
  public void stop()
  {
    player.close();
    minim.stop();
    super.stop();
  }

public class Sleeper implements Effect {
  public void setup(PGraphics pg) {}
  
  public void draw(PGraphics pg)
  { 
    pg.beginDraw();
    pg.clear();
    pg.endDraw();
  }
}
public class Starfield3 implements Effect
{
  int starsize = 5, starcount = 100;
  int s_lo = -12, s_hi = 12; 
  
  float sizeratio = 0.15f;
  
  PVector location[], speed[];
  
  public void setup(PGraphics pg)
  {  
    location = new PVector[starcount];
    speed = new PVector[starcount];
    for (int i = 0; i < starcount; i++) {
      location[i] = new PVector(pg.width/2, pg.height/2);
      speed[i] = new PVector(random(s_lo, s_hi), random(s_lo, s_hi));
    }
  }
  
  public void draw(PGraphics pg)
  {
    pg.beginDraw();
    PVector center = new PVector(pg.width/2, pg.height/2);
    for (int i = 0; i < starcount; i++) {
      location[i].add(speed[i]);
      pg.ellipse(location[i].x, location[i].y, starsize + sizeratio*center.dist(location[i]), starsize+sizeratio*center.dist(location[i]));
    }
    pg.endDraw();
  }
  
  public void mouseClicked(MouseEvent e)
  {
    if (mouseButton == RIGHT)
      clear();
    for (PVector l: location) {
//      l.set(w/2, h/2);
    }    
    for (PVector s: speed) {
//      s.set(random(s_lo, s_hi), random(s_lo, s_hi));
    }
  }  //method
}  //class
public class Starfield4 implements Effect
{
  int starsize = 50, starcount = 100;
  int s_lo = -8, s_hi = 8; 
  
  float sizeratio = -0.15f;
  
  PVector location[], speed[];
  
  public void setup(PGraphics pg)
  {
    location = new PVector[starcount];
    speed = new PVector[starcount];
    for (int i = 0; i < starcount; i++) {
      location[i] = new PVector(pg.width/2, pg.height/2);
      speed[i] = new PVector(random(s_lo, s_hi), random(s_lo, s_hi));
    }
  }
  
  public void draw(PGraphics pg)
  {
    pg.beginDraw();
    PVector center = new PVector(pg.width/2, pg.height/2);
    for (int i = 0; i < starcount; i++) {
      location[i].add(speed[i]);
      pg.ellipse(location[i].x, location[i].y, starsize + sizeratio*center.dist(location[i]), starsize+sizeratio*center.dist(location[i]));
    }
    pg.endDraw();
  }
  
  public void mouseClicked(MouseEvent e)
  {
    if (mouseButton == RIGHT)
      clear();
    for (PVector l: location) {
//      l.set(w/2, h/2);
    }    
    for (PVector s: speed) {
//      s.set(random(s_lo, s_hi), random(s_lo, s_hi));
    }
  }  //method
}  //class
public class Starfield5 implements Effect
{
  int w, h;
  int starsize = 5, starcount = 2;
  
  float sizeratio = 0.35f;
  
  PVector location[], speed[];
  float anglespeed, angle[];
  PVector center = new PVector(w/2, h/2);
  
  public void setup(PGraphics pg)
  {
    w = pg.width; h = pg.height;
    background(0);
    size(w, h);
    smooth();
    sketchFullScreen();
  
    location = new PVector[starcount];
    speed = new PVector[starcount];
    angle = new float[starcount];
    for (int i = 0; i < starcount; i++) {
      location[i] = new PVector(w/2, h/2);
    }
    angle[0] = PI/2;
    angle[1] = 3*PI/2;
    speed[0] = new PVector(0, -0.5f);
    speed[1] = new PVector(0, 0.5f);
    anglespeed = 0.001f;
  }
  
  public void draw(PGraphics pg)
  {
    pg.beginDraw();
    PVector center = new PVector(pg.width/2, pg.height/2);
    for (int i = 0; i < starcount; i++) {
      angle[i] = angle[i] + anglespeed*center.dist(location[i]);
      location[i].add(new PVector(25*cos(angle[i]), 25*sin(angle[i])));
      location[i].add(speed[i]);
      println("angle: " + angle[i] + " cos: " + cos(angle[i]) + " sin: " + sin(angle[i]));
      pg.ellipse(location[i].x, location[i].y, starsize + sizeratio*center.dist(location[i]), starsize+sizeratio*center.dist(location[i]));
    }
    pg.endDraw();
  }
  
  public void mouseClicked(MouseEvent e)
  {
    if (mouseButton == RIGHT)
      clear();
    for (PVector l: location) {
//      l.set(w/2, h/2);
    }    
    for (PVector s: speed) {
//      s.set(random(s_lo, s_hi), random(s_lo, s_hi));
    }
  }  //method
}  //class
public class Starfield1 implements Effect
{
  int starsize = 10, starcount = 100;
  
  int frame = 0;  
  PVector location[];
  
  public void setup(PGraphics pg)
  {
    pg.background(0);
    pg.smooth();
  
    location = new PVector[starcount];
    for (int i = 0; i < starcount; i++)
      location[i] = new PVector(pg.width/2, pg.height/2);
  }
  
  public void draw(PGraphics pg)
  {
    pg.beginDraw();
    if (++frame == 100 || frame == 200 || frame == 230) {
      clear();
      pg.clear();
    }
    for (int i = 0; i < starcount; i++) {
      PVector speed = new PVector(random(-12, 12), random(-12, 12));
      location[i].add(speed);
 //     println("x : " + location[i].x + ", y: " + location[i].y + " s: " + starsize);
      pg.ellipse(location[i].x, location[i].y, starsize, starsize);
    }
    
    pg.endDraw();
  }
  
  public void mouseClicked(MouseEvent e)
  {
    if (mouseButton == RIGHT)
      clear();
    if (mouseButton == LEFT)
      for (PVector l: location) {
//        l.set(w/2, h/2);
      }    
  }
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--full-screen", "--bgcolor=#666666", "--hide-stop", "simulaatio15" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
