public class Starfield4 implements Effect
{
  int starsize = 50, starcount = 100;
  int s_lo = -8, s_hi = 8; 
  
  float sizeratio = -0.15;
  
  PVector location[], speed[];
  
  void setup(PGraphics pg)
  {
    location = new PVector[starcount];
    speed = new PVector[starcount];
    for (int i = 0; i < starcount; i++) {
      location[i] = new PVector(pg.width/2, pg.height/2);
      speed[i] = new PVector(random(s_lo, s_hi), random(s_lo, s_hi));
    }
  }
  
  void draw(PGraphics pg)
  {
    pg.beginDraw();
    PVector center = new PVector(pg.width/2, pg.height/2);
    for (int i = 0; i < starcount; i++) {
      location[i].add(speed[i]);
      pg.ellipse(location[i].x, location[i].y, starsize + sizeratio*center.dist(location[i]), starsize+sizeratio*center.dist(location[i]));
    }
    pg.endDraw();
  }
  
  void mouseClicked(MouseEvent e)
  {
    if (mouseButton == RIGHT)
      clear();
    for (PVector l: location) {
//      l.set(w/2, h/2);
    }    
    for (PVector s: speed) {
//      s.set(random(s_lo, s_hi), random(s_lo, s_hi));
    }
  }  //method
}  //class
