var demo = {Config:{}};
(function() {
  demo.Config.BEATS_PER_MINUTE = 127;
  demo.Config.BEATS_PER_BAR = 4;
  demo.Config.TICKS_PER_BEAT = 12;
  demo.Config.MUSIC_BEGIN = 500;
  demo.Config.song = {src:"bin/bg.ogg", enableFFT:!0};
  demo.Config.DEBUG = !0;
  var d = function(c, a, b) {
    return new kvg.core.TimeSig(c, a, b);
  };
  demo.Config.PARTS = {WaterPart:"demo.parts.WaterPart", BallTest:"demo.parts.BallTest", Greet2Part:"demo.parts.Greet2Part", AsteroidPart:"demo.parts.AsteroidPart", OpeningPart:"demo.parts.OpeningPart", TunnelPart:"demo.parts.TunnelPart"};
  demo.Config.TIMELINE = [{part:"OpeningPart", start:d(0, 0, 0), end:d(8, 2, 0), rts:!0}, {part:"AsteroidPart", start:d(8, 2, 0), end:d(28, 0, 0), rts:!0}, {part:"TunnelPart", start:d(20, 0, 0), end:d(28, 0, 0), rts:!1}, {part:"TunnelPart", start:d(28, 0, 0), end:d(40, 0, 0), rts:!0}, {part:"BallTest", start:d(36, 0, 0), end:d(40, 0, 0), rts:!1}, {part:"BallTest", start:d(40, 0, 0), end:d(62, 0, 0), rts:!0}, {part:"WaterPart", start:d(51, 0, 0), end:d(62, 0, 0), rts:!1}, {part:"WaterPart", start:d(62, 
  0, 0), end:d(68, 0, 0), rts:!0}, {part:"Greet2Part", start:d(65, 0, 0), end:d(68, 0, 0), rts:!1}, {part:"Greet2Part", start:d(68, 0, 0), end:d(88, 0, 0), rts:!0}];
})();
demo.parts = {};
demo.parts.CubePart = {};
(function() {
  var d = (demo.parts.CubePart = function() {
  }).prototype = new kvg.core.Part;
  d.init = function() {
    kvg.core.Part.prototype.init.call(this);
    this.initStandardScene();
    this.initStandardComposer();
    for (var c = new THREE.CubeGeometry(50, 50, 50), a = 0;a < c.faces.length;a += 2) {
      var b = 16777215 * Math.random();
      c.faces[a].color.setHex(b);
      c.faces[a + 1].color.setHex(b);
    }
    b = new THREE.MeshBasicMaterial({vertexColors:THREE.FaceColors});
    this.cube = new THREE.Mesh(c, b);
    this.cube.position.y = 0;
    this.cubes = [];
    for (a = 0;100 > a;a++) {
      var d = new THREE.Mesh(c, b);
      d.position.x = 800 * Math.random() - 400;
      d.position.y = 0 + 600 * Math.random() - 300;
      d.position.z = -200;
      d.scale.x = .1;
      d.scale.y = .1;
      d.scale.z = .1;
      this.scene.add(d);
      this.cubes.push(d);
    }
    this.scene.add(this.cube);
    this.scale = 1;
    this.addTrigger(new kvg.core.TimeSig(0, 0, 0, kvg.core.TimeSig.PATTERN), this.everyBar);
  };
  d.update = function(c) {
    kvg.core.Part.prototype.update.call(this, c);
  };
  d.render = function() {
    var c = kvg.core.graphics.renderer;
    c.autoClear = this.autoClear;
    c.setClearColor("#000", 1);
    this.composer.render();
  };
  d.everyBar = function() {
    this.scale = 2;
    this.cube.rotateX(-.2);
    this.cube.rotateY(-.2);
  };
})();
demo.parts.CubePart2 = {};
(function() {
  var d = (demo.parts.CubePart2 = function() {
  }).prototype = new kvg.core.Part;
  d.init = function() {
    kvg.core.Part.prototype.init.call(this);
    this.initStandardScene();
    this.initStandardComposer();
    var c = new THREE.CubeGeometry(50, 50, 50), a = new THREE.MeshBasicMaterial({map:kvg.core.demo.parts.CubePart.renderTo});
    this.cube = new THREE.Mesh(c, a);
    this.cube.position.y = 0;
    this.cube.position.z = 400;
    this.scene.add(this.cube);
    this.scale = 1;
    this.addTrigger(new kvg.core.TimeSig(0, 0, 0, kvg.core.TimeSig.PATTERN), this.everyBar);
  };
  d.update = function(c) {
    kvg.core.Part.prototype.update.call(this, c);
    this.cube.rotateX(.03);
    this.cube.rotateY(.03);
    this.scale = 1 >= this.scale ? 1 : this.scale - .05;
    this.cube.scale.set(this.scale, this.scale, this.scale);
  };
  d.render = function() {
    kvg.core.Part.prototype.render.call(this);
  };
  d.everyBar = function() {
    this.scale = 2;
    this.cube.rotateX(-.4);
    this.cube.rotateY(-.4);
  };
})();
demo.parts.WaterPartShaders = {};
demo.parts.WaterPartShaders.SphereShader = {};
(function() {
  demo.parts.WaterPartShaders.SphereShader = {attributes:{}, vertex:"vec3 mod289(vec3 x)\n{\nreturn x - floor(x * (1.0 / 289.0)) * 289.0;\n}\n\nvec4 mod289(vec4 x)\n{\nreturn x - floor(x * (1.0 / 289.0)) * 289.0;\n}\n\nvec4 permute(vec4 x)\n{\nreturn mod289(((x*34.0)+1.0)*x);\n}\n\nvec4 taylorInvSqrt(vec4 r)\n{\nreturn 1.79284291400159 - 0.85373472095314 * r;\n}\n\nvec3 fade(vec3 t) {\nreturn t*t*t*(t*(t*6.0-15.0)+10.0);\n}\n\n// Classic Perlin noise\nfloat cnoise(vec3 P)\n{\nvec3 Pi0 = floor(P); // Integer part for indexing\nvec3 Pi1 = Pi0 + vec3(1.0); // Integer part + 1\nPi0 = mod289(Pi0);\nPi1 = mod289(Pi1);\nvec3 Pf0 = fract(P); // Fractional part for interpolation\nvec3 Pf1 = Pf0 - vec3(1.0); // Fractional part - 1.0\nvec4 ix = vec4(Pi0.x, Pi1.x, Pi0.x, Pi1.x);\nvec4 iy = vec4(Pi0.yy, Pi1.yy);\nvec4 iz0 = Pi0.zzzz;\nvec4 iz1 = Pi1.zzzz;\n\nvec4 ixy = permute(permute(ix) + iy);\nvec4 ixy0 = permute(ixy + iz0);\nvec4 ixy1 = permute(ixy + iz1);\n\nvec4 gx0 = ixy0 * (1.0 / 7.0);\nvec4 gy0 = fract(floor(gx0) * (1.0 / 7.0)) - 0.5;\ngx0 = fract(gx0);\nvec4 gz0 = vec4(0.5) - abs(gx0) - abs(gy0);\nvec4 sz0 = step(gz0, vec4(0.0));\ngx0 -= sz0 * (step(0.0, gx0) - 0.5);\ngy0 -= sz0 * (step(0.0, gy0) - 0.5);\n\nvec4 gx1 = ixy1 * (1.0 / 7.0);\nvec4 gy1 = fract(floor(gx1) * (1.0 / 7.0)) - 0.5;\ngx1 = fract(gx1);\nvec4 gz1 = vec4(0.5) - abs(gx1) - abs(gy1);\nvec4 sz1 = step(gz1, vec4(0.0));\ngx1 -= sz1 * (step(0.0, gx1) - 0.5);\ngy1 -= sz1 * (step(0.0, gy1) - 0.5);\n\nvec3 g000 = vec3(gx0.x,gy0.x,gz0.x);\nvec3 g100 = vec3(gx0.y,gy0.y,gz0.y);\nvec3 g010 = vec3(gx0.z,gy0.z,gz0.z);\nvec3 g110 = vec3(gx0.w,gy0.w,gz0.w);\nvec3 g001 = vec3(gx1.x,gy1.x,gz1.x);\nvec3 g101 = vec3(gx1.y,gy1.y,gz1.y);\nvec3 g011 = vec3(gx1.z,gy1.z,gz1.z);\nvec3 g111 = vec3(gx1.w,gy1.w,gz1.w);\n\nvec4 norm0 = taylorInvSqrt(vec4(dot(g000, g000), dot(g010, g010), dot(g100, g100), dot(g110, g110)));\ng000 *= norm0.x;\ng010 *= norm0.y;\ng100 *= norm0.z;\ng110 *= norm0.w;\nvec4 norm1 = taylorInvSqrt(vec4(dot(g001, g001), dot(g011, g011), dot(g101, g101), dot(g111, g111)));\ng001 *= norm1.x;\ng011 *= norm1.y;\ng101 *= norm1.z;\ng111 *= norm1.w;\n\nfloat n000 = dot(g000, Pf0);\nfloat n100 = dot(g100, vec3(Pf1.x, Pf0.yz));\nfloat n010 = dot(g010, vec3(Pf0.x, Pf1.y, Pf0.z));\nfloat n110 = dot(g110, vec3(Pf1.xy, Pf0.z));\nfloat n001 = dot(g001, vec3(Pf0.xy, Pf1.z));\nfloat n101 = dot(g101, vec3(Pf1.x, Pf0.y, Pf1.z));\nfloat n011 = dot(g011, vec3(Pf0.x, Pf1.yz));\nfloat n111 = dot(g111, Pf1);\n\nvec3 fade_xyz = fade(Pf0);\nvec4 n_z = mix(vec4(n000, n100, n010, n110), vec4(n001, n101, n011, n111), fade_xyz.z);\nvec2 n_yz = mix(n_z.xy, n_z.zw, fade_xyz.y);\nfloat n_xyz = mix(n_yz.x, n_yz.y, fade_xyz.x); \nreturn 2.2 * n_xyz;\n}\n\n// Classic Perlin noise, periodic variant\nfloat pnoise(vec3 P, vec3 rep)\n{\nvec3 Pi0 = mod(floor(P), rep); // Integer part, modulo period\nvec3 Pi1 = mod(Pi0 + vec3(1.0), rep); // Integer part + 1, mod period\nPi0 = mod289(Pi0);\nPi1 = mod289(Pi1);\nvec3 Pf0 = fract(P); // Fractional part for interpolation\nvec3 Pf1 = Pf0 - vec3(1.0); // Fractional part - 1.0\nvec4 ix = vec4(Pi0.x, Pi1.x, Pi0.x, Pi1.x);\nvec4 iy = vec4(Pi0.yy, Pi1.yy);\nvec4 iz0 = Pi0.zzzz;\nvec4 iz1 = Pi1.zzzz;\n\nvec4 ixy = permute(permute(ix) + iy);\nvec4 ixy0 = permute(ixy + iz0);\nvec4 ixy1 = permute(ixy + iz1);\n\nvec4 gx0 = ixy0 * (1.0 / 7.0);\nvec4 gy0 = fract(floor(gx0) * (1.0 / 7.0)) - 0.5;\ngx0 = fract(gx0);\nvec4 gz0 = vec4(0.5) - abs(gx0) - abs(gy0);\nvec4 sz0 = step(gz0, vec4(0.0));\ngx0 -= sz0 * (step(0.0, gx0) - 0.5);\ngy0 -= sz0 * (step(0.0, gy0) - 0.5);\n\nvec4 gx1 = ixy1 * (1.0 / 7.0);\nvec4 gy1 = fract(floor(gx1) * (1.0 / 7.0)) - 0.5;\ngx1 = fract(gx1);\nvec4 gz1 = vec4(0.5) - abs(gx1) - abs(gy1);\nvec4 sz1 = step(gz1, vec4(0.0));\ngx1 -= sz1 * (step(0.0, gx1) - 0.5);\ngy1 -= sz1 * (step(0.0, gy1) - 0.5);\n\nvec3 g000 = vec3(gx0.x,gy0.x,gz0.x);\nvec3 g100 = vec3(gx0.y,gy0.y,gz0.y);\nvec3 g010 = vec3(gx0.z,gy0.z,gz0.z);\nvec3 g110 = vec3(gx0.w,gy0.w,gz0.w);\nvec3 g001 = vec3(gx1.x,gy1.x,gz1.x);\nvec3 g101 = vec3(gx1.y,gy1.y,gz1.y);\nvec3 g011 = vec3(gx1.z,gy1.z,gz1.z);\nvec3 g111 = vec3(gx1.w,gy1.w,gz1.w);\n\nvec4 norm0 = taylorInvSqrt(vec4(dot(g000, g000), dot(g010, g010), dot(g100, g100), dot(g110, g110)));\ng000 *= norm0.x;\ng010 *= norm0.y;\ng100 *= norm0.z;\ng110 *= norm0.w;\nvec4 norm1 = taylorInvSqrt(vec4(dot(g001, g001), dot(g011, g011), dot(g101, g101), dot(g111, g111)));\ng001 *= norm1.x;\ng011 *= norm1.y;\ng101 *= norm1.z;\ng111 *= norm1.w;\n\nfloat n000 = dot(g000, Pf0);\nfloat n100 = dot(g100, vec3(Pf1.x, Pf0.yz));\nfloat n010 = dot(g010, vec3(Pf0.x, Pf1.y, Pf0.z));\nfloat n110 = dot(g110, vec3(Pf1.xy, Pf0.z));\nfloat n001 = dot(g001, vec3(Pf0.xy, Pf1.z));\nfloat n101 = dot(g101, vec3(Pf1.x, Pf0.y, Pf1.z));\nfloat n011 = dot(g011, vec3(Pf0.x, Pf1.yz));\nfloat n111 = dot(g111, Pf1);\n\nvec3 fade_xyz = fade(Pf0);\nvec4 n_z = mix(vec4(n000, n100, n010, n110), vec4(n001, n101, n011, n111), fade_xyz.z);\nvec2 n_yz = mix(n_z.xy, n_z.zw, fade_xyz.y);\nfloat n_xyz = mix(n_yz.x, n_yz.y, fade_xyz.x); \nreturn 2.2 * n_xyz;\n}\nattribute vec4 tangent;\nuniform float time;\nvarying float noise;\nuniform vec2 repeat;\nuniform float useNormal;\nuniform float useRim;\nuniform float shred;\nvarying vec2 vUv;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec3 vEye;\nvarying vec3 vU;\nvarying vec2 vN;\nfloat turbulence( vec3 p ) {\nfloat w = 100.0;\nfloat t = -.5;\nfor (float f = 1.0 ; f <= 10.0 ; f++ ){\nfloat power = pow( 2.0, f );\nt += abs( pnoise( vec3( power * p ), vec3( 10.0, 10.0, 10.0 ) ) / power );\n}\nreturn t;\n}\nvoid main() {\nvU = normalize( vec3( modelViewMatrix * vec4( position, 1.0 ) ) );\nif( useNormal == 0. ) {\nvec3 n = normalize( normalMatrix * normal );\nvec3 r = reflect( vU, n );\nfloat m = 2.0 * sqrt( r.x * r.x + r.y * r.y + ( r.z + 1.0 ) * ( r.z+1.0 ) );\nvN = vec2( r.x / m + 0.5,  r.y / m + 0.5 );\n} else {\nvN = vec2( 0. );\n}\nvUv = repeat * uv;\nnoise = 10.0 *  -.10 * turbulence( .5 * normal + time );\nfloat b = 15.0 * shred * pnoise( 0.05 * position + vec3( 2.0 * time ), vec3( 100.0 ) );\nfloat displacement = - 2. * noise + b;\nvec3 newPosition = position + normal * displacement;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( newPosition, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nif( useNormal == 1. ) {\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = normalize( cross( vNormal, vTangent ) * tangent.w );\n} else {\nvTangent = vec3( 0. );\nvBinormal = vec3( 0. );\n}\nif( useRim > 0. ) {\nvEye = ( modelViewMatrix * vec4( position, 1.0 ) ).xyz;\n} else {\nvEye = vec3( 0. );\n}\n}", 
  fragment:"uniform float time;\nuniform float bump;\nuniform sampler2D tNormal;\nuniform sampler2D tMatCap;\nuniform float noise;\nuniform float useNormal;\nuniform float useRim;\nuniform float rimPower;\nuniform float useScreen;\nuniform float normalScale;\nuniform float normalRepeat;\nuniform float lightness;\nvarying vec2 vUv;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec3 vEye;\nvarying vec3 vU;\nvarying vec2 vN;\nfloat random(vec3 scale,float seed){return fract(sin(dot(gl_FragCoord.xyz+seed,scale))*43758.5453+seed);}\nvoid main() {\nvec3 finalNormal = vNormal;\nvec2 calculatedNormal = vN;\nif( useNormal == 1. ) {\nvec3 normalTex = texture2D( tNormal, vUv  ).xyz * 2.0 - 1.0;\nnormalTex.xy *= normalScale;\nnormalTex.y *= -1.;\nnormalTex = normalize( normalTex );\nmat3 tsb = mat3( normalize( vTangent ), normalize( vBinormal ), normalize( vNormal ) );\nfinalNormal = tsb * normalTex;\nvec3 r = reflect( vU, normalize( finalNormal ) );\nfloat m = 2.0 * sqrt( r.x * r.x + r.y * r.y + ( r.z + 1.0 ) * ( r.z+1.0 ) );\ncalculatedNormal = vec2( r.x / m + 0.5,  r.y / m + 0.5 );\n}\nvec3 base = texture2D( tMatCap, calculatedNormal ).rgb;\nif( useRim > 0. ) {\nfloat f = rimPower * abs( dot( vNormal, normalize( vEye ) ) );\nf = useRim * ( 1. - smoothstep( 0.0, 1., f ) );\nbase += vec3( f );\n}\nif( useScreen == 1. ) {\nbase = vec3( 1. ) - ( vec3( 1. ) - base ) * ( vec3( 1. ) - base );\n}\ngl_FragColor = vec4( lightness * 2.0*base, 1. );\n}"};
})();
demo.transition = {};
demo.transition.TransitionShader = {};
(function() {
  demo.transition.TransitionShader = function() {
    this.uniforms = {zoom:{type:"f", value:.6}, resolution:{type:"v2", value:new THREE.Vector2(8, 8)}, time:{type:"f", value:164}, texture:{type:"t", value:null}};
    this.vertex = d;
    this.fragment = c;
  };
  var d = "varying vec3 vNormal;\nvarying vec2 vUv;\nvoid main() {\nvNormal = normal;\nvec3 p = position;\nvUv = uv;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );\n}", c = "varying vec2 vUv;\nvarying vec3 vNormal;\nuniform vec2 resolution;\nuniform float time;\nuniform vec3 color;\nuniform float zoom;\nuniform sampler2D texture;\nfloat rand(vec2 co){\nreturn fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);\n}\nvoid main() {\nvec2 uv = vUv;\nvec3 bc = texture2D(texture, uv).rgb;\nvec2 center = vec2(0.5, 0.5);\nfloat dx = (center.x - uv.x);\nfloat dy = (center.y - uv.y)*resolution.y/resolution.x;\nfloat dist = sqrt(dx*dx + dy*dy);\nfloat angle = atan(dy,dx);\nvec3 c = bc;//vec3(1.37,1.5,0.5);\nfloat target = 0.1*zoom;\ntarget +=(  sin((cos(angle*4.0+time*0.1)*1.7+time*0.3))*(0.21+sin(time*2.3+angle)*0.13))*zoom*0.3+(abs(sin(time*0.15))*0.1+0.9)*zoom*0.3;\nfloat mp = step(dist,target);\nc*=mp;\nuv.y*=resolution.y;\nuv.y = -1.0+2.0*uv.y;\nuv.y-=0.3;\ndist = abs(target-dist);\nfloat distmp = abs(0.5/(95.0*dist));\ndistmp = pow(distmp,1.5) * (step(0.05,distmp));\nc.b += 2.8*distmp;// *abs((target-dist)* sin(uv.y*time*2.1));\nc.g += 0.4*distmp;//abs(0.5/(95.0*(dist)));\nc.r += 0.5*distmp;// abs(0.5/(95.0*(dist)));\nuv.xy+=time;\nif(zoom>2.0)\n{c = texture2D(texture, vUv).rgb;}\nc.b+=(distmp+0.3*mp)*rand(uv)*max(0.0, 1.0-zoom);\ngl_FragColor = vec4(c, mp+c.rgb/3.0);\n}";
})();
demo.parts.TunnelPart = {};
(function() {
  var d = (demo.parts.TunnelPart = function() {
  }).prototype = new kvg.core.Part;
  d.init = function() {
    kvg.core.Part.prototype.init.call(this);
    this.initStandardScene();
    this.initStandardComposer(!1, !1, !0);
    this.camera.position.set(-.4, -1.5, 0);
    this.camera.lookAt(new THREE.Vector3(0, 0, 0));
    this.renderContinuous = !0;
    var c = new THREE.Texture(kvg.core.assets.get("normal.png"));
    c.needsUpdate = !0;
    this.transgeom = new THREE.PlaneGeometry(8, 4.5, 1, 1);
    this.transShader = new demo.transition.TransitionShader;
    this.transmat = new THREE.ShaderMaterial({fragmentShader:this.transShader.fragment, vertexShader:this.transShader.vertex, uniforms:this.transShader.uniforms, side:THREE.DoubleSide, transparent:!0});
    this.transmat.uniforms.zoom.value = 0;
    this.transmat.uniforms.texture.value = c;
    this.transPlane = new THREE.Mesh(this.transgeom, this.transmat);
    this.transPlane.position.z = 0;
    this.transPlane.position.x = 0;
    this.transPlane.position.y = 0;
    this.transPlane.rotation.y = 0;
    this.transPlane.rotation.z = 0;
    this.transPlane.rotation.x = 0;
    this.endts = (new kvg.core.TimeSig(40, 0, 0)).toMilliseconds();
    this.deltats = (new kvg.core.TimeSig(2, 0, 0)).toMilliseconds();
    this.addTrigger(new kvg.core.TimeSig(38, 0, 0, kvg.core.TimeSig.ABSOLUTE), this.beginPortal);
    this.addTrigger(new kvg.core.TimeSig(39, 0, 0, kvg.core.TimeSig.ABSOLUTE), this.beginPortalFinal);
    this.transPlane.visible = !1;
    this.scene.add(this.transPlane);
    (new THREE.IcosahedronGeometry(30, 4)).computeTangents();
    var a = new THREE.Texture(kvg.core.assets.get("space.jpg"));
    a.needsUpdate = !0;
    c = new THREE.Texture(kvg.core.assets.get("testnormal"));
    c.needsUpdate = !0;
    c = new THREE.ShaderMaterial({uniforms:{tNormal:{type:"t", value:c}, tMatCap:{type:"t", value:a}, shred:{type:"f", value:2}, time:{type:"f", value:0}, bump:{type:"f", value:1}, noise:{type:"f", value:.04}, repeat:{type:"v2", value:new THREE.Vector2(1, 1)}, useNormal:{type:"f", value:1}, useRim:{type:"f", value:0}, rimPower:{type:"f", value:1}, useScreen:{type:"f", value:1}, normalScale:{type:"f", value:1}, normalRepeat:{type:"f", value:1}}, vertexShader:demo.parts.GreetPart.GreetShader.vertex, 
    fragmentShader:demo.parts.GreetPart.GreetShader.fragment, shading:THREE.FlatShading, side:THREE.DoubleSide, wrapping:THREE.ClampToEdgeWrapping});
    (new THREE.OfflineJSONLoader).load(kvg.core.assets.get("box"), function(a, c) {
      c[1] = new THREE.MeshPhongMaterial({side:THREE.DoubleSide, color:16742400});
      c[0] = new THREE.MeshPhongMaterial({color:"blue"});
      box = new THREE.Mesh(a, new THREE.MeshFaceMaterial(c));
    });
    this.box = box;
    this.scene.add(new THREE.AmbientLight);
    this.material = c;
    c.uniforms.tNormal.value.wrapS = c.uniforms.tNormal.value.wrapT = THREE.RepeatWrapping;
    c.uniforms.tMatCap.value.wrapS = c.uniforms.tMatCap.value.wrapT = THREE.ClampToEdgeWrapping;
    this.intializeGreets(c);
    this.addTrigger(new kvg.core.TimeSig(0, 0, 0, kvg.core.TimeSig.BEATSPATTERN), this.everyBar);
    this.addTrigger(new kvg.core.TimeSig(12, 0, 0, kvg.core.TimeSig.RELATIVE), this.goToBox);
  };
  d.postInit = function() {
    this.transmat.uniforms.texture.value = kvg.core.demo.parts.BallTest.renderTo;
  };
  d.intializeGreets = function(c) {
    this.greets = [];
    var a = new THREE.IcosahedronGeometry(30, 4);
    a.computeTangents();
    this.createGreet(a, c);
  };
  d.createGreet = function(c, a) {
    var b = new THREE.Mesh(c, a);
    this.mesh = b;
    this.greets.push(b);
    this.scene.add(b);
  };
  d.update = function(c, a, b) {
    var d = c.toMilliseconds() - this.begin.toMilliseconds();
    kvg.core.Part.prototype.update.call(this, c);
    this.material.uniforms.time.value = 2.5E-4 * d;
    this.camera.position.z += .04 * b;
    this.box.rotation.x = 2 * Math.PI * a;
    this.box.rotation.y = 2 * Math.PI * a;
    this.box.rotation.z = 2 * Math.PI * a;
    this.box.position.x = 4 * Math.sin(c.toMilliseconds() / 1300);
    this.box.position.z = 5 * Math.cos(c.toMilliseconds() / 900);
    this.camera.position.x = 2 + 2 * Math.cos(c.toMilliseconds() / 1200 + .25);
    this.camera.position.z = 2 + 2 * Math.sin(c.toMilliseconds() / 1200 + .25);
    this.camera.position.y = 2 + 2 * Math.sin(c.toMilliseconds() / 1200 + .25);
    38 < c.bar ? (a = Math.max((this.endts - (c.toMilliseconds() + 200)) / this.deltats, 0), this.camera.position.x *= a, this.camera.position.z *= a, this.camera.position.y *= a, this.camera.position.z += 2 * Math.min(1, 1 - (this.endts - (200 + c.toMilliseconds())) / this.deltats), this.camera.lookAt(this.box.position.multiplyScalar(1.9 * a))) : this.camera.lookAt(this.box.position.multiplyScalar(1.9));
  };
  d.goToBox = function() {
    console.log("going to end");
    this.goingToEnd = !0;
    this.lerpValue = 0;
  };
  d.beginPortal = function() {
    this.renderToScreen && (console.log("BEGIN portal"), this.scale = 2, createjs.Tween.get(this.transmat.uniforms.zoom).to({value:1}, (new kvg.core.TimeSig(2, 0, 0)).toMilliseconds(), createjs.Ease.quadOut), this.transPlane.visible = !0);
  };
  d.beginPortalFinal = function() {
    this.renderToScreen && (console.log("begin portal final"), createjs.Tween.removeTweens(this.transmat.uniforms.zoom), createjs.Tween.get(this.transmat.uniforms.zoom).to({value:3}, (new kvg.core.TimeSig(1, 0, 0)).toMilliseconds(), createjs.Ease.quadOut));
  };
  d.render = function() {
    var c = kvg.core.graphics.renderer;
    c.autoClear = this.autoClear;
    c.setClearColor("#000", 1);
    this.composer.render();
  };
  d.everyBar = function() {
  };
})();
demo.parts.AsteroidPart = {};
(function() {
  function d(a) {
    for (var b = new THREE.Object3D, c = new THREE.MeshPhongMaterial({color:7563359, shininess:5, transparent:!0}), d = 0;600 > d;++d) {
      var e = new THREE.IcosahedronGeometry(kvg.util.random.nextFloat() + .12), e = new THREE.Mesh(e, c);
      e.position.set(150 - kvg.util.random.getRange(0, 300), 80 - kvg.util.random.getRange(0, 140), 150 - kvg.util.random.getRange(0, 300));
      e.speed = kvg.util.random.nextFloat() / 5;
      e.rotationspeed = new THREE.Vector3(kvg.util.random.nextFloat() / 30, kvg.util.random.nextFloat() / 30, kvg.util.random.nextFloat() / 30);
      b.add(e);
    }
    b.material = c;
    b.updateMatrixWorld();
    b.position.set(0, 0, 0);
    a.add(b);
    return b;
  }
  var c = (demo.parts.AsteroidPart = function() {
  }).prototype = new kvg.core.Part;
  c.init = function() {
    kvg.core.Part.prototype.init.call(this);
    this.initStandardScene();
    this.initStandardComposer(!1, !1, !0);
    this.camera.position.set(0, 0, 0);
    this.knotScale = .8;
    this.asteroid = new THREE.Object3D;
    this.asteroid.position.set(-12, 16, 0);
    this.scene.add(this.asteroid);
    this.loadStation();
    this.phase = 0;
    this.lookAt = new THREE.Vector3(10, 3, 0);
    skytexture = new THREE.Texture(kvg.core.assets.get("nightsky.png"));
    skytexture.needsUpdate = !0;
    var a = new THREE.MeshBasicMaterial({map:skytexture, side:THREE.DoubleSide});
    this.outerCube = new THREE.Mesh(new THREE.BoxGeometry(400, 400, 400), a);
    this.scene.add(this.outerCube);
    a = new THREE.Curves.DecoratedTorusKnot4a;
    a = new THREE.TubeGeometry(a, 150, 3, 3, !0);
    this.looptime = 7E4;
    (new THREE.Mesh(a, new THREE.MeshLambertMaterial({color:"red"}))).scale.set(this.knotScale, this.knotScale, this.knotScale);
    this.tube = a;
    var a = new THREE.Object3D, b = new THREE.PointLight(1890047, 1, 25);
    a.add(b);
    this.asteroid.add(a);
    this.flare1 = a;
    a = new THREE.Object3D;
    b = new THREE.PointLight(1955583, 1, 25);
    a.add(b);
    this.asteroid.add(a);
    this.flare2 = a;
    a = new THREE.Object3D;
    b = new THREE.PointLight(1955583, 1, 25);
    a.add(b);
    this.asteroid.add(a);
    this.flare3 = a;
    a = new THREE.Object3D;
    b = new THREE.PointLight(1955583, 1, 25);
    a.add(b);
    this.asteroid.add(a);
    this.flare4 = a;
    a = new THREE.Object3D;
    b = new THREE.PointLight(1955583, 1, 25);
    a.add(b);
    this.asteroid.add(a);
    this.flare5 = a;
    a = new THREE.Object3D;
    b = new THREE.PointLight(1955583, 1, 25);
    a.add(b);
    this.asteroid.add(a);
    this.flare6 = a;
    a = new THREE.Object3D;
    b = new THREE.PointLight(1955583, 1, 25);
    a.add(b);
    this.asteroid.add(a);
    this.flare7 = a;
    this.initParticles(this.flare1);
    this.initParticles(this.flare2);
    this.initParticles(this.flare3);
    this.initParticles(this.flare4);
    this.initParticles(this.flare5);
    this.initParticles(this.flare6);
    this.initParticles(this.flare7);
    this.useCameraControl = !1;
    this.cameraControl = new kvg.demo.CameraController;
    this.cameraControl.attachCamera(this.camera);
    this.cameraControl.initialize([new THREE.Vector3(0, 0, 0), new THREE.Vector3(-9, -5, 0), new THREE.Vector3(-14, 4, 0), new THREE.Vector3(-27, 8, 0), new THREE.Vector3(-32, 17, 0), new THREE.Vector3(-24, 28, 0), new THREE.Vector3(-14, 28, -10), new THREE.Vector3(-3, 35, -7), new THREE.Vector3(5, 31, -3), new THREE.Vector3(14, 32, -1), new THREE.Vector3(24, 43, -1), new THREE.Vector3(44, 34, -1), new THREE.Vector3(54, 30, 0), new THREE.Vector3(64, 28, 0)], [new THREE.Vector3(10, 3, 0), new THREE.Vector3(0, 
    0, 0), new THREE.Vector3(-5, 9, 0), new THREE.Vector3(-18, 13, 0), new THREE.Vector3(-22, 19, 0), new THREE.Vector3(-14, 28, 0), new THREE.Vector3(-5, 27, -7), new THREE.Vector3(3, 29, -2), new THREE.Vector3(14, 27, 0), new THREE.Vector3(24, 27, -1), new THREE.Vector3(34, 26, -1), new THREE.Vector3(54, 27, 0), new THREE.Vector3(64, 28, 0), new THREE.Vector3(74, 28, 0)], kvg.demo.CameraController.BEZIER);
    this.rotations = [{rotation:new THREE.Vector3(0, 2, 0), startAt:new kvg.core.TimeSig(19, 2, 0), flare:0, endAt:new kvg.core.TimeSig(19, 3, 5)}];
    this.lookuptime = new kvg.core.TimeSig(3, 0, 0);
    this.addTrigger(new kvg.core.TimeSig(19, 2, 0, kvg.core.TimeSig.RELATIVE), this.triggerFlare0Rotation);
    this.addTrigger(new kvg.core.TimeSig(0, 0, 0, kvg.core.TimeSig.RELATIVE), this.lookUp);
    this.addTrigger(new kvg.core.TimeSig(3, 0, 0, kvg.core.TimeSig.RELATIVE), this.disableCameraLookAt);
    this.addTrigger(new kvg.core.TimeSig(15, 0, 0, kvg.core.TimeSig.RELATIVE), this.beginPortal);
    this.addTrigger(new kvg.core.TimeSig(19, 0, 0, kvg.core.TimeSig.RELATIVE), this.beginPortalFinal);
    this.addTrigger(new kvg.core.TimeSig(0, 0, 0, kvg.core.TimeSig.BEATSPATTERN), this.everyBar);
  };
  c.initParticles = function(a) {
    this.clock = new THREE.Clock;
    var b = new THREE.Texture(kvg.core.assets.get("particle_test.png"));
    b.needsUpdate = !0;
    b = new SPE.Group({texture:b, maxAge:.4});
    emitter = new SPE.Emitter({type:"sphere", position:new THREE.Vector3(0, 0, 0), radius:.01, radiusScale:new THREE.Vector3(1, 1, 1), speed:1.5, colorStart:new THREE.Color(1052927), colorEnd:new THREE.Color(11447961), sizeStart:2, sizeSpread:2, sizeEnd:4, opacityStart:.5, opacityEnd:0, particleCount:500});
    b.addEmitter(emitter);
    a.particles = b;
    this.particleMesh = b.mesh;
    this.asteroid.add(b.mesh);
  };
  c.loadStation = function() {
    var a = null;
    (new THREE.OfflineJSONLoader).load(kvg.core.assets.get("asteroidStation"), function(b, c) {
      c[0] = new THREE.MeshPhongMaterial({color:7563359, shininess:5});
      a = new THREE.Mesh(b, new THREE.MeshFaceMaterial(c));
      a.scale.set(15, 15, 15);
    });
    var b = new THREE.Texture(kvg.core.assets.get("normal.png"));
    b.needsUpdate = !0;
    this.transgeom = new THREE.PlaneGeometry(128 / 1.3, 72 / 1.3, 1, 1);
    this.transShader = new demo.transition.TransitionShader;
    this.transmat = new THREE.ShaderMaterial({fragmentShader:this.transShader.fragment, vertexShader:this.transShader.vertex, uniforms:this.transShader.uniforms, side:THREE.DoubleSide, transparent:!0});
    this.transmat.uniforms.zoom.value = 0;
    this.transmat.uniforms.texture.value = b;
    this.transPlane = new THREE.Mesh(this.transgeom, this.transmat);
    this.transPlane.position.z = 0;
    this.transPlane.position.x = 104;
    this.transPlane.position.y = 28;
    this.transPlane.rotation.y = Math.PI / 2 + Math.PI;
    this.transPlane.rotation.z = 0;
    this.transPlane.rotation.x = 0;
    this.transmat.opacity = 0;
    this.transPlane.visible = !1;
    this.scene.add(this.transPlane);
    this.asteroid.add(a);
    this.lights = new THREE.Object3D;
    b = new THREE.PointLight(1709695, .5, 100);
    b.position.set(30, 30, 30);
    this.lights.add(b);
    b = new THREE.PointLight(329087, .5, 100);
    b.position.set(-30, -30, 30);
    this.lights.add(b);
    b = new THREE.PointLight(263372, .5, 100);
    b.position.set(30, 30, -30);
    this.lights.add(b);
    this.asteroid.add(this.lights);
    this.bgasteroids = d(this.scene);
    this.bgasteroids.material.opacity = 0;
  };
  c.postInit = function() {
    this.transmat.uniforms.texture.value = kvg.core.demo.parts.TunnelPart.renderTo;
  };
  c.lookUp = function() {
    createjs.Tween.get(this.bgasteroids.material).to({opacity:1}, (new kvg.core.TimeSig(4, 0, 0)).toMilliseconds(), createjs.Ease.linear);
  };
  c.disableCameraLookAt = function() {
    this.useCameraControl = !0;
  };
  c.update = function(a, b, c) {
    this.layerEffect.standard && (24 > a.bar ? this.layerEffect.standard.uniforms.offset.value = .1 * Math.max(0, (this.lastPost + 200 - a.toMilliseconds()) / 200) : this.layerEffect.standard.uniforms.offset = 0);
    var d = a.toMilliseconds() - this.begin.toMilliseconds();
    this.transmat.uniforms.time.value = .001 * d;
    kvg.core.Part.prototype.update.call(this, a);
    this.cameraControl.update(b);
    this.asteroid.rotateX(.07 * c);
    this.asteroid.rotateY(.08 * c);
    this.asteroid.rotateZ(.05 * c);
    this.lights.rotateZ(.1 * c);
    this.lights.rotateY(.1 * c);
    this.lights.rotateX(.1 * c);
    this.asteroid.position.x = 60 * b - 12;
    this.bgasteroids.rotateY(.004 * c);
    for (a = 0;a < this.bgasteroids.children.length;++a) {
      b = this.bgasteroids.children[a], b.position.x += b.speed, b.rotateX(b.rotationspeed.x), b.rotateY(b.rotationspeed.y), b.rotateZ(b.rotationspeed.z);
    }
    b = d % this.looptime / this.looptime;
    a = this.tube.parameters.path.getPointAt(b).multiplyScalar(this.knotScale);
    b = this.tube.parameters.path.getTangentAt(b);
    this.flare1.position.set(a.x, a.y, a.z);
    this.flare1.rotation.set(b.x, b.y, b.z);
    this.flare1.particles.emitters[0].position.set(a.x, a.y, a.z);
    b = 1 - (d + 5E3) % this.looptime / this.looptime;
    a = this.tube.parameters.path.getPointAt(b).multiplyScalar(this.knotScale);
    b = this.tube.parameters.path.getTangentAt(b);
    this.flare2.position.set(a.x, a.y, a.z);
    this.flare2.rotation.set(b.x, b.y, b.z);
    this.flare2.particles.emitters[0].position.set(a.x, a.y, a.z);
    b = 1 - (d + 9E3) % this.looptime / this.looptime;
    a = this.tube.parameters.path.getPointAt(b).multiplyScalar(this.knotScale);
    b = this.tube.parameters.path.getTangentAt(b);
    this.flare3.position.set(a.x, a.y, a.z);
    this.flare3.rotation.set(b.x, b.y, b.z);
    this.flare3.particles.emitters[0].position.set(a.x, a.y, a.z);
    b = (d + 12E3) % this.looptime / this.looptime;
    a = this.tube.parameters.path.getPointAt(b).multiplyScalar(this.knotScale);
    b = this.tube.parameters.path.getTangentAt(b);
    this.flare4.position.set(a.x, a.y, a.z);
    this.flare4.rotation.set(b.x, b.y, b.z);
    this.flare4.particles.emitters[0].position.set(a.x, a.y, a.z);
    b = 1 - (d + 17E3) % this.looptime / this.looptime;
    a = this.tube.parameters.path.getPointAt(b).multiplyScalar(this.knotScale);
    b = this.tube.parameters.path.getTangentAt(b);
    this.flare5.position.set(a.x, a.y, a.z);
    this.flare5.rotation.set(b.x, b.y, b.z);
    this.flare5.particles.emitters[0].position.set(a.x, a.y, a.z);
    b = (d + 17E3) % this.looptime / this.looptime;
    a = this.tube.parameters.path.getPointAt(b).multiplyScalar(this.knotScale);
    b = this.tube.parameters.path.getTangentAt(b);
    this.flare6.position.set(a.x, a.y, a.z);
    this.flare6.rotation.set(b.x, b.y, b.z);
    this.flare6.particles.emitters[0].position.set(a.x, a.y, a.z);
    b = (d + 3E4) % this.looptime / this.looptime;
    a = this.tube.parameters.path.getPointAt(b).multiplyScalar(this.knotScale);
    b = this.tube.parameters.path.getTangentAt(b);
    this.flare6.position.set(a.x, a.y, a.z);
    this.flare6.rotation.set(b.x, b.y, b.z);
    this.flare6.particles.emitters[0].position.set(a.x, a.y, a.z);
    d = this.clock.getDelta();
    this.flare1.particles.tick(d);
    this.flare2.particles.tick(d);
    this.flare3.particles.tick(d);
    this.flare4.particles.tick(d);
    this.flare5.particles.tick(d);
    this.flare6.particles.tick(d);
  };
  c.beginPortal = function() {
    this.renderToScreen && (this.shredblock = !0, console.log("BEGIN portal"), this.scale = 2, createjs.Tween.get(this.transmat.uniforms.zoom).to({value:1}, (new kvg.core.TimeSig(0, 2, 0)).toMilliseconds(), createjs.Ease.quadOut), this.transPlane.visible = !0);
  };
  c.beginPortalFinal = function() {
    this.renderToScreen && (console.log("begin portal final"), createjs.Tween.removeTweens(this.transmat.uniforms.zoom), createjs.Tween.get(this.transmat.uniforms.zoom).to({value:4}, (new kvg.core.TimeSig(1, 0, 0)).toMilliseconds(), createjs.Ease.quadOut));
  };
  c.render = function() {
    var a = kvg.core.graphics.renderer;
    a.autoClear = this.autoClear;
    a.setClearColor("#000", 1);
    this.composer.render();
  };
  c.everyBar = function() {
  };
})();
demo.parts.OpeningPart = {};
(function() {
  var d = (demo.parts.OpeningPart = function() {
  }).prototype = new kvg.core.Part;
  d.init = function() {
    kvg.core.Part.prototype.init.call(this);
    this.initStandardScene();
    this.initStandardComposer(!1, !1, !0);
    this.camera.position.set(0, 0, 0);
    this.camera.lookAt(new THREE.Vector3(10, 0, 0));
    skytexture = new THREE.Texture(kvg.core.assets.get("nightsky.png"));
    skytexture.needsUpdate = !0;
    var c = new THREE.MeshBasicMaterial({map:skytexture, side:THREE.DoubleSide});
    this.outerCube = new THREE.Mesh(new THREE.BoxGeometry(400, 400, 400), c);
    this.outerCube.material.transparent = !0;
    this.outerCube.material.opacity = 0;
    this.scene.add(this.outerCube);
    var a = null;
    (new THREE.OfflineJSONLoader).load(kvg.core.assets.get("tachyondrift"), function(b, c) {
      c[0] = new THREE.ShaderMaterial({uniforms:{displacement:{type:"f", value:0}}, vertexShader:demo.parts.OpeningPart.OpeningShader.vertex, fragmentShader:demo.parts.OpeningPart.OpeningShader.fragment});
      c[0] = new THREE.MeshPhongMaterial({color:8353395});
      a = new THREE.Mesh(b, new THREE.MeshFaceMaterial(c));
    });
    a.material.materials[0].transparent = !0;
    a.material.materials[0].opacity = 0;
    a.position.set(15, 0, 0);
    this.mesh = a;
    this.scene.add(a);
    this._phase = 0;
    this.lookAt = new THREE.Vector3(10, 0, 0);
    this.gate = (new kvg.core.TimeSig(0, 2, 0)).toMilliseconds();
    c = new THREE.PointLight(1709695, 1, 100);
    c.position.set(-30, 0, 0);
    this.scene.add(c);
    this.addTrigger(new kvg.core.TimeSig(0, 2, 0, kvg.core.TimeSig.RELATIVE), this.begin);
    this.addTrigger(new kvg.core.TimeSig(5, 2, 0, kvg.core.TimeSig.RELATIVE), this.phasedone);
    this.addTrigger(new kvg.core.TimeSig(0, 0, 0, kvg.core.TimeSig.BEATSPATTERN), this.everyBar);
  };
  d.update = function(c) {
    kvg.core.Part.prototype.update.call(this, c);
    c.toMilliseconds();
    this.begin.toMilliseconds();
    this.camera.lookAt(this.lookAt);
  };
  d.begin = function() {
    createjs.Tween.get(this.mesh.position).to({x:8}, (new kvg.core.TimeSig(5, 0, 0)).toMilliseconds(), createjs.Ease.quadOut);
    createjs.Tween.get(this.mesh.material.materials[0]).to({opacity:1}, (new kvg.core.TimeSig(3, 0, 0)).toMilliseconds(), createjs.Ease.cubicInOut).call(createjs.proxy(this.showbackground, this));
  };
  d.showbackground = function() {
    createjs.Tween.get(this.outerCube.material).to({opacity:1}, (new kvg.core.TimeSig(4, 0, 0)).toMilliseconds(), createjs.Ease.linear);
  };
  d.phasedone = function() {
    createjs.Tween.get(this.mesh.material.materials[0]).to({opacity:0}, (new kvg.core.TimeSig(3, 0, 0)).toMilliseconds(), createjs.Ease.cubicInOut);
    createjs.Tween.get(this.lookAt).to({y:3}, (new kvg.core.TimeSig(3, 0, 0)).toMilliseconds(), createjs.Ease.linear);
  };
  d.render = function() {
    var c = kvg.core.graphics.renderer;
    c.autoClear = this.autoClear;
    c.setClearColor("#000", 1);
    this.composer.render();
  };
  d.everyBar = function() {
  };
})();
demo.effects = {};
demo.effects.BGEffect = {};
(function() {
  var d = (demo.effects.BGEffect = function() {
  }).prototype = new kvg.core.Part;
  d.init = function() {
    this.abc = Date.now();
    this.trigger = new Map;
    this.container = new THREE.Object3D;
    this.normalScale = new THREE.Vector3(1, 1, 1);
    var c = new THREE.IcosahedronGeometry(30, 4);
    c.computeTangents();
    var a = new THREE.MeshBasicMaterial({color:"red"}), a = new THREE.Texture(kvg.core.assets.get("space.jpg"));
    a.needsUpdate = !0;
    var b = new THREE.Texture(kvg.core.assets.get("testnormal"));
    b.needsUpdate = !0;
    a = new THREE.ShaderMaterial({uniforms:{tNormal:{type:"t", value:b}, tMatCap:{type:"t", value:a}, shred:{type:"f", value:1}, time:{type:"f", value:0}, bump:{type:"f", value:1}, noise:{type:"f", value:.04}, repeat:{type:"v2", value:new THREE.Vector2(1, 1)}, useNormal:{type:"f", value:1}, useRim:{type:"f", value:0}, rimPower:{type:"f", value:1}, useScreen:{type:"f", value:1}, normalScale:{type:"f", value:1}, normalRepeat:{type:"f", value:1}, lightness:{type:"f", value:0}}, vertexShader:demo.parts.WaterPartShaders.SphereShader.vertex, 
    fragmentShader:demo.parts.WaterPartShaders.SphereShader.fragment, shading:THREE.FlatShading, side:THREE.DoubleSide, wrapping:THREE.ClampToEdgeWrapping});
    this.uniforms = a.uniforms;
    a.uniforms.tNormal.value.wrapS = a.uniforms.tNormal.value.wrapT = THREE.RepeatWrapping;
    a.uniforms.tMatCap.value.wrapS = a.uniforms.tMatCap.value.wrapT = THREE.ClampToEdgeWrapping;
    this.mesh = c = new THREE.Mesh(c, a);
    this.container.add(c);
    this.addTrigger(new kvg.core.TimeSig(0, 0, 0, kvg.core.TimeSig.BEATSPATTERN), this.everyBar);
  };
  d.update = function(c) {
    this.uniforms.time.value = 2.5E-4 * c.toMilliseconds();
    1 <= this.uniforms.shred.value && (this.uniforms.shred.value -= .2);
    this.mesh.rotateX(.01);
    this.mesh.rotateY(.005);
  };
  d.render = function() {
    var c = kvg.core.graphics.renderer;
    c.autoClear = this.autoClear;
    c.setClearColor("#000", 1);
    this.composer.render();
  };
  d.everyBar = function() {
    this.uniforms.shred.value = 3;
  };
})();
demo.parts.WaterPart = {};
(function() {
  var d = (demo.parts.WaterPart = function() {
  }).prototype = new kvg.core.Part;
  d.init = function() {
    this.abc = Date.now();
    kvg.core.Part.prototype.init.call(this);
    this.initStandardScene();
    this.initStandardComposer(!1, !1, !0);
    this.camera.position.set(0, 0, 90);
    this.normalScale = new THREE.Vector3(1, 1, 1);
    this.renderContinuous = !1;
    this.cameraControl = new kvg.demo.CameraController;
    this.cameraControl.attachCamera(this.camera);
    this.cameraControl.initialize([new THREE.Vector3(0, 0, 90), new THREE.Vector3(-5, 0, 58), new THREE.Vector3(-12, 0, 40), new THREE.Vector3(-19, 10, 35), new THREE.Vector3(-6, 19, 38), new THREE.Vector3(-5, 15, 47), new THREE.Vector3(-4, 10, 44), new THREE.Vector3(0, 0, 36.15), new THREE.Vector3(0, 0, 36.15)], [new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, 
    0, 0), new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, 0, 0)], kvg.demo.CameraController.BEZIER);
    this.beginCamera = new THREE.Vector3(50, 50, 50);
    this.endCamera = new THREE.Vector3(50, 50, 50);
    var c = new THREE.IcosahedronGeometry(30, 4);
    c.computeTangents();
    var a = new THREE.MeshBasicMaterial({color:"red"}), a = new THREE.Texture(kvg.core.assets.get("space.jpg"));
    a.needsUpdate = !0;
    var b = new THREE.Texture(kvg.core.assets.get("normal.png"));
    b.needsUpdate = !0;
    this.transgeom = new THREE.PlaneGeometry(16, 9, 1, 1);
    this.transShader = new demo.transition.TransitionShader;
    this.transmat = new THREE.ShaderMaterial({fragmentShader:this.transShader.fragment, vertexShader:this.transShader.vertex, uniforms:this.transShader.uniforms, side:THREE.DoubleSide, transparent:!0});
    this.transmat.uniforms.zoom.value = 0;
    this.transmat.uniforms.texture.value = b;
    this.transPlane = new THREE.Mesh(this.transgeom, this.transmat);
    this.transPlane.position.z = 30;
    this.transPlane.position.x = 0;
    this.transPlane.position.y = 0;
    this.transPlane.rotation.y = 0;
    this.transPlane.visible = !1;
    this.scene.add(this.transPlane);
    b = new THREE.Texture(kvg.core.assets.get("testnormal"));
    b.needsUpdate = !0;
    a = new THREE.ShaderMaterial({uniforms:{tNormal:{type:"t", value:b}, tMatCap:{type:"t", value:a}, shred:{type:"f", value:1}, time:{type:"f", value:0}, bump:{type:"f", value:1}, noise:{type:"f", value:.04}, repeat:{type:"v2", value:new THREE.Vector2(1, 1)}, useNormal:{type:"f", value:1}, useRim:{type:"f", value:0}, rimPower:{type:"f", value:1}, useScreen:{type:"f", value:1}, normalScale:{type:"f", value:1}, normalRepeat:{type:"f", value:1}, lightness:{type:"f", value:1}}, vertexShader:demo.parts.WaterPartShaders.SphereShader.vertex, 
    fragmentShader:demo.parts.WaterPartShaders.SphereShader.fragment, shading:THREE.FlatShading, side:THREE.DoubleSide, wrapping:THREE.ClampToEdgeWrapping});
    this.uniforms = a.uniforms;
    a.uniforms.tNormal.value.wrapS = a.uniforms.tNormal.value.wrapT = THREE.RepeatWrapping;
    a.uniforms.tMatCap.value.wrapS = a.uniforms.tMatCap.value.wrapT = THREE.ClampToEdgeWrapping;
    this.mesh = c = new THREE.Mesh(c, a);
    this.scene.add(c);
    this.camera.lookAt(c.position);
    this.addTrigger(new kvg.core.TimeSig(-1, 2, 0, kvg.core.TimeSig.BEATSPATTERN), this.everyBar);
    this.addTrigger(new kvg.core.TimeSig(3, 2, 0, kvg.core.TimeSig.RELATIVE), this.beginPortal);
    this.addTrigger(new kvg.core.TimeSig(5, 0, 0, kvg.core.TimeSig.RELATIVE), this.beginPortalFinal);
  };
  d.postInit = function() {
    this.transmat.uniforms.texture.value = kvg.core.demo.parts.Greet2Part.renderTo;
  };
  d.update = function(c, a) {
    this.renderToScreen && (console.log("WaterPart partial " + a), this.cameraControl.update(a));
    kvg.core.Part.prototype.update.call(this, c);
    this.uniforms.time.value = 2.5E-4 * c.toMilliseconds();
    1 <= this.uniforms.shred.value && (this.uniforms.shred.value -= .2);
    this.mesh.rotateX(.01);
    this.mesh.rotateY(.005);
  };
  d.render = function() {
    var c = kvg.core.graphics.renderer;
    c.autoClear = this.autoClear;
    c.setClearColor("#000", 1);
    this.composer.render();
  };
  d.beginPortal = function() {
    this.renderToScreen && (this.shredblock = !0, console.log("BEGIN portal"), this.scale = 2, createjs.Tween.get(this.transmat.uniforms.zoom).to({value:1}, (new kvg.core.TimeSig(0, 2, 0)).toMilliseconds(), createjs.Ease.quadOut), createjs.Tween.get(this.mesh.scale).to({x:.5, y:.5, z:.5}, (new kvg.core.TimeSig(0, 2, 0)).toMilliseconds(), createjs.Ease.quadOut), this.transPlane.visible = !0);
  };
  d.beginPortalFinal = function() {
    this.renderToScreen && (console.log("begin portal final"), createjs.Tween.removeTweens(this.transmat.uniforms.zoom), createjs.Tween.get(this.transmat.uniforms.zoom).to({value:4}, (new kvg.core.TimeSig(1, 0, 0)).toMilliseconds(), createjs.Ease.quadOut));
  };
  d.everyBar = function() {
    this.shredblock || (this.uniforms.shred.value = 1.5);
  };
})();
demo.parts.balltest = {};
demo.parts.balltest.CustomCubeShader = {};
(function() {
  demo.parts.balltest.CustomCubeShader = {uniforms:{tCube:{type:"t", value:null}, tFlip:{type:"f", value:-1}, rnd:{type:"f", value:0}, brightness:{type:"f", value:0}, lines:{type:"f", value:2}}, vertexShader:["varying vec3 vWorldPosition;\nvarying vec2 vUv;", THREE.ShaderChunk.common, THREE.ShaderChunk.logdepthbuf_pars_vertex, "void main() {\nvUv = uv;\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );", THREE.ShaderChunk.logdepthbuf_vertex, 
  "}"].join("\n"), fragmentShader:["uniform samplerCube tCube;\nuniform float tFlip;\nuniform float rnd;\nuniform float brightness;\nuniform float lines;\nvarying vec2 vUv;\nvarying vec3 vWorldPosition;", THREE.ShaderChunk.common, THREE.ShaderChunk.logdepthbuf_pars_fragment, "float rand(vec2 co){\nreturn fract(sin(dot(co.xy ,vec2(10.9898,10.233))) * 10.5453);\n}\nvoid main() {\nfloat linesize = max(0.006,0.25/lines);\nvec2 uv = vUv;\nuv*=tFlip;\nuv+=linesize/2.0;\nfloat stepx = step(mod(uv.x,1.0/lines), linesize);\nfloat stepy = step(mod(uv.y,1.0/lines), linesize);\nvec3 c = vec3(stepx+stepy);// vec3(1.0, 1.0, 1.0);\nfloat rnd= rand( vec2( floor((uv.x*lines+rnd)), floor((uv.y*lines+rnd)) ));\n//c*=rnd;\n\nc = 0.8- c;\nc.r *= 194.0/255.0;\nc.g *= 155.0/255.0;\nc.b *= 145.0/255.0;\nc.r += (c.r)* step( rnd, 0.15)* brightness*253.0;\nc.b *=1.0-  step( rnd, 0.15)* brightness*1.00;\nc.g *=1.0-  step( rnd, 0.15)* brightness*1.00;\n\tgl_FragColor = vec4(c,1.0);", 
  THREE.ShaderChunk.logdepthbuf_fragment, "}"].join("\n")};
})();
demo.parts.BallTest = {};
(function() {
  var d = (demo.parts.BallTest = function() {
  }).prototype = new kvg.core.Part;
  d.init = function() {
    this.stopval = 0;
    kvg.core.Part.prototype.init.call(this);
    this.initStandardScene();
    this.initStandardComposer(!1, !1, !1);
    this.renderContinuous = !0;
    this.cameraControl = new kvg.demo.CameraController;
    this.cameraControl.attachCamera(this.camera);
    this.beginCamera = new THREE.Vector3(1, 5, -92);
    this.endCamera = new THREE.Vector3(-63, -5, -37);
    this.cameraControl.initialize([new THREE.Vector3(1, 5, -92), new THREE.Vector3(2, 5, -72), new THREE.Vector3(32, 15, -62), new THREE.Vector3(19, 33, -52), new THREE.Vector3(-11, 42, -52), new THREE.Vector3(-30, 21, -53), new THREE.Vector3(-27, -9, -53), new THREE.Vector3(-19, -44, -38), new THREE.Vector3(-38, -66, -7), new THREE.Vector3(-43, -42, -43), new THREE.Vector3(-0, -0, -100), new THREE.Vector3(-0, -0, -130)], [new THREE.Vector3(2, 5, -82), new THREE.Vector3(2, 5, -62), new THREE.Vector3(32, 
    15, -52), new THREE.Vector3(16, 31, -43), new THREE.Vector3(-8, 37, -44), new THREE.Vector3(-27, 20, -43), new THREE.Vector3(-24, -6, -44), new THREE.Vector3(-16, -38, -32), new THREE.Vector3(-35, -58, -1), new THREE.Vector3(-39, -39, -34), new THREE.Vector3(-0, -0, -34), new THREE.Vector3(-0, -0, -34)], kvg.demo.CameraController.BEZIER);
    var c = [kvg.core.assets.get("ballbg.png"), kvg.core.assets.get("ballbg.png"), kvg.core.assets.get("ballbg.png"), kvg.core.assets.get("ballbg.png"), kvg.core.assets.get("ballbg.png"), kvg.core.assets.get("ballbg.png")], c = new THREE.CubeTexture(c);
    c.needsUpdate = !0;
    c.flipY = !1;
    c.format = THREE.RGBFormat;
    var a = this.cubeshader = demo.parts.balltest.CustomCubeShader;
    a.uniforms.tCube.value = c;
    a.uniforms.lines.value = 3;
    c = new THREE.ShaderMaterial({fragmentShader:a.fragmentShader, vertexShader:a.vertexShader, uniforms:a.uniforms, depthWrite:!1, side:THREE.BackSide, color:0, lights:!1});
    a = new THREE.Texture(kvg.core.assets.get("normal.png"));
    a.needsUpdate = !0;
    this.transgeom = new THREE.PlaneGeometry(512, 288, 1, 1);
    this.transShader = new demo.transition.TransitionShader;
    this.transmat = new THREE.ShaderMaterial({fragmentShader:this.transShader.fragment, vertexShader:this.transShader.vertex, uniforms:this.transShader.uniforms, side:THREE.DoubleSide, transparent:!0});
    this.transmat.uniforms.zoom.value = 0;
    this.transmat.uniforms.texture.value = a;
    this.transPlane = new THREE.Mesh(this.transgeom, this.transmat);
    this.transPlane.position.z = 70;
    this.transPlane.rotation.y = Math.PI;
    this.transPlane.visible = !1;
    this.scene.add(this.transPlane);
    this.skybox = c = new THREE.Mesh(new THREE.BoxGeometry(500, 500, 500), c);
    this.camera.position.z = 60;
    this.scene.add(c);
    c = new THREE.SphereGeometry(20, 55, 55);
    this.cubes = [];
    this.ballholder = new THREE.Object3D;
    this.amount = 6;
    this.light1 = new THREE.PointLight(13140223, 2, 300);
    this.light1.position.set(0, 0, 0);
    this.scene.add(this.light1);
    this.light2 = new THREE.PointLight(3489165, 5, 400);
    this.light2.position.set(0, 0, 0);
    this.scene.add(this.light2);
    this.light3 = new THREE.PointLight(16760831, 5, 450);
    this.light3.position.set(0, 0, 0);
    this.scene.add(this.light3);
    var a = new THREE.SphereGeometry(1, 4, 4), b = new THREE.MeshPhongMaterial({emissive:15658734, opacity:.5});
    this.l1sp = new THREE.Mesh(a, b);
    b = new THREE.MeshPhongMaterial({emissive:16748608, opacity:.5});
    this.l2sp = new THREE.Mesh(a, b);
    b = new THREE.MeshPhongMaterial({emissive:37119, opacity:.5});
    this.l3sp = new THREE.Mesh(a, b);
    a = new THREE.AmbientLight(4210752);
    this.scene.add(a);
    for (var a = [0, 3 * Math.PI / 6 * 2, 0, 3 * Math.PI / 6 * 2, 0, 3 * Math.PI / 6 * 2], b = [40, 40, 40, 40, 40, 40], d = [0, 0, 0, 0, 0, 0, 0], f = [13140223, 10506447, 2838694, 16760831, 1397420, 3489165, 13075446], e = 0;e < this.amount;e++) {
      var k = new THREE.CubeCamera(1, 2E3, 512), g = new THREE.MeshPhongMaterial({envMap:k.renderTarget, side:THREE.DoubleSide, color:f[e], emissive:1052688}), g = new THREE.Mesh(c, g);
      g.position.x = 200 * Math.random() - 100;
      g.position.y = 200 * Math.random() - 100;
      g.position.z = 200 * Math.random() - 100;
      g.phase = a[e];
      g.speed = .001;
      g.r = b[e];
      g.po = d[e];
      this.scene.add(k);
      g.cubecam = k;
      this.ballholder.add(g);
      this.cubes.push(g);
    }
    this.scene.add(this.ballholder);
    this.scale = 1;
    this.cameraTime = (new kvg.core.TimeSig(28, 0, 0)).toMilliseconds();
    console.log("CAMERA TIEM  " + this.cameraTime);
    this.addTrigger(new kvg.core.TimeSig(43, 2, 0, kvg.core.TimeSig.ABSOLUTE), this.beginLineFade);
    this.addTrigger(new kvg.core.TimeSig(22, 0, 0, kvg.core.TimeSig.RELATIVE), this.beginBallFade);
    this.addTrigger(new kvg.core.TimeSig(15, 0, 0, kvg.core.TimeSig.RELATIVE), this.beginPortal);
    this.addTrigger(new kvg.core.TimeSig(24, 0, 0, kvg.core.TimeSig.RELATIVE), this.beginPortalFinal);
    this.addTrigger(new kvg.core.TimeSig(-1, 2, 0, kvg.core.TimeSig.PATTERN), this.everySecondBeat);
    this.increase = 0;
  };
  d.postInit = function() {
    this.transmat.uniforms.texture.value = kvg.core.demo.parts.WaterPart.renderTo;
  };
  d.beginLineFade = function() {
    console.log("BEGIN LINE FADE");
    createjs.Tween.get(this.cubeshader.uniforms.lines).to({value:164}, 28E3, createjs.Ease.quadInOut);
  };
  d.update = function(c, a) {
    var b = c.toMilliseconds() - this.begin.toMilliseconds();
    this.cubeshader.uniforms.brightness.value = 0 + Math.min(1, Math.max(0, 1 + b / 480 * 1));
    this.cameraControl.update(a);
    kvg.core.Part.prototype.update.call(this, c);
    for (var d = 0;d < this.amount;d++) {
      var f = this.cubes[d], e = f.phase + b * f.speed;
      0 == d % 3 ? (f.position.x = Math.sin(e + f.po) * f.r, f.position.y = Math.cos(e + f.po) * f.r, f.position.z = 0) : 1 == d % 3 ? (f.position.x = 0, f.position.y = Math.sin(e + f.po) * f.r, f.position.z = Math.cos(e + f.po) * f.r) : (f.position.x = Math.cos(e + f.po) * f.r, f.position.y = 0, f.position.z = Math.sin(e + f.po) * f.r);
      e = 1 - this.stopval;
      f.position.z += 200 * this.stopval;
      0 >= e && (e = .1);
      f.scale.set(e, e, e);
    }
    this.light2.position.x = 80 * Math.sin(5E-4 * b);
    this.light2.position.y = 75 * Math.sin(.001 * b);
    this.light2.position.z = 70 * Math.cos(.001 * b);
    this.l2sp.position.x = this.light2.position.x;
    this.l2sp.position.y = this.light2.position.y;
    this.l2sp.position.z = this.light2.position.z;
    this.light3.position.x = 80 * Math.sin(7E-4 * b + .4);
    this.light3.position.y = 65 * Math.sin(5E-4 * b + 18);
    this.light3.position.z = 70 * Math.cos(2E-4 * b);
    this.l3sp.position.x = this.light3.position.x;
    this.l3sp.position.y = this.light3.position.y;
    this.l3sp.position.z = this.light3.position.z;
    this.transmat.uniforms.time.value = .001 * b;
  };
  d.render = function() {
    var c = kvg.core.graphics.renderer;
    c.autoClear = !0;
    c.setClearColor("#fff", 1);
    if (!this.rut) {
      for (var a = 0;a < this.amount;a++) {
        var b = this.cubes[a];
        b.visible = !1;
        b.cubecam.position.copy(b.position);
        b.cubecam.updateCubeMap(c, this.scene);
        b.material.needsUpdate = !0;
        b.visible = !0;
      }
    }
    c.autoClear = this.autoClear;
    c.setClearColor("#000", 1);
    this.composer.render();
  };
  d.everytick = function(c) {
  };
  d.everySecondBeat = function(c) {
    console.log("begin ball beat");
    this.cubeshader.uniforms.brightness.value = 1;
    this.cubeshader.uniforms.rnd.value += 3;
  };
  d.beginBallFade = function() {
    console.log("begin ball fade");
    createjs.Tween.get(this).to({stopval:1}, (new kvg.core.TimeSig(6, 2, 0)).toMilliseconds(), createjs.Ease.quintInOut);
  };
  d.beginPortal = function() {
    console.log("BEGIN portal");
    this.scale = 2;
    createjs.Tween.get(this.transmat.uniforms.zoom).to({value:1}, 6E3, createjs.Ease.quadOut);
    this.transPlane.visible = !0;
  };
  d.beginPortalFinal = function() {
    console.log("begin portal final");
    createjs.Tween.get(this.transmat.uniforms.zoom).to({value:2}, 1E4, createjs.Ease.quadOut);
  };
})();
demo.parts.shadertest = {};
(function() {
  demo.parts.shadertest = {fragment:"foo\nblah\nbar"};
})();
demo.parts.GreetPart = {};
demo.parts.GreetPart.GreetShader = {};
(function() {
  demo.parts.GreetPart.GreetShader = {attributes:{}, vertex:"vec3 mod289(vec3 x)\n{\nreturn x - floor(x * (1.0 / 289.0)) * 289.0;\n}\n\nvec4 mod289(vec4 x)\n{\nreturn x - floor(x * (1.0 / 289.0)) * 289.0;\n}\n\nvec4 permute(vec4 x)\n{\nreturn mod289(((x*34.0)+1.0)*x);\n}\n\nvec4 taylorInvSqrt(vec4 r)\n{\nreturn 1.79284291400159 - 0.85373472095314 * r;\n}\n\nvec3 fade(vec3 t) {\nreturn t*t*t*(t*(t*6.0-15.0)+10.0);\n}\n\n// Classic Perlin noise\nfloat cnoise(vec3 P)\n{\nvec3 Pi0 = floor(P); // Integer part for indexing\nvec3 Pi1 = Pi0 + vec3(1.0); // Integer part + 1\nPi0 = mod289(Pi0);\nPi1 = mod289(Pi1);\nvec3 Pf0 = fract(P); // Fractional part for interpolation\nvec3 Pf1 = Pf0 - vec3(1.0); // Fractional part - 1.0\nvec4 ix = vec4(Pi0.x, Pi1.x, Pi0.x, Pi1.x);\nvec4 iy = vec4(Pi0.yy, Pi1.yy);\nvec4 iz0 = Pi0.zzzz;\nvec4 iz1 = Pi1.zzzz;\n\nvec4 ixy = permute(permute(ix) + iy);\nvec4 ixy0 = permute(ixy + iz0);\nvec4 ixy1 = permute(ixy + iz1);\n\nvec4 gx0 = ixy0 * (1.0 / 7.0);\nvec4 gy0 = fract(floor(gx0) * (1.0 / 7.0)) - 0.5;\ngx0 = fract(gx0);\nvec4 gz0 = vec4(0.5) - abs(gx0) - abs(gy0);\nvec4 sz0 = step(gz0, vec4(0.0));\ngx0 -= sz0 * (step(0.0, gx0) - 0.5);\ngy0 -= sz0 * (step(0.0, gy0) - 0.5);\n\nvec4 gx1 = ixy1 * (1.0 / 7.0);\nvec4 gy1 = fract(floor(gx1) * (1.0 / 7.0)) - 0.5;\ngx1 = fract(gx1);\nvec4 gz1 = vec4(0.5) - abs(gx1) - abs(gy1);\nvec4 sz1 = step(gz1, vec4(0.0));\ngx1 -= sz1 * (step(0.0, gx1) - 0.5);\ngy1 -= sz1 * (step(0.0, gy1) - 0.5);\n\nvec3 g000 = vec3(gx0.x,gy0.x,gz0.x);\nvec3 g100 = vec3(gx0.y,gy0.y,gz0.y);\nvec3 g010 = vec3(gx0.z,gy0.z,gz0.z);\nvec3 g110 = vec3(gx0.w,gy0.w,gz0.w);\nvec3 g001 = vec3(gx1.x,gy1.x,gz1.x);\nvec3 g101 = vec3(gx1.y,gy1.y,gz1.y);\nvec3 g011 = vec3(gx1.z,gy1.z,gz1.z);\nvec3 g111 = vec3(gx1.w,gy1.w,gz1.w);\n\nvec4 norm0 = taylorInvSqrt(vec4(dot(g000, g000), dot(g010, g010), dot(g100, g100), dot(g110, g110)));\ng000 *= norm0.x;\ng010 *= norm0.y;\ng100 *= norm0.z;\ng110 *= norm0.w;\nvec4 norm1 = taylorInvSqrt(vec4(dot(g001, g001), dot(g011, g011), dot(g101, g101), dot(g111, g111)));\ng001 *= norm1.x;\ng011 *= norm1.y;\ng101 *= norm1.z;\ng111 *= norm1.w;\n\nfloat n000 = dot(g000, Pf0);\nfloat n100 = dot(g100, vec3(Pf1.x, Pf0.yz));\nfloat n010 = dot(g010, vec3(Pf0.x, Pf1.y, Pf0.z));\nfloat n110 = dot(g110, vec3(Pf1.xy, Pf0.z));\nfloat n001 = dot(g001, vec3(Pf0.xy, Pf1.z));\nfloat n101 = dot(g101, vec3(Pf1.x, Pf0.y, Pf1.z));\nfloat n011 = dot(g011, vec3(Pf0.x, Pf1.yz));\nfloat n111 = dot(g111, Pf1);\n\nvec3 fade_xyz = fade(Pf0);\nvec4 n_z = mix(vec4(n000, n100, n010, n110), vec4(n001, n101, n011, n111), fade_xyz.z);\nvec2 n_yz = mix(n_z.xy, n_z.zw, fade_xyz.y);\nfloat n_xyz = mix(n_yz.x, n_yz.y, fade_xyz.x); \nreturn 2.2 * n_xyz;\n}\n\n// Classic Perlin noise, periodic variant\nfloat pnoise(vec3 P, vec3 rep)\n{\nvec3 Pi0 = mod(floor(P), rep); // Integer part, modulo period\nvec3 Pi1 = mod(Pi0 + vec3(1.0), rep); // Integer part + 1, mod period\nPi0 = mod289(Pi0);\nPi1 = mod289(Pi1);\nvec3 Pf0 = fract(P); // Fractional part for interpolation\nvec3 Pf1 = Pf0 - vec3(1.0); // Fractional part - 1.0\nvec4 ix = vec4(Pi0.x, Pi1.x, Pi0.x, Pi1.x);\nvec4 iy = vec4(Pi0.yy, Pi1.yy);\nvec4 iz0 = Pi0.zzzz;\nvec4 iz1 = Pi1.zzzz;\n\nvec4 ixy = permute(permute(ix) + iy);\nvec4 ixy0 = permute(ixy + iz0);\nvec4 ixy1 = permute(ixy + iz1);\n\nvec4 gx0 = ixy0 * (1.0 / 7.0);\nvec4 gy0 = fract(floor(gx0) * (1.0 / 7.0)) - 0.5;\ngx0 = fract(gx0);\nvec4 gz0 = vec4(0.5) - abs(gx0) - abs(gy0);\nvec4 sz0 = step(gz0, vec4(0.0));\ngx0 -= sz0 * (step(0.0, gx0) - 0.5);\ngy0 -= sz0 * (step(0.0, gy0) - 0.5);\n\nvec4 gx1 = ixy1 * (1.0 / 7.0);\nvec4 gy1 = fract(floor(gx1) * (1.0 / 7.0)) - 0.5;\ngx1 = fract(gx1);\nvec4 gz1 = vec4(0.5) - abs(gx1) - abs(gy1);\nvec4 sz1 = step(gz1, vec4(0.0));\ngx1 -= sz1 * (step(0.0, gx1) - 0.5);\ngy1 -= sz1 * (step(0.0, gy1) - 0.5);\n\nvec3 g000 = vec3(gx0.x,gy0.x,gz0.x);\nvec3 g100 = vec3(gx0.y,gy0.y,gz0.y);\nvec3 g010 = vec3(gx0.z,gy0.z,gz0.z);\nvec3 g110 = vec3(gx0.w,gy0.w,gz0.w);\nvec3 g001 = vec3(gx1.x,gy1.x,gz1.x);\nvec3 g101 = vec3(gx1.y,gy1.y,gz1.y);\nvec3 g011 = vec3(gx1.z,gy1.z,gz1.z);\nvec3 g111 = vec3(gx1.w,gy1.w,gz1.w);\n\nvec4 norm0 = taylorInvSqrt(vec4(dot(g000, g000), dot(g010, g010), dot(g100, g100), dot(g110, g110)));\ng000 *= norm0.x;\ng010 *= norm0.y;\ng100 *= norm0.z;\ng110 *= norm0.w;\nvec4 norm1 = taylorInvSqrt(vec4(dot(g001, g001), dot(g011, g011), dot(g101, g101), dot(g111, g111)));\ng001 *= norm1.x;\ng011 *= norm1.y;\ng101 *= norm1.z;\ng111 *= norm1.w;\n\nfloat n000 = dot(g000, Pf0);\nfloat n100 = dot(g100, vec3(Pf1.x, Pf0.yz));\nfloat n010 = dot(g010, vec3(Pf0.x, Pf1.y, Pf0.z));\nfloat n110 = dot(g110, vec3(Pf1.xy, Pf0.z));\nfloat n001 = dot(g001, vec3(Pf0.xy, Pf1.z));\nfloat n101 = dot(g101, vec3(Pf1.x, Pf0.y, Pf1.z));\nfloat n011 = dot(g011, vec3(Pf0.x, Pf1.yz));\nfloat n111 = dot(g111, Pf1);\n\nvec3 fade_xyz = fade(Pf0);\nvec4 n_z = mix(vec4(n000, n100, n010, n110), vec4(n001, n101, n011, n111), fade_xyz.z);\nvec2 n_yz = mix(n_z.xy, n_z.zw, fade_xyz.y);\nfloat n_xyz = mix(n_yz.x, n_yz.y, fade_xyz.x); \nreturn 2.2 * n_xyz;\n}\nattribute vec4 tangent;\nuniform float time;\nvarying float noise;\nuniform vec2 repeat;\nuniform float useNormal;\nuniform float useRim;\nuniform float shred;\nvarying vec2 vUv;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec3 vEye;\nvarying vec3 vU;\nvarying vec2 vN;\nfloat turbulence( vec3 p ) {\nfloat w = 100.0;\nfloat t = -.5;\nfor (float f = 1.0 ; f <= 10.0 ; f++ ){\nfloat power = pow( 2.0, f );\nt += abs( pnoise( vec3( power * p ), vec3( 10.0, 10.0, 10.0 ) ) / power );\n}\nreturn t;\n}\nvoid main() {\nvU = normalize( vec3( modelViewMatrix * vec4( position, 1.0 ) ) );\nif( useNormal == 0. ) {\nvec3 n = normalize( normalMatrix * normal );\nvec3 r = reflect( vU, n );\nfloat m = 2.0 * sqrt( r.x * r.x + r.y * r.y + ( r.z + 1.0 ) * ( r.z+1.0 ) );\nvN = vec2( r.x / m + 0.5,  r.y / m + 0.5 );\n} else {\nvN = vec2( 0. );\n}\nvUv = repeat * uv;\nnoise = 10.0 *  -.10 * turbulence( .5 * normal + time );\nfloat b = 15.0 * shred * pnoise( 0.05 * position + vec3( 2.0 * time ), vec3( 100.0 ) );\nfloat displacement = - 10. * noise + b;\nvec3 newPosition = position + normal * displacement;\nnewPosition.z = newPosition.z * 2.0;\nnewPosition.x = newPosition.x * 1.2;\nnewPosition.y = newPosition.y * 1.2;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( newPosition, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nif( useNormal == 1. ) {\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = normalize( cross( vNormal, vTangent ) * tangent.w );\n} else {\nvTangent = vec3( 0. );\nvBinormal = vec3( 0. );\n}\nif( useRim > 0. ) {\nvEye = ( modelViewMatrix * vec4( position, 1.0 ) ).xyz;\n} else {\nvEye = vec3( 0. );\n}\n}", 
  fragment:"uniform float time;\nuniform float bump;\nuniform sampler2D tNormal;\nuniform sampler2D tMatCap;\nuniform float noise;\nuniform float useNormal;\nuniform float useRim;\nuniform float rimPower;\nuniform float useScreen;\nuniform float normalScale;\nuniform float normalRepeat;\nvarying vec2 vUv;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec3 vEye;\nvarying vec3 vU;\nvarying vec2 vN;\nfloat random(vec3 scale,float seed){return fract(sin(dot(gl_FragCoord.xyz+seed,scale))*43758.5453+seed);}\nvoid main() {\nvec3 finalNormal = vNormal;\nvec2 calculatedNormal = vN;\nif( useNormal == 1. ) {\nvec3 normalTex = texture2D( tNormal, vUv  ).xyz * 2.0 - 1.0;\nnormalTex.xy *= normalScale;\nnormalTex.y *= -1.;\nnormalTex = normalize( normalTex );\nmat3 tsb = mat3( normalize( vTangent ), normalize( vBinormal ), normalize( vNormal ) );\nfinalNormal = tsb * normalTex;\nvec3 r = reflect( vU, normalize( finalNormal ) );\nfloat m = 2.0 * sqrt( r.x * r.x + r.y * r.y + ( r.z + 1.0 ) * ( r.z+1.0 ) );\ncalculatedNormal = vec2( r.x / m + 0.5,  r.y / m + 0.5 );\n}\nvec3 base = texture2D( tMatCap, calculatedNormal ).rgb;\nif( useRim > 0. ) {\nfloat f = rimPower * abs( dot( vNormal, normalize( vEye ) ) );\nf = useRim * ( 1. - smoothstep( 0.0, 1., f ) );\nbase += vec3( f );\n}\nif( useScreen == 1. ) {\nbase = vec3( 1. ) - ( vec3( 1. ) - base ) * ( vec3( 1. ) - base );\n}\ngl_FragColor = vec4( 2.0*base, 1. );\n}"};
})();
demo.greets2 = {};
demo.greets2.TransitionShader2 = {};
(function() {
  demo.greets2.TransitionShader2 = function() {
    this.uniforms = {zoom:{type:"f", value:.6}, resolution:{type:"v2", value:new THREE.Vector2(8, 8)}, time:{type:"f", value:164}, l1c:{type:"c", value:new THREE.Color}, l2c:{type:"c", value:new THREE.Color}, l3c:{type:"c", value:new THREE.Color}, color:{type:"c", value:new THREE.Color}, l1:{type:"v3", value:new THREE.Vector3}, l2:{type:"v3", value:new THREE.Vector3}, l3:{type:"v3", value:new THREE.Vector3}, curp:{type:"v3", value:new THREE.Vector3}};
    this.vertex = d;
    this.fragment = c;
  };
  var d = "varying vec2 vUv;\nvarying vec3 vP;\nuniform vec3 curp;\nvoid main() {\nvec3 p = position;\nvUv = uv;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );\nvP = (modelMatrix  * vec4( p, 1.0 )).xyz;\n}", c = "varying vec2 vUv;\nvarying vec3 vP;\nuniform vec2 resolution;\nuniform float time;\nuniform vec3 color;\nuniform vec3 l1;\nuniform vec3 l2;\nuniform vec3 l3;\nuniform vec3 l1c;\nuniform vec3 l2c;\nuniform vec3 l3c;\nuniform float zoom;\nuniform sampler2D texture;\nfloat rand(vec2 co){\nreturn fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);\n}\nvoid main() {\nvec2 uv = vUv;\nvec3 bc =color;// texture2D(texture, uv).rgb;\nvec2 center = vec2(0.5, 0.5);\nfloat dx = (center.x - uv.x);\nfloat dy = (center.y - uv.y)*resolution.y/resolution.x;\nfloat dist = sqrt(dx*dx + dy*dy);\nfloat angle = atan(dy,dx);\nvec3 c = bc;//vec3(1.37,1.5,0.5);\nfloat target = 0.1*zoom;\ntarget +=(  sin((cos(angle*4.0+time*0.1)*1.7+time*0.3))*(0.21+sin(time*2.3+angle)*0.13))*zoom*0.3+(abs(sin(time*0.15))*0.1+0.9)*zoom*0.3;\nfloat mp = 1.0-step(dist,target);\nc*=mp;\nuv.y*=resolution.y;\nuv.y = -1.0+2.0*uv.y;\nuv.y-=0.3;\ndist = abs(target-dist);\nfloat distmp = abs(0.5/(95.0*dist));\ndistmp = pow(distmp,1.5) * (step(0.05,distmp));\nc.b -= 0.4*distmp;// *abs((target-dist)* sin(uv.y*time*2.1));\nc.g -= 0.4*distmp;//abs(0.5/(95.0*(dist)));\nc.r -= 0.4*distmp;// abs(0.5/(95.0*(dist)));\nuv.xy+=time;\nfloat rndn=rand(uv)*0.5;\nc.r+=(1.0-mp)*rndn*40./255.;\nc.g+=(1.0-mp)*rndn*160./255.;\nc.b+=(1.0-mp)*rndn*232./255.;\nfloat rndad =0.015* mp*rand(vUv);\nc*=0.3;\nfloat maxdist=mp*160.2;\nfloat intensity = 1.;\nfloat distl = distance(vP, l1);\nc+=smoothstep(0.0,maxdist,max(0.0,maxdist-distl))*l1c;\ndistl = distance(vP, l2);\nc+=smoothstep(0.0,maxdist,max(0.0,maxdist-distl))*l2c;\ndistl = distance(vP, l3);\nc+=smoothstep(0.0,maxdist,max(0.0,maxdist-distl))*l3c;\ngl_FragColor = vec4(c, mp+c.b*0.1);\n}";
})();
demo.parts.Greet2Part = {};
(function() {
  var d = (demo.parts.Greet2Part = function() {
  }).prototype = new kvg.core.Part;
  d.init = function() {
    this.stopval = 0;
    this.renderContinuous = !0;
    kvg.core.Part.prototype.init.call(this);
    this.clearColor = "#fff";
    this.initStandardScene();
    this.initStandardComposer(!1, !1, !0);
    this.cameraControl = new kvg.demo.CameraController;
    this.cameraControl.attachCamera(this.camera);
    this.cameraControl.initialize([new THREE.Vector3(0, 0, -150), new THREE.Vector3(0, 0, -50), new THREE.Vector3(0, 0, -0), new THREE.Vector3(0, 0, 100), new THREE.Vector3(0, 56, 142), new THREE.Vector3(0, 92, 221), new THREE.Vector3(0, 31, 255), new THREE.Vector3(0, 10, 308), new THREE.Vector3(48, 14, 343), new THREE.Vector3(98, 66, 346), new THREE.Vector3(100, 156, 346), new THREE.Vector3(81, 404, 342)], [new THREE.Vector3(0, 0, 10), new THREE.Vector3(0, 0, 10), new THREE.Vector3(0, 0, 10), new THREE.Vector3(0, 
    0, 110), new THREE.Vector3(0, 66, 145), new THREE.Vector3(0, 93, 231), new THREE.Vector3(0, 22, 260), new THREE.Vector3(0, 11, 318), new THREE.Vector3(58, 14, 345), new THREE.Vector3(101, 76, 346), new THREE.Vector3(99, 166, 345), new THREE.Vector3(80, 494, 342)], kvg.demo.CameraController.BEZIER);
    var c = [0];
    this.transgeom = new THREE.PlaneGeometry(100, 100, 1, 1);
    this.mats = [];
    for (var a = 0;a < c.length;a++) {
      this.transShader = new demo.greets2.TransitionShader2;
      var b = new THREE.ShaderMaterial({fragmentShader:this.transShader.fragment, vertexShader:this.transShader.vertex, uniforms:this.transShader.uniforms, side:THREE.DoubleSide, transparent:!0});
      b.uniforms.zoom.value = .9;
      b.uniforms.color.value = new THREE.Color(c[a % c.length]);
      b.uniforms.time.value = 0;
      b.basetime = b.uniforms.time.value;
      b.uniforms.l1c.value = new THREE.Color(16719904);
      b.uniforms.l2c.value = new THREE.Color(2162464);
      b.uniforms.l3c.value = new THREE.Color(2105599);
      b.uniforms.l1.value = new THREE.Vector3(-10.1, .1, .1);
      b.uniforms.l2.value = new THREE.Vector3(.1, -100.1, .1);
      b.uniforms.l3.value = new THREE.Vector3(.1, .1, 100.1);
      this.mats.push(b);
    }
    this.cubes = [];
    this.spheregeometry = new THREE.SphereGeometry(20, 20, 15);
    c = [2, 2, 1, 2, 3, 1, 2, 3, 2, 2, 2, 2, 2, 2, 3, 3, 2, 3];
    this.grid = [];
    for (a = 0;5 > a;a++) {
      for (this.grid.push([]), b = 0;5 > b;b++) {
        this.grid[a].push([]);
        for (var d = 0;5 > d;d++) {
          var f = this.createBox(100 * a - 200, 100 * b - 200, 100 * d, this.mats[(a + b + d) % this.mats.length], 4 == b, !0, !0, 4 == a, !0, 4 == d, a, b, d);
          this.grid[a][b].push(f);
          this.scene.add(f);
        }
      }
    }
    for (a = 0;a < c.length;a += 3) {
      this.createBall(this.grid[c[a]][c[a + 1]][c[a + 2]]);
    }
    c = {ananasmurska:{x:2, y:2, z:0, pos:new THREE.Vector3(0, -9, 100), rot:new THREE.Vector3(0, 3, 0)}, alumni:{x:2, y:2, z:0, pos:new THREE.Vector3(0, -6, 60), rot:new THREE.Vector3(.3, 3.18, 0)}, supadupa:{x:2, y:2, z:0, pos:new THREE.Vector3(0, -3, 20), rot:new THREE.Vector3(0, 3, 0)}, odios:{x:2, y:2, z:0, pos:new THREE.Vector3(0, -4, 80), rot:new THREE.Vector3(0, 3, 0)}, jumalauta:{x:2, y:2, z:1, pos:new THREE.Vector3(0, 14, 30), rot:new THREE.Vector3(0, 3, 0)}, api:{x:2, y:2, z:1, pos:new THREE.Vector3(0, 
    35, 53), rot:new THREE.Vector3(0, 3, 0)}, traction:{x:2, y:2, z:1, pos:new THREE.Vector3(0, 0, 10), rot:new THREE.Vector3(0, 3, 0)}, asd:{x:2, y:3, z:1, pos:new THREE.Vector3(0, -20, 50), rot:new THREE.Vector3(1.5, 0, 3.14)}, bombsquad:{x:2, y:3, z:1, pos:new THREE.Vector3(0, -25, 40), rot:new THREE.Vector3(1.5, 0, 3.14)}, conspiracy:{x:2, y:3, z:1, pos:new THREE.Vector3(0, -30, 30), rot:new THREE.Vector3(1.4, 0, 3.14)}, byterapers:{x:2, y:3, z:2, pos:new THREE.Vector3(0, -10, 30), rot:new THREE.Vector3(0, 
    3.1, 0)}, damones:{x:2, y:3, z:2, pos:new THREE.Vector3(0, -5, 25), rot:new THREE.Vector3(0, 3.1, 0)}, _soleil_:{x:2, y:3, z:2, pos:new THREE.Vector3(0, 0, 20), rot:new THREE.Vector3(0, 3.1, 0)}, dekadence:{x:2, y:2, z:2, pos:new THREE.Vector3(-2.2, 22, 67), rot:new THREE.Vector3(1, 3.1, 0)}, doo:{x:2, y:2, z:2, pos:new THREE.Vector3(0, 0, 80), rot:new THREE.Vector3(1, 3.1, 0)}, paraguay:{x:2, y:2, z:2, pos:new THREE.Vector3(0, 30, 55), rot:new THREE.Vector3(1, 3.1, 0)}, elventhor:{x:2, y:2, 
    z:3, pos:new THREE.Vector3(0, 5, 30), rot:new THREE.Vector3(0, 3.1, 0)}, evoflash:{x:2, y:2, z:3, pos:new THREE.Vector3(0, 10, 30), rot:new THREE.Vector3(0, 3.1, 0)}, npli:{x:2, y:2, z:3, pos:new THREE.Vector3(0, 15, 30), rot:new THREE.Vector3(0, 3.1, 0)}, primitive:{x:2, y:2, z:3, pos:new THREE.Vector3(0, 20, 30), rot:new THREE.Vector3(0, 3.1, 0)}, darklite:{x:3, y:2, z:3, pos:new THREE.Vector3(12, 40, 30), rot:new THREE.Vector3(0, -.75, 0)}, fairlight:{x:3, y:2, z:3, pos:new THREE.Vector3(12, 
    35, 30), rot:new THREE.Vector3(0, -.75, 0)}, fgj:{x:3, y:2, z:3, pos:new THREE.Vector3(12, 30, 30), rot:new THREE.Vector3(0, -.75, 0)}, mercury:{x:3, y:2, z:3, pos:new THREE.Vector3(12, 25, 30), rot:new THREE.Vector3(0, -.75, 0)}, hbc:{x:3, y:3, z:3, pos:new THREE.Vector3(0, 20, 50), rot:new THREE.Vector3(1.5, 0, 1)}, hedelmae:{x:3, y:3, z:3, pos:new THREE.Vector3(-3, -20, 50), rot:new THREE.Vector3(1.5, 0, 1.5)}, matt:{x:3, y:3, z:3, pos:new THREE.Vector3(-1, 0, 50), rot:new THREE.Vector3(1.5, 
    0, 1.4)}, current:{x:3, y:3, z:3, pos:new THREE.Vector3(3, 0, 54), rot:new THREE.Vector3(1.5, 0, 1.4)}, kakut:{x:3, y:4, z:3, pos:new THREE.Vector3(0, -55, 56), rot:new THREE.Vector3(1.5, 0, 0)}, kewlers:{x:3, y:4, z:3, pos:new THREE.Vector3(3, -40, 50), rot:new THREE.Vector3(1.5, 0, 0)}, konvergence:{x:3, y:4, z:3, pos:new THREE.Vector3(10, -25, 42), rot:new THREE.Vector3(1.5, 0, 0)}, pyrotech:{x:3, y:4, z:3, pos:new THREE.Vector3(-17, 50, 44), rot:new THREE.Vector3(1.5, 0, -1.26)}};
    this.greets = [];
    this.textMaterial = new THREE.MeshPhongMaterial({color:9474192, emissive:0});
    for (e in c) {
      a = c[e], this.createText(e, this.grid[a.x][a.y][a.z], a.pos, a.rot);
    }
    this.light1 = new THREE.PointLight(4473924, 2, 90);
    this.light1.position.set(0, 0, 0);
    this.scene.add(this.light1);
    this.light2 = new THREE.PointLight(4473924, 5, 90);
    this.light2.position.set(0, 0, 0);
    this.scene.add(this.light2);
    this.light3 = new THREE.PointLight(4473924, 5, 90);
    this.light3.position.set(0, 0, 0);
    this.scene.add(this.light3);
    var e = new THREE.SphereGeometry(1, 4, 4), c = new THREE.MeshPhongMaterial({emissive:15658734, opacity:.5});
    this.l1sp = new THREE.Mesh(e, c);
    this.scene.add(this.l1sp);
    c = new THREE.MeshPhongMaterial({emissive:16748608, opacity:.5});
    this.l2sp = new THREE.Mesh(e, c);
    this.scene.add(this.l2sp);
    c = new THREE.MeshPhongMaterial({emissive:37119, opacity:.5});
    this.l3sp = new THREE.Mesh(e, c);
    this.scene.add(this.l3sp);
    e = new THREE.AmbientLight(4210752);
    this.scene.add(e);
    this.bgColor = 1381653;
    this.background = new demo.effects.BGEffect;
    this.background.init();
    this.background.container.position.z = 250;
    this.background.container.scale.set(20, 20, 20);
    this.scene.add(this.background.container);
    this.addTrigger(new kvg.core.TimeSig(18, 0, 0, kvg.core.TimeSig.RELATIVE), this.beginLightFade);
    this.addTrigger(new kvg.core.TimeSig(84, 0, 0, kvg.core.TimeSig.ABSOLUTE), this.fade);
    this.increase = 0;
  };
  d.fade = function() {
    this.l3sp.visible = !1;
    this.l2sp.visible = !1;
    this.l1sp.visible = !1;
  };
  d.createText = function(c, a, b, d) {
    var f = new THREE.TextGeometry(c, {font:"911 porscha", size:4, height:.2});
    f.center();
    var e = new THREE.Mesh(f, this.textMaterial);
    e.rotation.y = Math.PI;
    f.computeBoundingBox();
    e.position.set(a.position.x + b.x, a.position.y + b.y, a.position.z + b.z);
    e.rotation.set(d.x, d.y, d.z);
    e.rot = d;
    console.log(c + ", " + a.position.x + "," + a.position.y + "," + a.position.z + " - " + e.position.x + "," + e.position.y + "," + e.position.z);
    this.scene.add(e);
    this.greets.push(e);
  };
  d.createBox = function(c, a, b, d, f, e, k, g, m, l, h, n, p) {
    h = new THREE.Object3D;
    h.position.x = c;
    h.position.y = a;
    h.position.z = b;
    m && (c = new THREE.Mesh(this.transgeom, d), c.position.z = 0, h.add(c));
    l && (l = new THREE.Mesh(this.transgeom, d), l.position.z = 100, h.add(l));
    f && (f = new THREE.Mesh(this.transgeom, d), f.position.z = 50, f.position.y = 50, f.rotation.x = Math.PI / 2, h.add(f));
    e && (e = new THREE.Mesh(this.transgeom, d), e.position.z = 50, e.position.y = -50, e.rotation.x = -Math.PI / 2, h.add(e));
    k && (k = new THREE.Mesh(this.transgeom, d), k.position.z = 50, k.position.x = -50, k.rotation.y = -Math.PI / 2, h.add(k));
    g && (d = new THREE.Mesh(this.transgeom, d), d.position.z = 50, d.position.x = 50, d.rotation.y = -Math.PI / 2, h.add(d));
    return h;
  };
  d.createBall = function(c) {
    var a = new THREE.CubeCamera(1, 2E3, 512), b = new THREE.MeshPhongMaterial({envMap:a.renderTarget, side:THREE.DoubleSide, color:0, emissive:16777215}), b = new THREE.Mesh(this.spheregeometry, b);
    b.position.x = 0;
    b.position.y = 0;
    b.position.z = 50;
    b.speed = .001;
    this.scene.add(a);
    b.cubecam = a;
    console.log("cube created");
    c.add(b);
    this.cubes.push(b);
    b.container = c;
  };
  d.postInit = function() {
  };
  d.beginLineFade = function() {
    console.log("BEGIN LINE FADE");
  };
  d.update = function(c, a) {
    var b = a;
    this.cameraControl.update(b);
    kvg.core.Part.prototype.update.call(this, c);
    this.background.update(c);
    var d = b + .02;
    0 > d ? d = 0 : 1 < d && (d = 1);
    d = this.cameraControl.path.getPoint(d);
    b *= 4E4;
    this.light1.position.x = d.x + 13 * Math.sin(5E-4 * b);
    this.light1.position.y = d.y + 13 * Math.sin(.001 * b);
    this.light1.position.z = d.z + 13 * Math.cos(.001 * b);
    this.l1sp.position.x = this.light1.position.x;
    this.l1sp.position.y = this.light1.position.y;
    this.l1sp.position.z = this.light1.position.z;
    this.light2.position.x = d.x + 15 * Math.sin(5E-4 * b);
    this.light2.position.y = d.y + 15 * Math.sin(.0017 * b);
    this.light2.position.z = d.z + 15 * Math.cos(.002 * b + .8);
    this.l2sp.position.x = this.light2.position.x;
    this.l2sp.position.y = this.light2.position.y;
    this.l2sp.position.z = this.light2.position.z;
    this.light3.position.x = d.x + 14 * Math.sin(7E-4 * b + .4);
    this.light3.position.y = d.y + 14 * Math.sin(5E-4 * b + 18);
    this.light3.position.z = d.z + 14 * Math.cos(2E-4 * b);
    this.l3sp.position.x = this.light3.position.x;
    this.l3sp.position.y = this.light3.position.y;
    this.l3sp.position.z = this.light3.position.z;
    this.mats[0].uniforms.l1.value = this.light1.position;
    this.mats[0].uniforms.l2.value = this.light2.position;
    this.mats[0].uniforms.l3.value = this.light3.position;
    for (d = 0;d < this.mats.length;d++) {
      var f = this.mats[d];
      f.uniforms.time.value = f.basetime + .001 * b;
    }
  };
  d.render = function() {
    this.iter = this.iter || 0;
    var c = kvg.core.graphics.renderer;
    c.autoClear = !0;
    c.setClearColor("#fff", 1);
    for (var a = 0;a < this.cubes.length;a++) {
      var b = this.cubes[a];
      b.container.position.z += 50;
      if (this.iter % this.cubes.length == a || 80 > this.distance(b.container.position, this.camera.position)) {
        for (var d = 0;d < this.greets.length;d++) {
          this.greets[d].lookAt(b.container.position);
        }
        b.visible = !1;
        b.cubecam.position.copy(b.container.position);
        b.cubecam.updateCubeMap(c, this.scene);
        b.material.needsUpdate = !0;
        b.visible = !0;
        b.initrend = !0;
        console.log("update");
      }
      b.container.position.z -= 50;
    }
    this.iter++;
    c.autoClear = this.autoClear;
    c.setClearColor(this.bgColor, 1);
    for (a = 0;a < this.greets.length;a++) {
      this.greets[a].rotation.set(this.greets[a].rot.x, this.greets[a].rot.y, this.greets[a].rot.z);
    }
    this.composer.render();
  };
  d.distance = function(c, a) {
    var b = c.x - a.x, d = c.y - a.y, f = c.z - a.z;
    return Math.sqrt(b * b + d * d + f * f);
  };
  d.everytick = function(c) {
  };
  d.beginLightFade = function() {
    createjs.Tween.get(this.background.uniforms.lightness).to({value:1}, 1400);
    createjs.Tween.get(this).to({bgColor:0}, 1400);
  };
  d.everySecondBeat = function(c) {
    this.increase = c.toMilliseconds();
  };
  d.beginPortal = function() {
    this.scale = 2;
    createjs.Tween.get(this).to({stopval:1}, 12E3, createjs.Ease.quintInOut);
  };
})();
demo.parts.AsteroidPart.TubeShader = {};
(function() {
  demo.parts.AsteroidPart.TubeShader = {attributes:{}, vertex:"varying vec2 vUv;\nvoid main() {\nvUv = uv;\ngl_Position = projectionMatrix * modelViewMatrix * vec4(position,1.0);\n}", fragment:"uniform float time;\nvarying vec2 vUv;\nvoid main() {\ngl_FragColor = vec4(0.4,vUv.y,0.8,1.0);\n}"};
})();
demo.parts.OpeningPart.OpeningShader = {};
(function() {
  demo.parts.OpeningPart.OpeningShader = {attributes:{}, vertex:"uniform float displacement;\nvoid main() {\nvec3 newPosition = position + normal * -displacement;\nnewPosition.z = position.z;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( newPosition, 1.0 );\n}", fragment:"uniform float displacement;\nvoid main() {\ngl_FragColor = vec4(1,1,1,1);\n}"};
})();

