#version 150

uniform sampler2D Texture;
uniform sampler2D Texture2;
uniform float CoCScale;
uniform float CoCBias;
uniform float OneOverFilmSize;
uniform float Time;


/*in vData
{
    vec2 texCoord;
	vec4 normal;
	vec3 normalLocal;
	vec4 eye;
	vec2 depth;
	vec4 color;
	vec4 pos;
	float height;
}frag;*/

in fData
{
	vec2 texCoord;
	vec4 normal;
	vec2 depth;
	vec4 eye;
	vec3 colorMul;
	vec4 pos;
}frag;

void main()
{
	vec2 ssPos = vec2(frag.pos.xy) / frag.pos.w;
	ssPos += vec2(1.0);
	ssPos *= 0.5;
	ssPos = vec2(ssPos.x, 1.0 - ssPos.y);
	vec4 color = texture2D(Texture, ssPos);

	color.rgb *= 0.4;
	//color.rgb = mix(texture2D(Texture2, frag.texCoord + vec2(0.0, Time * 0.01)).rgb, vec3(0.1), (1.0 - length(vec2(0.5, 0.5) - frag.texCoord) * 2.0));
	vec3 texCol= texture2D(Texture2, frag.texCoord * 5.0 - vec2(0.0, Time * 0.15)).rgb * 0.3 * (1.0 - length(vec2(0.5, 0.5) - frag.texCoord) * 2.0);
	color.rgb += max(vec3(0.025), texCol);
	float zet = clamp((frag.depth.x - 80.0) * 0.05, 0.0, 1.0);
	color.rgb = mix(color.rgb, vec3(0.05), zet);
	

	gl_FragData[0] = vec4(color.rgb, 1.0);
}
