#version 150

in vec3 aPosition;
in vec3 aNormal;
in vec2 aUV;

uniform vec4 Color;
uniform mat4 ProjectionMatrix;
uniform mat4 CameraWorldMatrix;
uniform mat4 NormalMatrix;

out vec2 v_texCoord;
out vec4 v_normal;
out vec2 v_depth;

void main()
{
	v_texCoord = aUV;
	v_normal = NormalMatrix * vec4(aNormal, 1.0);

	vec4 pos = ProjectionMatrix * CameraWorldMatrix * vec4(aPosition, 1.0);
	v_depth = vec2(pos.z, pos.w);
	gl_Position = pos;
}
