uniform sampler2D Texture;
uniform vec4 Color;

varying vec4 v_color;
varying vec2 v_texCoord;

void main()
{
	vec4 color = vec4(0.0);
	vec2 offsetX = vec2(1.0 / 640.0, 0.0);
	vec2 offsetY = vec2(0.0, 1.0 / 480.0);
	
	// Horiz.
	color += texture2D(Texture, v_texCoord + offsetY - offsetX) * -1.0;
	color += texture2D(Texture, v_texCoord + offsetY) * 0.0;
	color += texture2D(Texture, v_texCoord + offsetY + offsetX) * 1.0;

	color += texture2D(Texture, v_texCoord - offsetX) * -2.0;
	color -= texture2D(Texture, v_texCoord) * 0.0;
	color += texture2D(Texture, v_texCoord + offsetX) * 2.0;
	
	color += texture2D(Texture, v_texCoord - offsetY - offsetX) * -1.0;
	color += texture2D(Texture, v_texCoord - offsetY) * 0.0;
	color += texture2D(Texture, v_texCoord - offsetY + offsetX) * 1.0;

	// Vert.
	color += texture2D(Texture, v_texCoord + offsetY - offsetX) * 1.0;
	color += texture2D(Texture, v_texCoord + offsetY) * 2.0;
	color += texture2D(Texture, v_texCoord + offsetY + offsetX) * 1.0;

	color += texture2D(Texture, v_texCoord - offsetX) * 0.0;
	color -= texture2D(Texture, v_texCoord) * 0.0;
	color += texture2D(Texture, v_texCoord + offsetX) * 0.0;
	
	color += texture2D(Texture, v_texCoord - offsetY - offsetX) * -1.0;
	color += texture2D(Texture, v_texCoord - offsetY) * -2.0;
	color += texture2D(Texture, v_texCoord - offsetY + offsetX) * -1.0;

	color *= Color;
	
	gl_FragColor = color;
}
