#version 150

in vec3 aPosition;
in vec3 aNormal;
in vec2 aUV;

uniform vec4 Color;
uniform mat4 ProjectionMatrix;
uniform mat4 CameraWorldMatrix;
uniform mat4 NormalMatrix;
uniform float Time;
uniform float CoCBias;

uniform sampler2D HeightMap;


out vData
{
    vec2 texCoord;
	vec4 normal;
	vec3 normalLocal;
	vec4 eye;
	vec2 depth;
	vec4 color;
	vec4 pos;
	float height;
}vertex;

void main()
{
	vertex.texCoord = aUV;
	vertex.color = Color;
	vertex.eye = -(CameraWorldMatrix * vec4(aPosition, 1.0));
	vertex.normal = (NormalMatrix * vec4(aNormal, 1.0));
	vertex.normalLocal = aNormal;
	vertex.height = texture2D(HeightMap, aUV + vec2(Time, 0.0) * 0.5).r;
	vertex.height *= texture2D(HeightMap, aUV).r;

	vec4 pos = ProjectionMatrix * CameraWorldMatrix * vec4(aPosition.xyz, 1.0);
	vertex.pos = vec4(aPosition.xyz, 0.0);
	vertex.depth = vec2(pos.z  + CoCBias, pos.w);
	
	gl_Position = pos;
}

