uniform sampler2D Texture;
uniform float CoCScale;
uniform float CoCBias;
uniform float OneOverFilmSize;
uniform vec4 Diffuse;
uniform vec4 Emissive;
uniform vec4 Color;
uniform vec4 CityLight;
uniform vec4 CityLight2;
uniform vec4 CityLightColor1;
uniform vec4 CityLightColor2;
uniform float CityLightShininess1;
uniform float CityLightShininess2;
uniform float Additive;
uniform float Time;
uniform float Time2;

in fData
{
    vec2 texCoord;
	vec4 normal;
	vec2 depth;
	vec4 eye;
	vec3 colorMul;
	vec4 pos;
}frag;

void main()
{
	vec3 N = normalize(frag.normal.xyz);
	vec3 L = normalize(CityLight.xyz);
	vec3 E = normalize(frag.eye.xyz);
	float LdotN = max(0.0, dot(L, N));
	vec4 spec = vec4(0.0);
	vec4 diffuse = vec4(0.0);
	if(LdotN > 0.0)
	{
		vec3 H = normalize(E + L); 
		float shininess = 50.0;
		float specIntensity = max(dot(H, N), 0.0);
        spec += CityLightColor1 * pow(specIntensity,CityLightShininess1);
		diffuse += CityLightColor1 * LdotN * Diffuse;
	}

	L = normalize(CityLight2.xyz);
	LdotN = max(0.0, dot(L, N));
	if(LdotN > 0.0)
	{
		vec3 H = normalize(E + L); 
		float shininess = 50.0;
		float specIntensity = max(dot(H, N), 0.0);
        spec += CityLightColor2 * pow(specIntensity,CityLightShininess2);
		diffuse += CityLightColor2 * LdotN * Diffuse;
	}
	vec4 baseColor = texture2D(Texture, frag.texCoord);
	vec3 color = baseColor.rgb * diffuse.rgb + spec.rgb + Emissive.rgb;
	color *= frag.colorMul;

	color += max(0.0, sin(frag.pos.y * 1.4 + Time2) - 0.999) * 200.0 * vec3(1.0, 0.5, 0.1) * Additive;

	float depth = frag.depth.x / frag.depth.y;
	depth = frag.depth.x * 0.1;
	depth = (CoCScale * depth) + CoCBias;
	
	depth *= OneOverFilmSize;

	gl_FragData[0] = vec4(color, depth);
}
