#define PI 3.141596
#define GOLDEN_ANGLE 2.39996323
#define NUMBER 600.0
#define ITERATIONS (GOLDEN_ANGLE * NUMBER)
#define ITERATIONS2 24.0

uniform sampler2D Texture;
uniform vec4 TextureRes;
uniform vec4 BokehValues;
varying vec2 v_texCoord;

vec2 Sample2(vec2 o, float f, float n){
    vec2 ab = (o * 2.0) - vec2(1.0);
    vec2 phir = ((ab.x * ab.x) > (ab.y * ab.y)) ? vec2((abs(ab.x) > 1e-8) ? ((PI * 0.25) * (ab.y / ab.x)) : 0.0, ab.x) : vec2((abs(ab.y) > 1e-8) ? ((PI * 0.5) - ((PI * 0.25) * (ab.x / ab.y))) : 0.0, ab.y); 
	phir.x += f * PI / 2.0;
   	phir.y *= (f > 0.0) ? pow((cos(PI / n) / cos(phir.x - ((2.0 * (PI / n)) * floor(((n * phir.x) + PI) / (2.0 * PI))))), f) : 1.0;
    return vec2(cos(phir.x), sin(phir.x)) * phir.y;
}

vec2 Sample(in float theta, inout float r)
{
    r += 1.0 / r;
	return (r-1.0) * vec2(cos(theta), sin(theta));
}

vec3 Bokeh(vec2 uv, float radius, float amount)
{
	vec3 acc = vec3(0.0);
	vec3 div = vec3(0.0);
    vec2 pixel = vec2(TextureRes.y / TextureRes.x, 1.0) * radius * .002;
	/*float itera = 1.0 / ITERATIONS2;
	for (float j = 0.0; j < 1.0; j += 0.01)
	{
		for(float i = 0.0; i < 1.0; i += itera)
		{
			vec2 inval = vec2(i, j);
			vec3 col = texture2D(Texture, uv + pixel * Sample2(inval, 1.0, 6.0) * 20.0).xyz * 1.0;
			col *= col;
			col *= 1.5;
			vec3 bokeh = vec3(5.0) + pow(col, vec3(9.0)) * amount;
			acc += col * bokeh;
			div += bokeh;
		}
	}*/
	float r = radius * 0.5;
	for (float j = 0.0; j < ITERATIONS; j += GOLDEN_ANGLE)
    {
		vec3 col = texture2D(Texture, uv + pixel * Sample(j, r)).xyz * 1.5;
        col *= col;
		vec3 bokeh = vec3(5.0) + pow(col, vec3(9.0)) * amount;
		acc += col * bokeh;
		div += bokeh;
	}
	return acc / div;
}

void main()
{
	//vec2 fragCoord = v_texCoord;
	vec2 uv = v_texCoord;//vfragCoord.xy / TextureRes.xy;
      
	float r = BokehValues.x;
	float a = BokehValues.y;
    
	r *= uv.y;

	gl_FragColor= vec4(Bokeh(uv, r, a), 1.0);
}