uniform float u_beg;
uniform float u_wota;

uniform float u_timeout;

float laskuri(vec2 uv2)
{

    float c = 1.0;
    float d = length(uv2);
    float a = mod((atan(uv2.x, uv2.y) / 3.14159) / 2.0 + 1.0, 1.0);
    
    float ct = u_timeout * 2.0 - 1.0;
    
    c = smoothstep(0.01,-0.01, a - ct);
    c *= smoothstep(0.2, 0.21, d);
    c *= smoothstep(0.3, 0.29, d);
    c = 1.0 - c * 0.9;

//    c = d;

    return c;
}

vec4 function()
{

	float ft = motionblur(1.0);
	vec2 uvx = uv2;

	vec4 col = vec4(0.0);

	float rot = ft;

	float ang = mod((atan(uvx.x, uvx.y) / 3.14159+1.0) * 4.0 + rot, 8.0);
	ang = floor(ang);

	//col.r = ang / 8.0;
	//if (ang > 6.5)
	//	col.g = 1.0;

	float t = ft - u_beg;;
//	t = mod(ft, 14.0);
	//t = 0.0;

	ang -= rot;
	ang += 0.5+sin(ft * 2.1292) * 0.0;
	ang *= 3.14159 / 4.0;

	vec2 dist = vec2(sin(ang), cos(ang));

	vec3 params;
	vec3 params1 = vec3(0.0, 50.0, 0.0);
	vec3 params2 = vec3(0.5, 50.0, 0.0);
	vec3 params3 = vec3(0.025, 120.0, 0.1);
	vec3 params4 = vec3(1.5*u_aspect, 30.0, -0.1);

	vec3 palmod1 = pow(vec3(smoothstep(0.0, 0.3, t)), vec3(1.2, 9.0, 1.0));
	params = mix(params1, params2, palmod1);

	vec3 palmod2 = pow(vec3(smoothstep(3.0, 4.0, t)), vec3(1.2, 9.0, 1.0));
	params = mix(params, params3, palmod2);

	vec3 palmod3 = pow(vec3(smoothstep(7.0, 10.0, t)), vec3(3.0, 9.0, 1.0));
	params = mix(params, params4, palmod3);

	uvx += dist * params.z;


	float c = (params.x - length(uvx)) * params.y;
	c = max(0.0, c);


	vec3 rob = min(vec3(1.0), vec3(0.8, 0.9,0.9) * 1.0 * c);
	vec3 ytlog = texture2D(iChannel0, uv2 * 1.3 + 0.5).rgb;

	float ytmix = 1.3;
	ytmix += smoothstep(0.5, 0.0, t) * 5.0;
	ytmix += smoothstep(3.0, 4.0, t) * 5.0;
	float uh = ytmix + sin(t * 2.0 + 2.0 + length(uv2) * 30.0) * 0.5;
	rob *= ytlog * uh + vec3(uh * 0.2);

	rob = min(rob, vec3(1.0));


	vec3 wot = texture2D(iChannel1, uv2 * vec2(0.45,0.5) + 0.5).rgb;
	wot = pow(wot*0.8, vec3(3.0)) / pow(0.8, 3.0);

	// buffering text
	float bufalpha = smoothstep(4.0, 5.0, t) - smoothstep(7.0, 8.0, t);
	rob = mix(rob, vec3(1.0), wot.g * bufalpha);

	float wotalpha = smoothstep(8.0, 10.0, t) * u_wota;
	rob = mix(rob, vec3(0.0), wot.r * wotalpha);


	vec2 pos = vec2(0.0);
	float muv = wotalpha-1.0;
	pos += sin(ft*vec2(5.1+muv*0.3,1.2)) * muv;
	pos.y += sin(ft*14.2) * 0.3 * muv;
	pos.x += sin(ft*9.2) * 0.2 * muv;
	pos.y -= muv * 3.0;
	float attenbo = laskuri(uv2 * vec2(5.0) + vec2(0.0, 4.0)+pos);
	rob *= attenbo;
	//rob = mix(rob, vec3(attenbo), wotalpha);

//	rob += wot;
	



	return vec4(rob, 0.0);
}