float ft;
float PI = 3.14159265;
bool isPrimaryRay;

mat3 rot_x(float ang) { return mat3(
			1.0, 0.0, 0.0,
			0.0, cos(ang), -sin(ang),
			0.0, sin(ang), cos(ang)); }
mat3 rot_y(float ang){ return mat3(
			cos(ang), 0.0, -sin(ang),
			0.0,      1.0, 0.0,
			sin(ang), 0.0, cos(ang)); }
mat3 rot_z(float ang) { return mat3(
			cos(ang), -sin(ang), 0.0,
			sin(ang), cos(ang), 0.0,
			0.0, 0.0, 1.0); }

float rot;

struct ray_t 
{
	vec3 o;
	vec3 d;
};

void doplane(in ray_t ray, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	float det=dot(plane.xyz,ray.d); 
	if (abs(det) > 0.0000001)
	{
		float num=plane.w - dot(plane.xyz, ray.o); float curdist=num/det;
		if (det > 0.0) { loc_min = curdist; loc_obj_id=obj_id; }
		if (det < 0.0) { loc_max = curdist; }
	}
}

//#if 0
void doplane_csg(in ray_t ray, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	float det=dot(plane.xyz,ray.d); 
	if (abs(det) > 0.0000001)
	{
		float num=plane.w - dot(plane.xyz, ray.o); float curdist=num/det;
		if (det > 0.0 && curdist > loc_min) { loc_min = curdist; loc_obj_id=obj_id; }
		if (det < 0.0 && curdist < loc_max) { loc_max = curdist; }
	}
}
//#endif

void dosphere(in ray_t ray, in vec4 sphere, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	vec3 d1 = ray.o - sphere.xyz;
	float b = 2.0 * dot(ray.d, d1);
	float c = dot(d1,d1) - sphere.w*sphere.w;

	float delta = b*b - 4.0*c;

	if (delta >= 0.0)
	{
		loc_min = (-b+sqrt(delta))/ (2.0);
		loc_max= (-b-sqrt(delta))/ (2.0);

		loc_obj_id = obj_id;
	}
	else
	{
		loc_min = 100000.0;
		loc_max = -100000.0;
	}
}

void dohemi(in ray_t ray, in vec4 sphere, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	vec3 d1 = ray.o - sphere.xyz;
	float b1 = 2.0 * dot(ray.d, d1);
	float c1 = dot(d1,d1) - sphere.w*sphere.w;

	vec3 d2 = ray.o - sphere.xyz - vec3(0.,1.,0.);
	float b2 = 2.0 * dot(ray.d, d2);
	float c2 = dot(d2,d2) - .99*sphere.w*sphere.w;

	float delta1 = b1*b1 - 4.0*c1;
	float delta2 = b2*b2 - 4.0*c2;

	if (delta1 >= 0.0)
	{	
		loc_obj_id = obj_id;

		loc_min = (-b1-sqrt(delta1))/ (2.0);
		loc_max= (-b1+sqrt(delta1))/ (2.0);

		float loc_min2 = (-b2-sqrt(delta2))/ (2.0);
		float loc_max2= (-b2+sqrt(delta2))/ (2.0);

		if (loc_min < loc_min2) 
		{
		}
			
		else if (loc_min2 < loc_max && loc_max > loc_max2) 
		{
			loc_min2 = (-b2+sqrt(delta2))/ (2.0);
			loc_min = loc_min2;

			loc_max2= (-b2-sqrt(delta2))/ (2.0);
			loc_max = loc_max2;
			
			loc_obj_id=5;
		}
			
		else
		{
			loc_min = 100000.0;
			loc_max = -100000.0;
			loc_obj_id=0;
		}	
	}
	else
	{
		loc_min = 100000.0;
		loc_max = -100000.0;
	}
}

void docylinder(in ray_t ray, in vec4 sphere, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	
	vec4 plane1 = vec4(0.0, -1.0, 0.0, sphere.y+16.);
	vec4 plane2 = vec4(0.0, -1.0, 0.0, sphere.y+0.);

	float det1=dot(plane1.xyz,ray.d); 
	float det2=dot(plane2.xyz,ray.d); 
	
	float p_min, p_max;

	float num = plane1.w - dot(plane1.xyz, ray.o); float curdist1 = num/det1;
	float num2 = plane2.w - dot(plane2.xyz, ray.o); float curdist2 = num2/det2;
	
	if (abs(det1) > 0.0000001)
	{
		if (det1 > 0.0) { p_min = curdist1; loc_obj_id=obj_id; }
		if (det1 < 0.0) { p_max = curdist1; }
	}
	
	if (abs(det2) > 0.0000001)
	{
		if (det2 < 0.0) { p_min = curdist2; loc_obj_id=obj_id; }
		if (det2 > 0.0) { p_max = curdist2; }
	}
	
	//varren veivailuun
	vec3 ds = ray.o - sphere.xyz;
	float bs = 2.0 * dot(ray.d, ds);
	float cs = dot(ds,ds) - sphere.w*sphere.w;
	float dd = bs*bs - 4.0*cs;

	float a = ray.d.x*ray.d.x + ray.d.z*ray.d.z;
	float b = 2 * ray.o.x * ray.d.x + 2 * ray.o.z * ray.d.z;
	float c = ray.o.x*ray.o.x + ray.o.z*ray.o.z - (sphere.w + 4.*cos(-.023*dd));

	float t = (-b - sqrt(b*b - 4.*a*c)) / (2.*a);
	//float t2 = (-b + sqrt(b*b - 4.*a*c)) / (2.*a);
	
	//float delta = (b*b - 4.0*a*c)/(2.*a);
	
	if (t  >= 0.)
	{
		if (p_min > t && t > p_max)
		{
			loc_min = p_min;
			loc_max = p_max;
			if (p_max < t)
			{ 
				loc_min = t;
				//loc_max = t2;
			}
		}
	}
	else
	{
		loc_min = 100000.0;
		loc_max = -100000.0;
	}
}

void dobase(in ray_t ray, in vec4 sphere, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	vec4 plane1 = vec4(0.0, 0.0, -1.0, sphere.z+5.);
	vec4 plane2 = vec4(0.0, 0.0, -1.0, sphere.z-5.);
	vec4 plane3 = vec4(0.0, -1.0, 0.0, sphere.y+22.);
	vec4 plane4 = vec4(0.0, -1.0, 0.0, sphere.y+17.);

	float det1=dot(plane1.xyz,ray.d); 
	float det2=dot(plane2.xyz,ray.d); 
	float det3=dot(plane3.xyz,ray.d); 
	float det4=dot(plane4.xyz,ray.d); 
	
	float p_min, p_max, v_min, v_max, loc_min2, loc_max2;

	float num1 = plane1.w - dot(plane1.xyz, ray.o); float curdist1 = num1/det1;
	float num2 = plane2.w - dot(plane2.xyz, ray.o); float curdist2 = num2/det2;
	float num3 = plane3.w - dot(plane3.xyz, ray.o); float curdist3 = num3/det3;
	float num4 = plane4.w - dot(plane4.xyz, ray.o); float curdist4 = num4/det4;
	
	if (abs(det1) > 0.0000001)
	{
		if (det1 > 0.0) { v_min = curdist1; loc_obj_id=obj_id; }
		if (det1 < 0.0) { v_max = curdist1; }
	}
	
	if (abs(det2) > 0.0000001)
	{
		if (det2 < 0.0) { v_min = curdist2; loc_obj_id=obj_id; }
		if (det2 > 0.0) { v_max = curdist2; }
	}

	if (abs(det3) > 0.0000001)
	{
		if (det3 > 0.0) { p_min = curdist3; loc_obj_id=obj_id; }
		if (det3 < 0.0) { p_max = curdist3; }
	}
	
	if (abs(det4) > 0.0000001)
	{
		if (det4 < 0.0) { p_min = curdist4; loc_obj_id=obj_id; }
		if (det4 > 0.0) { p_max = curdist4; }
	}
	
	float a = ray.d.x*ray.d.x + ray.d.z*ray.d.z;
	float b = 2 * ray.o.x * ray.d.x + 2 * ray.o.z * ray.d.z;
	float c = ray.o.x*ray.o.x + ray.o.z*ray.o.z - 1.*(sphere.w);

	float t = (-b - sqrt(b*b - 4.*a*c)) / (2.*a);
	float t2 = (-b + sqrt(b*b - 4.*a*c)) / (2.*a);
	
	float delta = (b*b - 4.0*a*c)/(2.*a);
	
	if (delta >= 0.)
	{
		if (v_min > t && t2 > v_max)
		{
			//kansi
			if (t2 > p_max && v_max < p_max && v_min > p_max && p_max > t)
			{
				loc_min = p_max;
				//loc_max = p_min;
			} 

			//kapeat päädyt
			if (p_max < t && v_max < t && p_min > t)
			{ 
				loc_min = t;
				//loc_max = t2;
			}

			//leveät päädyt
			else if (p_max < v_max && p_min > t && v_max < p_min)
			{ 
				loc_min = v_max;
				//loc_max = v_min;
			}
		}
	}		

	else
	{
		loc_min = 100000.0;
		loc_max = -100000.0;
	}
}

vec3 ls1;
vec4 cylinder = vec4(0.0, -7.0, 0.0, 8.);
vec4 base = vec4(0.0, -9., 0.0, 80.);
vec4 hemi1 = vec4(0.0, 16.0, 0.0, 10.);
vec4 ball1 = vec4(0.0, 0.0, 0.0, 280.0);
vec4 pl1 = vec4(0.0, -1., 0.0, 13.0);

float b1ang = 0.0;

float shoot(inout ray_t ray, out int obj_id)
{
	int loc_obj_id;
	float loc_min;
	float loc_max;

	float dist;

	obj_id = 0;
	dist = 100000.0;
	loc_min = -1000000.0;
	loc_max = 1000000.0;

	//jalusta
	dobase(ray, base, 1, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

	//varsi
	docylinder(ray, cylinder, 2, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

	//kulho
	dohemi(ray, hemi1, 3, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

	//taivas
	dosphere(ray, ball1, -1, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

	//lattia
	doplane(ray, pl1, 4, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
	
	return dist;
}

float snoise(vec3 co){
    return fract(sin(dot(co.xyz ,vec3(12.9898,78.233, 191.666))) * 43758.5453);
}


float shade(inout ray_t ray, in float dist, in int obj_id, inout vec3 outcol, inout vec3 refblendfac)
{

	if (obj_id == 0)
	{
		vec3 color;
		color = clamp(ray.d.y * 2.0, 0.0, 1.0) * vec3(0.51, 0.784, 0.98);
		outcol += color * refblendfac;


		return 0.0;
	}

	//outcol += vec3(0.0, 0.0, 1.0);
	//return 0.0;

	vec3 color;

	vec3 hp = ray.o + ray.d * dist;
	vec3 normal;
	vec3 thiscol = vec3(0.0);

	vec3 hprot = hp;

	//taivas heijastuu mutta ei näy
	if (obj_id == -1)	
	{
		float a = mod(atan(hp.x,hp.z)/(2.*PI),.5);
		
		color = texture2D(iChannel0,vec2(a,.001*(64.+hp.y))).rgb;
		//normal += (texture2D(u_blurnoise, hprot.xy*0.01+hprot.z*0.01).rgb - vec3(0.5))*0.2;
		normal = normalize(normal);

		float diffuse = 1.0;
		float specular_amount = 1.0;

		//vec3 ref_ray_d = ray.d - 2.0*dot(ray.d, normal) * normal;
		float ref_fac = pow(max(-dot(normal, ray.d), 0.0), 1.0);

		//float atten = max(0.0, 1.0 - dist * 0.0006);
		//vec3 reflection_amount = vec3(0.4) + color * 0.4;
		vec3 new_refblendfac = ref_fac * refblendfac;

		// ambient
		thiscol = color;

		//salamat vain katsomoon
		float g = mod(a,1.);
		float r1 = 1.-mod(ft + texture2D(iChannel0,vec2(.5+mod(.8*g,.5),.5+mod(.002*hp.y,.5))).b,1.);
		r1 = pow(r1,8.);
		float flash = texture2D(iChannel0,vec2(.5+mod(.8*g,.5),.5+mod(.002*hp.y,.5))).r;
		flash = 8.*pow(flash,8.) * r1;
		thiscol += vec3(flash);

		if (isPrimaryRay)
		{
			thiscol *= 0.05;
			thiscol += clamp(ray.d.y * 1.0, 0.0, 1.0) * vec3(0.51, 0.784, 0.98) * 0.3;
		}
		
		outcol += thiscol * refblendfac;
		
		//ray.d = ref_ray_d;
		//ray.o = hp;
		refblendfac = new_refblendfac;
		refblendfac = vec3(0.);
		
		return length(refblendfac);
	}
	else if (obj_id == -1)
	{
		vec3 color;
		color = clamp(ray.d.y * 1.0, 0.0, 1.0) * vec3(0.51, 0.784, 0.98) * 0.3;
		outcol += color * refblendfac;


		return 0.0;
	}
	
	//marmori
	if (obj_id == 1)
	{
		
		normal = normalize(hp - base.xyz);
		//color = vec3(0.8, 0.1, 1.0);

		color = texture2D(iChannel0,mod(vec2(normal.x,.25+normal.y),.5)).rgb;
		normal += .6*color;
		
		
		//color = vec3(0.8, 0.7, 0.2);
		
		
	}
	//varsi
	else if (obj_id == 2)
	{
		normal = normalize(hp - cylinder.xyz + .5*sin(4.*hp.y+16.*atan(hp.x,hp.z)));
		color = vec3(0.9, 0.8, 0.9);
	}
	//kulho
	else if (obj_id == 3)
	{
		normal = normalize(hp - hemi1.xyz + .5*sin(16.*atan(hp.x,hp.z)));
		color = vec3(0.8, 0.7, 0.2);
	}
	else if (obj_id == 4)
	{
		normal = -pl1.xyz;
		//color = vec3(0.5, 0.5, 0.5);
		color = vec3(0.1) + vec3(0.6) * mod(floor(hp.x * 0.5) + floor(hp.z * 0.5), 2.0);
	}
	//kulhon sisus
	else if (obj_id == 5)
	{
		normal = normalize(hp - hemi1.xyz);
		normal += (texture2D(u_blurnoise, hprot.xy*0.01+hprot.z*0.01).rgb - vec3(0.5))*0.2;
		color = vec3(0.9, 0.8, 0.3);
	}

	//normal += (texture2D(u_blurnoise, hprot.xy*0.01+hprot.z*0.01).rgb - vec3(0.5))*0.2;
	normal = normalize(normal);

	vec3 ld = ls1 - hp;
	float lightdist = length(ld);

	ld /= lightdist;

	float ld_normal_dp = dot(ld, normal);

	float diffuse = max(0.0, ld_normal_dp);

	float specular_amount = 1.0;

	
	ray_t shadowray;
	shadowray.o = hp + ld * 0.001;
	shadowray.d = ld;

	int id_unused;
	if (shoot(shadowray, id_unused) < lightdist)
	{
		diffuse = 0.0;
		specular_amount = 0.0;
	}
	
	

	vec3 ref_ray_d = ray.d - 2.0*dot(ray.d, normal) * normal;
	float ref_fac = pow(max(-dot(normal, ray.d), 0.0), 1.0);

	//float atten = max(0.0, 1.0 - dist * 0.0006);
	vec3 reflection_amount = vec3(0.4) + color * 0.4;
    vec3 new_refblendfac = ref_fac * refblendfac * reflection_amount;

 	// ambient
	thiscol += color * 0.05;
	// diffuse
	thiscol += color * diffuse * 0.9;
	// SMG lighting
	thiscol += vec3(pow(1.0 - ref_fac, 5.0) * 0.2);

	//säkenöinti
	if (obj_id != -1 && obj_id != 1 && obj_id != 4)
	{
		float a = mod(atan(hp.x,hp.z)/(2.*PI),.5);
		float g = mod(a,1.);
		float r1 = 1.-mod(ft + texture2D(iChannel0,vec2(.5+mod(.8*g,.5),.5+mod(.02*hp.y,.5))).b,1.);
		r1 = pow(r1,8.);
		float flash = texture2D(iChannel0,vec2(.5+mod(.8*g,.5),.5+mod(.002*hp.y,.5))).r;
		flash = 8.*pow(flash,8.) * r1;
		thiscol += vec3(flash);
	}
	
	outcol += thiscol * refblendfac;
	outcol += vec3(0.8) * pow(max(dot(ref_ray_d, ld), 0.0), 20.0) * specular_amount;

	ray.d = ref_ray_d;
	ray.o = hp;
	refblendfac = new_refblendfac;

	return length(refblendfac);
}

void lights(in ray_t ray, inout vec3 outcol, in float dist, in vec3 refblendfac, in float pwrbase)
{
	vec3 lsv1 = (ls1 - ray.o);
	float light_dist = length(lsv1);
	float ld1 = pow(max(0.0, dot(normalize(lsv1), ray.d)), pwrbase * light_dist);
	//if (light_dist < dist)
	//	outcol += vec3(5.0) * ld1 * refblendfac;
}


vec3 trace(in ray_t p_ray)
{
	ray_t ray;

	int obj_id;
	float dist;
	vec3 refblendfac;
	float cont;

	vec3 outcol;

	outcol = vec3(0.0);
	refblendfac = vec3(1.0);
	ray = p_ray;

	dist = shoot(ray, obj_id);
	lights(ray, outcol, dist, refblendfac, 1000.0);
	cont = shade(ray, dist, obj_id, outcol, refblendfac);

	isPrimaryRay = false;

	vec3 fuggol = vec3(0.0);
	
#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 10.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 0.0, 1.0);
	}
#endif


#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 10.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 1.0, 0.0);
	}
#endif


#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 1.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 1.0, 1.0);
	}
#endif
	//return fuggol;



/*	
	if (obj_id == 1)
		outcol = vec3(1.0, 0.0, 0.0);
	else if (obj_id == 2)
		outcol = vec3(0.0, 1.0, 0.0);
*/
	return outcol;
}


void set_scene()
{
	ls1 = vec3(0.0, 18.0, -3.0);
#if 1
	ls1.x = 25.;//sin(ft * 1.2) * 20.0;
	ls1.y = 5.;//cos(ft * 3.7912) * 5.0 - 3.0;
//	ls1.y = cos(ft * 1.7912) * 1.0 - 5.7;
	ls1.z = 25.;//cos(ft * 1.2) * 20.0;
#endif

	float floor_h = -5.9;
	if (ls1.y < floor_h)
		ls1.y = floor_h-(ls1.y-floor_h);
}


float bshape(vec2 p)
{
	vec2 q = abs(p);
	return max((q.x*0.866025+q.y*0.5),q.y);
}

mat3 lookat(vec3 p1, vec3 p2)
{
	vec3 tovec = normalize(p2 - p1);
	vec3 side = cross(tovec, vec3(0.0, -1.5, 0.0));
	vec3 up = cross(tovec, side);

	return mat3(side, up, tovec);
}

vec4 function()
{
	
	ft = motionblur(2.0);

	set_scene();

	ball1.x = sin(ft) * 3.0;
	b1ang = -(ball1.x / (3.14159 * ball1.w)) * 2.0 * 3.14159;


	mat3 camdir_mtx = mat3(1.0);

	camdir_mtx = rot_x(-0.4) * camdir_mtx;
	camdir_mtx = rot_y(cos(ft*0.96)*-0.1) * camdir_mtx;
	camdir_mtx = rot_z(sin(ft*5.3)*0.01) * camdir_mtx;



// ray setup
	ray_t tr;
	tr.o = vec3(0.0, -1.0, -13.0);

	rot = ft*0.56;
	
	tr.o.x = 1.0 + cos(ft*0.56) * 36.0;
	tr.o.y =  4.0 + 3.*sin(ft);
	tr.o.z = 1.0 + sin(ft*0.56) * 36.0;

	tr.o += sin(vec3(6.231,6.912,6.523)*ft) * 0.04;

	camdir_mtx = lookat(tr.o, vec3(0.0, 5.0, 0.0));


	//float fd1 = length(tr.o - ball5.xyz);
	//float fd2 = length(tr.o - ball1.xyz) - ball1.w * 0.9;

	float focal_z_dist = 36.;//mix(fd1, fd2, 0.5 + sin(ft * 0.742) * 0.5);


	tr.d = (vec3(uv2*1.0, 2.0));

	vec3 ray_target = tr.o + camdir_mtx * tr.d * abs(focal_z_dist / tr.d.z);

	// integration setup
	vec3 outcol = vec3(0.0);
	vec2 kpjit = vec2(0.0); 
	kpjit += (texture2D(u_blurnoise, -uvr).rg-vec2(0.5)) * 1.5;

	float accu = 0.0;

	const int kw =3;

	for (int x = 0; x < kw; x++)
	{
		for (int y = 0; y < kw; y++)
		{
			ray_t ray;

			vec2 kp = (((vec2(x,y)+kpjit+0.5) / vec2(kw, kw))-0.5)*2.0;

#if 0
			//float bf = 0.9-length(kp);
			float bf = 0.9 - bshape(kp);
			if (bf < 0.0)
				continue;
#endif
			vec2 nuv = uv2 * 0.05;

			#if 1
			nuv += kp * 0.4;
			#endif

			// rotatointiin: tee vektorit up ja left, sitten kerro nuv.x ja nuv.y niillä

			ray.o = camdir_mtx * vec3(nuv, 0.0) + tr.o;

			ray.d = normalize(ray_target - ray.o);

			//ray.d = tr.d;

			isPrimaryRay = true;

			outcol += trace(ray);
			accu += 1.0;
		}
	}

	outcol /= accu;

	//teksti
	//vec2 tuv = vec2(.5+clamp(.25 +.25*uv2.x,0.01,0.49),clamp(.25+.25*uv2.y,0.01,0.49));
	//outcol += -texture2D(iChannel0,tuv).g + 2.*texture2D(iChannel0,tuv).r;
	
	return vec4(outcol, 0.0);
}