float ft;

float PI = 3.14159265;

mat3 rot_x(float ang) { return mat3(
			1.0, 0.0, 0.0,
			0.0, cos(ang), -sin(ang),
			0.0, sin(ang), cos(ang)); }
mat3 rot_y(float ang){ return mat3(
			cos(ang), 0.0, -sin(ang),
			0.0,      1.0, 0.0,
			sin(ang), 0.0, cos(ang)); }
mat3 rot_z(float ang) { return mat3(
			cos(ang), -sin(ang), 0.0,
			sin(ang), cos(ang), 0.0,
			0.0, 0.0, 1.0); }


mat3 rx1, rx2, rx3, rx4, rx5;
mat3 ry1, ry2, ry3, ry4, ry5;
mat3 ix1, ix2, ix3, ix4, ix5;
mat3 iy1, iy2, iy3, iy4, iy5;
			
			
struct ray_t 
{
	vec3 o;
	vec3 d;
};

void doplane(in ray_t ray, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	float det=dot(plane.xyz,ray.d); 
	if (abs(det) > 0.0000001)
	{
		float num=plane.w - dot(plane.xyz, ray.o); float curdist=num/det;
		if (det > 0.0) { loc_min = curdist; loc_obj_id=obj_id; }
		if (det < 0.0) { loc_max = curdist; }
	}
}

void dosphere(in ray_t ray, in vec4 sphere, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id, inout vec3 loc_orientation)
{
	vec3 d1 = ray.o - sphere.xyz;
	float b = 2.0 * dot(ray.d, d1);
	float c = dot(d1,d1) - sphere.w*sphere.w;

	float delta = b*b - 4.0*c;

	if (delta >= 0.0)
	{
		loc_min = (-b+sqrt(delta))/ (2.0);
		loc_max= (-b-sqrt(delta))/ (2.0);

		loc_orientation = vec3(loc_max);
		
		loc_obj_id = obj_id;
	}
	else
	{
		loc_min = 100000.0;
		loc_max = -100000.0;
	}
}

void doring(in ray_t ray, mat3 i1, mat3 i2, in vec4 ring, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id, inout vec3 loc_surface, inout vec3 loc_orientation)
{
	vec4 planea = plane + vec4(0.,0.,0.,1.);
	vec4 planeb = plane - vec4(0.,0.,0.,1.);

	float det3=dot(planea.xyz,ray.d); 
	float det4=dot(planeb.xyz,ray.d); 
	
	float p_min, p_max, v_min, v_max, loc_min2, loc_max2;

	float num3 = planea.w - dot(planea.xyz, ray.o); float curdist3 = num3/det3;
	float num4 = planeb.w - dot(planeb.xyz, ray.o); float curdist4 = num4/det4;
	

	if (abs(det3) > 0.0000001)
	{
		if (det3 > 0.0) { p_min = curdist3; }
		if (det3 < 0.0) { p_max = curdist3; }
	}
	
	if (abs(det4) > 0.0000001)
	{
		if (det4 < 0.0) { p_min = curdist4; }
		if (det4 > 0.0) { p_max = curdist4; }
	}

	ray_t r = ray;
	
	ray.o.xyz = i2 * ray.o.xyz;
	ray.o.xyz = i1 * ray.o.xyz;
	ray.d.xyz = i2 * ray.d.xyz;
	ray.d.xyz = i1 * ray.d.xyz;
	
	
	float a1 = ray.d.x*ray.d.x + ray.d.z*ray.d.z;
	float b1 = 2 * ray.o.x * ray.d.x + 2 * ray.o.z * ray.d.z;
	float c1 = ray.o.x*ray.o.x + ray.o.z*ray.o.z - 1.*(ring.w);
	float t11 = (-b1 - sqrt(b1*b1 - 4.*a1*c1)) / (2.*a1);
	float t12 = (-b1 + sqrt(b1*b1 - 4.*a1*c1)) / (2.*a1);
	float delta1 = (b1*b1 - 4.0*a1*c1)/(2.*a1);

	if (delta1 >= 0. && p_min > t11 && t12 > p_max)
	{

		ring.w -= 15.;
		float a2 = ray.d.x*ray.d.x + ray.d.z*ray.d.z;
		float b2 = 2 * ray.o.x * ray.d.x + 2 * ray.o.z * ray.d.z;
		float c2 = ray.o.x*ray.o.x + ray.o.z*ray.o.z - 1.*(ring.w);
		float t21 = (-b2 + sqrt(b2*b2 - 4.*a2*c2)) / (2.*a2);
		float t22 = (-b2 - sqrt(b2*b2 - 4.*a2*c2)) / (2.*a2);
		float delta2 = (b2*b2 - 4.0*a2*c2)/(2.*a2);
		
		//if (delta1 >= 0.)
		//{ 
			if (t12 > p_max &&  p_max > t11)
			{ 
				if (t22 < p_max &&  p_max < t21 )
				{
					if (p_min > t21) 
					{
						loc_min = t21; 	//sisäreuna
						loc_obj_id=obj_id+1;
						loc_surface = ring.xyz;
					}
					} else 
					{
						loc_min = p_max;	//pinta		
						loc_obj_id=obj_id+2; 
						loc_surface = plane.xyz;
					}
				} 
			else 
			{
			loc_min = t11;	//ulkoreuna		
			loc_obj_id=obj_id; 
			loc_surface = ring.xyz;
			}
		//}
	loc_orientation = ray.o + ray.d * loc_min;
	if (loc_min == t21) 
	{
		ray.o = -ray.o;
		ray.d = -ray.d;
		loc_orientation = ray.o + ray.d * loc_min;
		
	}
	}		

	else
	{
		loc_min = 100000.0;
		loc_max = -100000.0;
	}
	

	ray = r;
	
}

vec3 ls1;

vec4 naama = vec4(0.0, 0.0, 0.0, 5.);

vec4 ring1 = vec4(0.0, 0.0, 0.0, 140.);
vec4 ring2 = vec4(0.0, 0.0, 0.0, 118.);
vec4 ring3 = vec4(0.0, 0.0, 0.0, 93.);
vec4 ring4 = vec4(0.0, 0.0, 0.0, 71.);
vec4 ring5 = vec4(0.0, 0.0, 0.0, 49.);

vec4 plane1 = vec4(0.0, -1., 0.0, 0.0);
vec4 plane2 = vec4(0.0, -1., 0.0, 0.0);
vec4 plane3 = vec4(0.0, -1., 0.0, 0.0);
vec4 plane4 = vec4(0.0, -1., 0.0, 0.0);
vec4 plane5 = vec4(0.0, -1., 0.0, 0.0);

vec3 null = vec3(0.0);
vec3 surface;
vec3 orientation;	

mat3 cam;

vec4 pl1 = vec4(0.0, -1.0, 0.0, 12.0);


float shoot(inout ray_t ray, out int obj_id)
{
	int loc_obj_id;
	float loc_min;
	float loc_max;

	vec3 loc_surface;
	vec3 loc_orientation;
	
	float dist;

	obj_id = 0;
	dist = 100000.0;
	loc_min = -1000000.0;
	loc_max = 1000000.0;
	loc_surface = null;
	loc_orientation = null;

	doplane(ray, pl1, 2, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

	
	doring(ray, ix1, iy1, ring1, plane1, 3, loc_min, loc_max, loc_obj_id, loc_surface, loc_orientation);
	if (loc_min < dist && loc_min > 0.0) 
	{ 
		dist = loc_min; 
		obj_id = loc_obj_id; 
		surface = loc_surface;
		orientation = loc_orientation;
	}
 
 	doring(ray, ix2, iy2, ring2, plane2, 3, loc_min, loc_max, loc_obj_id, loc_surface, loc_orientation);
	if (loc_min < dist && loc_min > 0.0) 
	{ 
		dist = loc_min; 
		obj_id = loc_obj_id; 
		surface = loc_surface;
		orientation = loc_orientation;
	}
 
  	doring(ray, ix3, iy3, ring3, plane3, 3, loc_min, loc_max, loc_obj_id, loc_surface, loc_orientation);
	if (loc_min < dist && loc_min > 0.0) 
	{ 
		dist = loc_min; 
		obj_id = loc_obj_id; 
		surface = loc_surface;
		orientation = loc_orientation;
	}
 
	doring(ray, ix4, iy4, ring4, plane4, 3, loc_min, loc_max, loc_obj_id, loc_surface, loc_orientation);
	if (loc_min < dist && loc_min > 0.0) 
	{ 
		dist = loc_min; 
		obj_id = loc_obj_id; 
		surface = loc_surface;
		orientation = loc_orientation;
	}

	doring(ray, ix5, iy5, ring5, plane5, 3, loc_min, loc_max, loc_obj_id, loc_surface, loc_orientation);
	if (loc_min < dist && loc_min > 0.0) 
	{ 
		dist = loc_min; 
		obj_id = loc_obj_id; 
		surface = loc_surface;
		orientation = loc_orientation;
	}

	dosphere(ray, naama, 1, loc_min, loc_max, loc_obj_id, loc_orientation);
	if (loc_min < dist && loc_min > 0.0) 
	{ 
		dist = loc_min; 
		obj_id = loc_obj_id; 
		orientation = loc_orientation;
	}

	
	return dist;
}

float snoise(vec3 co){
    return fract(sin(dot(co.xyz ,vec3(12.9898,78.233, 191.666))) * 43758.5453);
}


float shade(inout ray_t ray, in float dist, in int obj_id, inout vec3 outcol, inout vec3 refblendfac)
{

	if (obj_id == 0)
	{
		vec3 color;
		color = clamp(ray.d.y * 2.0, 0.0, 1.0) * vec3(0.51, 0.784, 0.98);
		outcol += color * refblendfac;


		return 0.0;
	}

	vec3 color;

	vec3 hp;
	vec3 normal;
	vec3 thiscol = vec3(0.0);

	vec3 hprot = hp;

	//naama
	if (obj_id == 1)
	{
		color = vec3(.5);
		ray.o = -ray.o;
		ray.d = -ray.d;
		hp = -ray.o + ray.d * -dist;
		//normal = normalize(hp - naama.xyz);
		normal = normalize(hp - naama.xyz + .6*sin(2.*hp.y+4.*atan(hp.x,hp.z)/(PI)));
		
		vec3 hk = ray.o + ray.d * orientation;
		hk = hk*cam;
		
		vec2 h = vec2(.05*ft + .01*hk.x, .5 + .05*hp.y);
		vec3 c1 = texture2D(iChannel0,h.xy).rgb;
		color = 4.*c1;

	}
	//lattia
	else if (obj_id == 2)
	{
		hp = ray.o + ray.d * dist;
		normal = -pl1.xyz;
		float r = .5*length(hp.xz) + 4.*ft;
		//color = vec3(0.5, 0.5, 0.5);
		float u = hp.x*cos(r) - hp.z*sin(r);
		float v = hp.z*cos(r) + hp.x*sin(r);	
		
		color = vec3(0.1) + vec3(0.6) * mod(floor(u * 0.01) + floor(v * 0.01), 2.0);
	}
	//renkaat
	else if (obj_id > 2)
	{
		color = vec3(0.1, 0.1, 0.3);
		//ulkoreuna
		if (obj_id == 3) 
		{
			hp = orientation;
			normal = normalize(hp - surface.xyz);
			//hp *= rx1;
			//hp *= ry1; 
			float a = atan(hp.x,hp.z)/(2.*PI); 
			float d = length(vec2(-1.+mod(64.*a, 2.),hp.y));
			if (d < .4) 
			{
				color = 8.*vec3(1.);
			}
		}

		//sisäreuna
		if (obj_id == 4)
		{
			hp = orientation;
			color = vec3(.1);
			normal = -normalize(hp - surface.xyz);
		}
	
		//pinta
		if (obj_id == 5)
		{
			hp = orientation;
			color = vec3(.5) + 2. * vec3(abs(-1. + mod(32.*atan(hp.x,hp.z)/PI,2.)));
			color = color*color;
			normal = normalize(hp - surface.xyz);
		}
	}

	normal += (texture2D(u_blurnoise, hprot.xy*0.01+hprot.z*0.01).rgb - vec3(0.5))*0.2;
	normal = normalize(normal);

	vec3 ld = ls1 - hp;
	float lightdist = length(ld);

	ld /= lightdist;

	float ld_normal_dp = dot(ld, normal);

	float diffuse = max(0.0, ld_normal_dp);

	float specular_amount = 1.0;

	ray_t shadowray;
	shadowray.o = hp + ld * 0.001;
	shadowray.d = ld;

	int id_unused;
	if (shoot(shadowray, id_unused) < lightdist)
	{
		diffuse = 0.0;
		specular_amount = 0.0;
	}

	vec3 ref_ray_d = ray.d - 2.0*dot(ray.d, normal) * normal;
	float ref_fac = pow(max(-dot(normal, ray.d), 0.0), 1.0);

	//float atten = max(0.0, 1.0 - dist * 0.0006);
	vec3 reflection_amount = vec3(0.4) + color * 0.4;
    vec3 new_refblendfac = ref_fac * refblendfac * reflection_amount;

 	// ambient
	thiscol += color * 0.05;
	// diffuse
	thiscol += color * diffuse * 0.9;
	// SMG lighting
	thiscol += vec3(pow(1.0 - ref_fac, 5.0) * 0.2);

	outcol += thiscol * refblendfac;
	outcol += vec3(0.8) * pow(max(dot(ref_ray_d, ld), 0.0), 20.0) * specular_amount;

	ray.d = ref_ray_d;
	ray.o = hp;
	refblendfac = new_refblendfac;

	return length(refblendfac);
}

void lights(in ray_t ray, inout vec3 outcol, in float dist, in vec3 refblendfac, in float pwrring1)
{
	vec3 lsv1 = (ls1 - ray.o);
	float light_dist = length(lsv1);
	float ld1 = pow(max(0.0, dot(normalize(lsv1), ray.d)), pwrring1 * light_dist);
	//if (light_dist < dist)
	//	outcol += vec3(5.0) * ld1 * refblendfac;
}


vec3 trace(in ray_t p_ray)
{
	ray_t ray;

	int obj_id;
	float dist;
	vec3 refblendfac;
	float cont;

	vec3 outcol;

	outcol = vec3(0.0);
	refblendfac = vec3(1.0);
	ray = p_ray;

	dist = shoot(ray, obj_id);
	
	lights(ray, outcol, dist, refblendfac, 1000.0);
	cont = shade(ray, dist, obj_id, outcol, refblendfac);

	vec3 fuggol = vec3(0.0);

#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 10.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 0.0, 1.0);
	}
#endif
#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 10.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 1.0, 0.0);
	}
#endif
/*
#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 1.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 1.0, 1.0);
	}
#endif
*/
	//return fuggol;



/*	
	if (obj_id == 1)
		outcol = vec3(1.0, 0.0, 0.0);
	else if (obj_id == 2)
		outcol = vec3(0.0, 1.0, 0.0);
*/
	return outcol;
}


void set_scene()
{
	ls1 = vec3(0.0, 0.0, 0.0);
#if 1
/*
	ls1.x = sin(ft * 1.2) * 10.0;
	ls1.y = cos(ft * 3.7912) * 5.0 - 3.0;
//	ls1.y = cos(ft * 1.7912) * 1.0 - 5.7;
	ls1.z = cos(ft * 1.2) * 10.0;
	*/
#endif

	float floor_h = -5.9;
	if (ls1.y < floor_h)
		ls1.y = floor_h-(ls1.y-floor_h);
}


float bshape(vec2 p)
{
	vec2 q = abs(p);
	return max((q.x*0.866025+q.y*0.5),q.y);
}

mat3 lookat(vec3 p1, vec3 p2)
{
	vec3 tovec = normalize(p2 - p1);
	vec3 side = cross(tovec, vec3(0.0, -1.0, 0.0));
	vec3 up = cross(tovec, side);

	return mat3(side, up, tovec);
}

vec4 function()
{
	ft = motionblur(2.0);
	
	
	set_scene();

	mat3 camdir_mtx = mat3(1.0);

	camdir_mtx = rot_x(-0.4) * camdir_mtx;
	camdir_mtx = rot_y(cos(ft*0.96)*-0.1) * camdir_mtx;
	camdir_mtx = rot_z(sin(ft*5.3)*0.01) * camdir_mtx;

	
// ray setup
	ray_t tr;
	tr.o = vec3(0.0, -1.0, -13.0);

	tr.o.x = 5.0 + cos(ft*0.74) * 26.0;
	tr.o.y = 5.+sin(ft*0.6623) * 5.0;
	tr.o.z = 4.0 + sin(ft*0.74) * 28.0;

	tr.o += sin(vec3(6.231,6.912,6.523)*ft) * 0.04;

	camdir_mtx = lookat(tr.o, vec3(3.0, 0.0, 0.0));

	cam = camdir_mtx;
	
	float fd1 = length(tr.o - naama.xyz);
	//float fd2 = length(tr.o - ballposses[1].xyz) - ballposses[1].w * 0.9;

	float focal_z_dist = fd1;//mix(fd1, fd2, 0.5 + sin(ft * 0.742) * 0.5);

	float rx = .6*ft;
	float ry = .51*ft;
	
	rx1 = rot_x(2.6*rx);
	rx2 = rot_x(2.2*rx);
	rx3 = rot_x(1.8*rx);
	rx4 = rot_x(1.4*rx);
	rx5 = rot_x(1.0*rx);
	
	ry1 = rot_z(2.6*ry);
	ry2 = rot_z(2.2*ry);
	ry3 = rot_z(1.8*ry);
	ry4 = rot_z(1.4*ry);
	ry5 = rot_z(1.0*ry);
	
	ix1 = rot_x(2.6*-rx);
	ix2 = rot_x(2.2*-rx);
	ix3 = rot_x(1.8*-rx);
	ix4 = rot_x(1.4*-rx);
	ix5 = rot_x(1.0*-rx);
	 
	iy1 = rot_z(2.6*-ry);
	iy2 = rot_z(2.2*-ry);
	iy3 = rot_z(1.8*-ry);
	iy4 = rot_z(1.4*-ry);
	iy5 = rot_z(1.0*-ry);
	
	ring1.xyz = rx1 * ring1.xyz;
	ring1.xyz = ry1 * ring1.xyz;
	plane1.xyz = rx1 * plane1.xyz;
	plane1.xyz = ry1 * plane1.xyz;

	ring2.xyz = rx2 * ring2.xyz;
	ring2.xyz = ry2 * ring2.xyz;
	plane2.xyz = rx2 * plane2.xyz;
	plane2.xyz = ry2 * plane2.xyz;

	ring3.xyz = rx3 * ring3.xyz;
	ring3.xyz = ry3 * ring3.xyz;
	plane3.xyz = rx3 * plane3.xyz;
	plane3.xyz = ry3 * plane3.xyz;

	ring4.xyz = rx4 * ring4.xyz;
	ring4.xyz = ry4 * ring4.xyz;
	plane4.xyz = rx4 * plane4.xyz;
	plane4.xyz = ry4 * plane4.xyz;

	ring5.xyz = rx5 * ring5.xyz;
	ring5.xyz = ry5 * ring5.xyz;
	plane5.xyz = rx5 * plane5.xyz;
	plane5.xyz = ry5 * plane5.xyz;

	tr.d = (vec3(uv2*1.0, 2.0));

	vec3 ray_target = tr.o + camdir_mtx * tr.d * abs(focal_z_dist / tr.d.z);

	// integration setup
	vec3 outcol = vec3(0.0);
	vec2 kpjit = vec2(0.0);
	kpjit += (texture2D(u_blurnoise, -uvr).rg-vec2(0.5)) * 1.5;

	float accu = 0.0;

	const int kw = 2;

	for (int x = 0; x < kw; x++)
	{
		for (int y = 0; y < kw; y++)
		{
			ray_t ray;

			vec2 kp = (((vec2(x,y)+kpjit+0.5) / vec2(kw, kw))-0.5)*2.0;

#if 0
			//float bf = 0.9-length(kp);
			float bf = 0.9 - bshape(kp);
			if (bf < 0.0)
				continue;
#endif
			vec2 nuv = uv2 * 0.05;

			#if 1
			nuv += kp * 0.4;
			#endif

			// rotatointiin: tee vektorit up ja left, sitten kerro nuv.x ja nuv.y niillä

			ray.o = camdir_mtx * vec3(nuv, 0.0) + tr.o;

			ray.d = normalize(ray_target - ray.o);

			//ray.d = tr.d;


			outcol += trace(ray);
			accu += 1.0;
		}
	}

	outcol /= accu;
	
	outcol = 2.*outcol*outcol;
	
	return vec4(outcol, 0.0);
}