float ft;
float PI = 3.14159265;

mat3 rot_x(float ang) { return mat3(
			1.0, 0.0, 0.0,
			0.0, cos(ang), -sin(ang),
			0.0, sin(ang), cos(ang)); }
mat3 rot_y(float ang){ return mat3(
			cos(ang), 0.0, -sin(ang),
			0.0,      1.0, 0.0,
			sin(ang), 0.0, cos(ang)); }
mat3 rot_z(float ang) { return mat3(
			cos(ang), -sin(ang), 0.0,
			sin(ang), cos(ang), 0.0,
			0.0, 0.0, 1.0); }

struct ray_t 
{
	vec3 o;
	vec3 d;
};

void doplane(in ray_t ray, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	//rX(ray.d,PI/2.);
	//ray.d.y -= 15.;
	//ray.d = vec3(ray.d.y, ray.d.x, ray.d.z);
	
	float det=dot(plane.xyz,ray.d); 
	if (abs(det) > 0.0000001)
	{
		float num=plane.w - dot(plane.xyz, ray.o); float curdist=num/det;
		if (det > 0.0) { loc_min = curdist; loc_obj_id=obj_id; }
		if (det < 0.0) { loc_max = curdist; }
	}
}

#if 0
void doplane_csg(in ray_t ray, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	float det=dot(plane.xyz,ray.d); 
	if (abs(det) > 0.0000001)
	{
		float num=plane.w - dot(plane.xyz, ray.o); float curdist=num/det;
		if (det > 0.0 && curdist > loc_min) { loc_min = curdist; loc_obj_id=obj_id; }
		if (det < 0.0 && curdist < loc_max) { loc_max = curdist; }
	}
}
#endif

void dosphere(in ray_t ray, in vec4 sphere, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	vec3 d1 = ray.o - sphere.xyz;
	float b = 2.0 * dot(ray.d, d1);
	float c = dot(d1,d1) - sphere.w*sphere.w;

	float delta = b*b - 4.0*c;

	if (delta >= 0.0)
	{
		loc_min = (-b-sqrt(delta))/ (2.0);
		loc_max= (-b+sqrt(delta))/ (2.0);

		loc_obj_id = obj_id;
	}
	else
	{
		loc_min = 100000.0;
		loc_max = -100000.0;
	}
}


void docylinder(in ray_t ray, in vec4 sphere, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	//sphere.w += 32.*cos(4.*atan(ray.d.z,ray.d.x));	//vääristymähack
	vec2 d1 = ray.o.xz;
	float b = 2. * dot(ray.d.xz, d1);
	float c = dot(ray.d.xz,ray.d.xz) - sphere.w*sphere.w;
	
	float delta = b*b - 4.0*c;
	
	if (delta >= 0.0)
	{
		loc_min = (-b+sqrt(delta))/ (2.0);
		loc_max= (-b-sqrt(delta))/ (2.0);

		loc_obj_id = obj_id;
	}
	else
	{
		loc_min = 100000.0;
		loc_max = -100000.0;
	}
}

vec3 ls1;
vec4 cylinder = vec4(0.0, 0.0, 0.0, 500.0);
vec4 ball1 = vec4(-3.0, 0.0, 0.0, 6.0);
vec4 ball2 = vec4(6.0, 0.0, -15.0, 6.0);
vec4 ball3 = vec4(0.0, -5.0, -7.0, 1.0);
vec4 ball4 = vec4(3.0, -4.5, -6.0, 1.5);
vec4 ball5 = vec4(2.0, -5.5, -8.0, 0.5);
vec4 pl1 = vec4(0.0, -1.0, 0.0, 6.0);

float b1ang = 0.0;


float shoot(inout ray_t ray, out int obj_id)
{
	int loc_obj_id;
	float loc_min;
	float loc_max;

	float dist;

	obj_id = 0;
	dist = 100000.0;
	loc_min = -1000000.0;
	loc_max = 1000000.0;


	
	dosphere(ray, ball1, 1, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
	dosphere(ray, ball2, 2, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
	dosphere(ray, ball3, 3, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
	dosphere(ray, ball4, 4, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
	dosphere(ray, ball5, 5, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
	doplane(ray, pl1, 6, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
	
	if (ray.d.y > 0. && obj_id == 0)
	{
		docylinder(ray, cylinder, -1, loc_min, loc_max, loc_obj_id);
		if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
	}
	
	return dist;
}

float snoise(vec3 co){
    return fract(sin(dot(co.xyz ,vec3(12.9898,78.233, 191.666))) * 43758.5453);
}


float shade(inout ray_t ray, in float dist, in int obj_id, inout vec3 outcol, inout vec3 refblendfac)
{

	if (obj_id == 0)
	{
		vec3 color;
		color = clamp(ray.d.y * 2.0, 0.0, 1.0) * vec3(0.51, 0.784, 0.98);
		outcol += color * refblendfac;

		return 0.0;
	}

	//outcol += vec3(0.0, 0.0, 1.0);
	//return 0.0;

	vec3 color;

	vec3 hp = ray.o + ray.d * dist;
	vec3 normal;
	vec3 thiscol = vec3(0.0);

	vec3 hprot = hp;

	if (obj_id == -1)	//katsomo
	{
		float a = mod(atan(hp.x,hp.z)/(.666*PI),1.);
		float gr = clamp(.01*(450.-hp.y),0.,1.);
		color = gr*texture2D(iChannel0,vec2(a,.0016*(5.+hp.y))).rgb;
		//normal += (texture2D(u_blurnoise, hprot.xy*0.01+hprot.z*0.01).rgb - vec3(0.5))*0.2;
		normal = normalize(normal);

		float diffuse = 1.0;
		float specular_amount = 1.0;

		//vec3 ref_ray_d = ray.d - 2.0*dot(ray.d, normal) * normal;
		float ref_fac = pow(max(-dot(normal, ray.d), 0.0), 1.0);

		//float atten = max(0.0, 1.0 - dist * 0.0006);
		//vec3 reflection_amount = vec3(0.4) + color * 0.4;
		vec3 new_refblendfac = ref_fac * refblendfac;

		// ambient
		thiscol = color;

		//jumbotron
		if (a > .64 && a < .855 && hp.y > 113. && hp.y < 198.) 
		{	
			vec2 jtu = (vec2(a, hp.y) - vec2(0.64, 113.0));
			jtu /= vec2(.855-.64, 198.0-113.0);
			//thiscol += vec3(sin(ft+65.*a)*cos(ft+.1*hp.y));
			thiscol = texture2D(iChannel1, jtu).rgb;
			//thiscol.r = jtu.y;
		} else
		{
			float g = mod(a + .1,.5);//atan(hp.x,hp.z);
			
			//salamat vain katsomoon
			if (g  > .2 && hp.y < 165. && hp.y > 20.)
			{
				g = mod(a,1.);
				float r1 = 1.-mod(-a+.02*+hp.y+1.*ft,1.);
				r1 = pow(r1,16.);
				float flash = texture2D(iChannel0,vec2(mod(.8*g,1.),1.-mod(.001*hp.y,.5))).r;
				flash = 8.*pow(flash,8.) * r1;
				thiscol += vec3(flash);
			}
		}
		
		outcol += thiscol * refblendfac;
		
		//ray.d = ref_ray_d;
		//ray.o = hp;
		refblendfac = new_refblendfac;
		refblendfac = vec3(0.);
		
		return length(refblendfac);
	}
	
	else if (obj_id == 1)
	{
		normal = normalize(hp - ball1.xyz);
		color = vec3(0.8, 0.1, 1.0);


		hprot -= ball1.xyz;
		float ang = b1ang;
		mat2 rot2d = mat2(sin(ang), cos(ang),-cos(ang),sin(ang));
		hprot.xy = rot2d * hprot.xy;
		hprot += ball1.xyz;

	}
	else if (obj_id == 2)
	{
		normal = normalize(hp - ball2.xyz);
		color = vec3(0.2, 0.5, 0.9);


	}
	else if (obj_id == 3)
	{
		normal = normalize(hp - ball3.xyz);
		color = vec3(0.2, 0.7, 0.9);
	}
	else if (obj_id == 4)
	{
		normal = normalize(hp - ball4.xyz);
		color = vec3(0.3, 0.6, 0.4);

		hprot -= ball4.xyz;
		float ang = ft * -0.65;
		mat2 rot2d = mat2(sin(ang), cos(ang),-cos(ang),sin(ang));
		hprot.xz = rot2d * hprot.xz;

		color *= 0.5 + sin(atan(hprot.x, hprot.z) * 20.0) * 0.5;
		//color += vec3(0.2, 0.05, 0.3) * (0.5 + sin(atan(hprot.x, hprot.y) * 20.0) * 0.5) * 9.0;

		hprot += ball4.xyz;

	}
	else if (obj_id == 5)
	{
		normal = normalize(hp - ball5.xyz);
		color = vec3(0.3, 0.8, 0.6);
	}
	else if (obj_id == 6)
	{
		normal = -pl1.xyz;
		//color = vec3(0.5, 0.5, 0.5);
		color = vec3(0.1) + vec3(0.6) * mod(floor(hp.x * 0.5) + floor(hp.z * 0.5), 2.0);
	}

	normal += (texture2D(u_blurnoise, hprot.xy*0.01+hprot.z*0.01).rgb - vec3(0.5))*0.2;
	normal = normalize(normal);

	vec3 ld = ls1 - hp;
	float lightdist = length(ld);

	ld /= lightdist;

	float ld_normal_dp = dot(ld, normal);

	float diffuse = max(0.0, ld_normal_dp);

	float specular_amount = 1.0;

	ray_t shadowray;
	shadowray.o = hp + ld * 0.001;
	shadowray.d = ld;

	int id_unused;
	if (shoot(shadowray, id_unused) < lightdist)
	{
		diffuse = 0.0;
		specular_amount = 0.0;
	}

	vec3 ref_ray_d = ray.d - 2.0*dot(ray.d, normal) * normal;
	float ref_fac = pow(max(-dot(normal, ray.d), 0.0), 1.0);

	//float atten = max(0.0, 1.0 - dist * 0.0006);
	vec3 reflection_amount = vec3(0.4) + color * 0.4;
    vec3 new_refblendfac = ref_fac * refblendfac * reflection_amount;

 	// ambient
	thiscol += color * 0.05;
	// diffuse
	thiscol += color * diffuse * 0.9;
	// SMG lighting
	thiscol += vec3(pow(1.0 - ref_fac, 5.0) * 0.2);

	outcol += thiscol * refblendfac;
	outcol += vec3(0.8) * pow(max(dot(ref_ray_d, ld), 0.0), 20.0) * specular_amount;

	ray.d = ref_ray_d;
	ray.o = hp;
	refblendfac = new_refblendfac; 

	return length(refblendfac);
}

void lights(in ray_t ray, inout vec3 outcol, in float dist, in vec3 refblendfac, in float pwrbase)
{
	vec3 lsv1 = (ls1 - ray.o);
	float light_dist = length(lsv1);
	float ld1 = pow(max(0.0, dot(normalize(lsv1), ray.d)), pwrbase * light_dist);
	if (light_dist < dist)
		outcol += vec3(5.0) * ld1 * refblendfac;
}


vec3 trace(in ray_t p_ray)
{
	ray_t ray;

	int obj_id;
	float dist;
	vec3 refblendfac;
	float cont;

	vec3 outcol;

	outcol = vec3(0.0);
	refblendfac = vec3(1.0);
	ray = p_ray;

	dist = shoot(ray, obj_id);
	lights(ray, outcol, dist, refblendfac, 1000.0);
	cont = shade(ray, dist, obj_id, outcol, refblendfac);

	vec3 fuggol = vec3(0.0);

#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 10.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 0.0, 1.0);
	}
#endif
#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 10.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 1.0, 0.0);
	}
#endif

#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 1.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 1.0, 1.0);
	}
#endif
	//return fuggol;



/*	
	if (obj_id == 1)
		outcol = vec3(1.0, 0.0, 0.0);
	else if (obj_id == 2)
		outcol = vec3(0.0, 1.0, 0.0);
*/
	return outcol;
}


void set_scene()
{
	ls1 = vec3(0.0, 18.0, -3.0);
#if 1
	ls1.x = sin(ft * 1.2) * 20.0;
	ls1.y = cos(ft * 3.7912) * 9.0 - 6.0;
//	ls1.y = cos(ft * 1.7912) * 1.0 - 5.7;
	ls1.z = 10.0 + cos(ft * 1.2) * 20.0;
#endif

	float floor_h = -5.9;
	if (ls1.y < floor_h)
		ls1.y = floor_h-(ls1.y-floor_h);
}


float bshape(vec2 p)
{
	vec2 q = abs(p);
	return max((q.x*0.866025+q.y*0.5),q.y);
}

mat3 lookat(vec3 p1, vec3 p2)
{
	vec3 tovec = normalize(p2 - p1);
	vec3 side = cross(tovec, vec3(0.0, -1.0, 0.0));
	vec3 up = cross(tovec, side);

	return mat3(side, up, tovec);
}

vec4 function()
{
	ft = motionblur(2.0);

	set_scene();

	ball1.x = sin(ft) * 10.0;
	b1ang = -(ball1.x / (3.14159 * ball1.w)) * 2.0 * 3.14159;

	float camjitter = 1.0;
	camjitter += abs(cos(ft)) * 5.0;

	mat3 camdir_mtx = mat3(1.0);

	camdir_mtx = rot_x(-0.4) * camdir_mtx;
	camdir_mtx = rot_y(cos(ft*0.96)*-0.1) * camdir_mtx;
	camdir_mtx = rot_z(sin(ft*5.3)*0.01) * camdir_mtx;



// ray setup
	ray_t tr;
	tr.o = vec3(0.0, -1.0, -13.0);

	float fta = ft;
	tr.o.x = 1.0 + 10.*cos(fta*0.36) * 6.0 * 1.0;
	tr.o.y = 5.+sin(fta*0.6623) * 5.0;
	tr.o.z = 1.0 + 10.*sin(fta*0.36) * 5.0 * 1.0;

	tr.o = mix(tr.o, ball1.xyz, 0.5);

	tr.o += sin(vec3(6.231,6.912,6.523)*ft) * 0.04;
	tr.o += sin(vec3(36.231,36.912,36.523)*ft) * 0.01 * camjitter;

	vec3 camt = ball1.xyz;
	camt.y = 5.0 + sin(ft) * 5.0;
	camt += sin(vec3(36.231,36.912,36.523)*ft) * 0.01 * camjitter;

	camdir_mtx = lookat(tr.o, camt);

	float fd1 = length(tr.o - ball1.xyz) - ball1.w * 0.9;

	float fzmix = pow(0.5 + cos(ft * 0.742) * 0.5, 2.0);
	float focal_z_dist = mix(fd1, 200.0, fzmix);


//	float fd2 = length(tr.o - ball2.xyz) - ball2.w * 0.9;
//	focal_z_dist = mix(fd2, focal_z_dist, clamp(fd2*0.1-1.0, 0.0, 1.0));


	tr.d = (vec3(uv2*1.0, 2.0));

	vec3 ray_target = tr.o + camdir_mtx * tr.d * abs(focal_z_dist / tr.d.z);

	// integration setup
	vec3 outcol = vec3(0.0);
	vec2 kpjit = vec2(0.0); 
	kpjit += (texture2D(u_blurnoise, -uvr).rg-vec2(0.5)) * 1.5;

	float accu = 0.0;

	const int kw =3;

	for (int x = 0; x < kw; x++)
	{
		for (int y = 0; y < kw; y++)
		{
			ray_t ray;

			vec2 kp = (((vec2(x,y)+kpjit+0.5) / vec2(kw, kw))-0.5)*2.0;

#if 0
			//float bf = 0.9-length(kp);
			float bf = 0.9 - bshape(kp);
			if (bf < 0.0)
				continue;
#endif
			vec2 nuv = uv2 * 0.05;

			#if 1
			nuv += kp * 0.4;
			#endif

			// rotatointiin: tee vektorit up ja left, sitten kerro nuv.x ja nuv.y niillä

			ray.o = camdir_mtx * vec3(nuv, 0.0) + tr.o;

			ray.d = normalize(ray_target - ray.o);

			//ray.d = tr.d;


			outcol += trace(ray);
			accu += 1.0;
		}
	}

	outcol /= accu;
	//outcol = texture2D(iChannel0,uv2).rgb;
	
	
	return vec4(outcol, 0.0);
}