float PI = 3.14159265;
float ft;

void rd(inout vec2 p, float a) 
	{
        float c,s;
		vec2 q=p;
        c = cos(a); s = sin(a);
        p.y = c * q.y - s * q.x;
        p.x = s * q.y + c * q.x;
	}

float f(vec3 o)
{
	o*=5.;
	o.z-=12.;

	if (o.x < 0.)		 //emmehän halua peilikuvaa
	{
		o.z = -o.z;
		o.x *= .75;
		o.y *= 1.1;
	}
	vec2 coord = .125*o.xy;

	float dist = 1.;

	float x0=.2*o.z;
	float y0=sin(ft+1.3*o.z);

	float i = 0.;
	float m = 4.;
	float zx = coord.x;
	float zy = coord.y;
	float sr = .7;
	float zt = 40.;

	//based on https://softologyblog.wordpress.com/2011/02/01/orbit-traps/
	
	while ( zx*zx + zy*zy < (2.)  &&  i < m)
	{
		float xtemp = zx*zx - zy*zy + x0;
		zy = 2.*zx*zy + y0;
		zx = xtemp;
		if (  abs(sqrt((zy*zy)+(zx*zx) ) - sr) < .23 && i > 1.)
		{
			zt=sqrt(zt)+(1.-abs(sqrt((zy*zy)+(zx*zx))-sqrt((x0*x0)+(y0*y0)))/sr);
		}
		i++;
	}
		return zt;
	}

vec3 rm(inout vec3 p, inout vec3 d, float s, float t, int n)	
{
	vec3 q = p;
	float l=1.;
	for (int i = 0; i < 64 && l >.1; i +=1 )
	{
			l=abs(f(p));
			p+=l*d;
	}

	float c = 1.+length(q-p);
	c = .015*c*c;
	
	return vec3(c);
}

vec4 function()
{
	ft = motionblur(4.0);

	vec2 p = uv2 *.5 + vec2(0.0, 0.0);
	vec2 uv2 = vec2(.5*p.x,p.y) + vec2(.75,0.5);
	
	//zoomaus & pyöritys
	p *= 1.+.1*sin(ft);
	rd(p,.1*sin(ft));
	
	vec2 uv = vec2(.5*p.x,p.y) + vec2(.25,0.5);
	
	vec3 o= vec3(p.x,p.y,-1.+ mod(100.*ft,.2));
	vec3 d= vec3(p.x,p.y*.7+.03,.7)/256.;

	vec4 jd = vec4(1.,1.,1.,0.);
	if (abs(p.x)-.3 < 0. && p.y > -.5 && p.y < .5) jd = texture2D(iChannel0,uv).rggb;
	
	vec4 ray = vec4(0.1,0.,0.2,1.);

	if (jd.a < 1.) 
	{
		ray -= vec4(vec2(.1+.05*sin(32.*p.y+32.*p.x+10.*ft)),.2,0.);
		ray -= .7*vec4(rm(o,d,1.1,.5,25),0.0);
	}
	
	uv2.x = clamp(uv2.x,.55,.95);
	uv2.y = clamp(uv2.y,.05,.95);
	vec4 text = vec4(texture2D(iChannel0,uv2).b);
	
	vec4 outcol = text.a*text + jd + (1. - jd.a*jd.a) * ray;
	
	return vec4(outcol);
}