funcdef void BG_GEN_CALLBACK();

class BackgroundGenerator {
	Scene@ scene;
	Timer@ timer;
	Array<Array<Object@>> items;
	String searchFolder = ASSETS_LOCATION+"Models/Debris/";
	Random random(654654);
	Array<Array<GameObject@>> bgObjects; 
	//Array<GameObject@> bgObjects;
	Array<Vector3> bgObjPositions;
	BG_GEN_CALLBACK @checkRef;
	Box bgStage;
	float speed = 0.2;
	Array<uint>  itemAmount;
	BackgroundGenerator() {
		// empty contsructor
	}
	BackgroundGenerator(Scene@ sc, Timer@ t, Array<Array<String>> inItems, Box bs, Array<uint> im) {
		@scene = @sc;
		@timer = @t;
		bgStage = bs;
		itemAmount = im;
		//items = inItems;
		@checkRef = BG_GEN_CALLBACK(this.update);
		float zCenter = bgStage.min.z+(((bgStage.min.z*-1)+bgStage.max.z)/2);
		float xCenter = bgStage.min.x+(((bgStage.min.x*-1)+bgStage.max.x)/2);
		bgObjPositions.add(Vector3(xCenter,0,zCenter));
		bgObjPositions.add(Vector3(xCenter,bgStage.max.y-1,zCenter));
		for (uint i = 0; i < inItems.length(); i++) {
			bgObjects.add(Array<GameObject@>());
			items.add(Array<Object@>());
			for (uint i2 = 0; i2 < inItems[i].length(); i2++) {
				items[i].add(objectFactory.load(searchFolder+inItems[i][i2]));
			}
		}
	}
	void start() {
		
		timer.elapsed += @checkRef;		
	}
	void stop() {
		timer.elapsed -= @checkRef;	
	}
	void clear() {
		timer.elapsed -= @checkRef;	
		for (uint gi = 0; gi < bgObjects.length(); gi++) {
			echo("gi:"+String(gi)+"\n");
			while (bgObjects[gi].length() > 0) {
				bgObjects[gi][0].removeFromScene();
				bgObjects[gi].removeAt(0);
			}
		}	
	}
	void update() {
		for (uint gi = 0; gi < bgObjects.length(); gi++) {
			for (uint i = bgObjects[gi].length(); i < 2; i++) {
				float xRange = ((bgStage.min.x*-1)+bgStage.max.x)/2;
				float zRange = ((bgStage.min.z*-1)+bgStage.max.z)/2;
				Box objSize(Vector3(-xRange,(bgStage.min.y/2)-1,-zRange), Vector3(xRange,(bgStage.max.y/2)-1,zRange));
				GameObject obj = bgGen.generate(itemAmount[gi], objSize, items[gi]);
				bgObjects[gi].add(obj);
				obj.addToScene(scene);
				obj.setPosition(bgObjPositions[i]);
				//echo("creating: "+String(i)+"\n");
			}
			for (uint i = 0; i < bgObjects[gi].length(); i++) {
				if (bgStage.containsPoint(bgObjects[gi][i].position)) {
					bgObjects[gi][i].relTranslate(Vector3(0,-1*speed,0));
				} else {
					bgObjects[gi][i].removeFromScene();
					bgObjects[gi].removeAt(i);
					//bgObjects[gi][i].setPosition(bgObjPositions[1]);
				}
			}
		}	
	}	
	
	GameObject generate(uint amount, Box box, Array<Object@>@ inItems) {
		Array<Vector3> positions;
		GameObject obj;
		uint control = 0;
		for (uint i = 0; i < amount; i++) {
			bool intersects = false;
			
			Vector3 destVector = getRandVectorSd(@random, box.min.x, box.max.x, box.min.y,box.max.y, box.min.z, box.max.z);
			for (uint i2 = 0; i2 < positions.length(); i2++) {
				if (control > 100) { break; }
				control++;				
				if (getBound(destVector, 0.5).intersects(getBound(positions[i2], 0.5))) {
					i--;
					intersects = true;
					break;
				}
			}	
			if (!intersects) {
				positions.add(destVector);
				uint randItemNr = random.get(0, inItems.length()-1);
				//echo("randItemNr: "+String(randItemNr)+"\n");
				//Object@ item = objectFactory.load(searchFolder+inItems[randItemNr]);
				Object temp(inItems[randItemNr]);
				Object@ item = @temp;
				//Object item = Object(inItems[randItemNr]);
				item.scale(0.3);
				MyColor endColor(150,50,50); 
				MyColor startColor(233,186,92); 				
				
				//echo("colors: "+String(startColor.r+dr)+", "+String(startColor.g+dg)+", "+String(startColor.b+db)+"\n");
				//Color finalColor = Color(startColor.r+dr, startColor.g+dg, startColor.b+db, 255);
				//echo("zVal: "+String(destVector.z)+", colors: "+String(mdr)+", "+String(mdg)+", "+String(mdb)+"\n");
				//item.model.setColor(Color(233,186,92,255));
				//item.model.setColor(Color(100,50,50,255));
				//item.model.setColor(modColor(startColor, endColor, 0, inItems.length(), randItemNr));
				//item.model.setColor(Color(255,0,0,255));
				item.model.setColor(modColor(startColor, endColor, box.min.z, box.max.z, destVector.z));
				Vector3 rndVec = getRandVectorSd(@random, -100, 100, -100,100, -100, 100);
				item.relRotate(rndVec.normalize, PI*0.45);
				obj.addChild(item, destVector);				
			}
							
		}
		return obj;		
	}

}



//bgColor = 0xFF000000 + r + g + b;
