
class ExplosionEffect {
	~ExplosionEffect() {
		echo("ExplosionEffect removed\n");
	}
	ExplosionEffect(Timer@ timer, Scene@ scene, Vector3 position) {
		for (int i = 0; i < 26; i++) {
			Vector3 tempVect = getDirectionVector(position, getRandVector(-10,10,-15,15,-10,10));
			float tempVel = float(RANDOM.get(15,25))/100;
			float rad = (float(RANDOM.get(0,200))/100);
			Quaternion orientation(tempVect, PI*rad);
			Object@ o = objectFactory.createSphere();
			o.scale(0.3,2,0.3);
			o.relRotate(orientation);
			o.model.getSurface(0).material.mode = pDM_ADDITIVE;
			Color c = modColor(MyColor(100,60,0), MyColor(255,255,255), 0, 2, rad);
			o.model.setColor(c);
			//Particle(o, timer, ParticleBehaviours().moveScaleRotate(tempVect*0.12, 30, 0.98), position, 0.58, scene);
			Particle(o, timer, ParticleBehaviours().moveScale(orientation, tempVel, 30, 0.98), position, 0.2, scene);
		}	
		Flash(@timer, @scene, position, 6);
		Explosion(@timer, @scene, position, 6);		
		for (int i = 0; i < 6; i++) {
			Vector3 tempV = getDirectionVector(position, getRandVector(-10,10,-15,15,-10,10));
			Object@ o = objectFactory.createCube();
			o.model.setColor(Color(60,10,10,255));
			o.scale(0.5,1,0.1);
			Particle(o, timer, ParticleBehaviours().moveScaleRotate(tempV*0.12, 30, 0.98), position, 0.58, scene);
		}		
	}
}

class Explosion:Base {
	Timer@ timer;
	int duration;
	Object@ object;
	//Scene@ scene;
	//ENTITY_CALLBACK@ checkFunc;
	float origScale = 1;
	int elapsed = 0;
	
	Explosion(Timer@ t, Scene@ s, Vector3 p, int d) {
		@timer = @t;
		@scene = s;
		duration = d;
		Object temp(OBJECT_EXPLOSION);
		@object = temp;
		object.model.getSurface(0).material.mode = pDM_EMISSIVE;
		object.scale(0.05);
		object.setPosition(p);
		scene.add(object);
		//@checkFunc = ENTITY_CALLBACK(this.check);
		timer.elapsed += Action(this.check);
		Base::addToScene(scene);
	}
	~Explosion() {
		if (addedToScene) {
			scene.remove(object);
		}	
	}
	
	void check() {
		if (elapsed < duration/2) {
			object.scale(1.25);
			//object.model.setColor(modColor(MyColor(0,0,0), MyColor(0,0,0), 0, duration/2-1, elapsed/2));	
		} else if (elapsed < duration) {
			object.scale(0.5);
			//object.model.setColor(modColor(MyColor(255,255,255), MyColor(0,0,0), 0, duration-1, elapsed));		
		} else {
			timer.elapsed -= Action(this.check);		
			//@checkFunc = null;
			scene.remove(object);
			Base::removeFromScene();
		}
		elapsed++;
	}
}