enum ButtonState {
	BS_Active,
	BS_Passive,
	BS_Over,
	BS_Disabled
}

class UIButton:UIElement{

	Object@ m_buttonObject;
	Label@ title;
	bool isOffset = false;
	ButtonState m_currentState = BS_Passive;
	UI_BUTTON_CLICK @OnClick;


	UIButton()
	{

	}

	UIButton(String imageLocation, String _title)
	{	
		//init button
		m_width = 0;
		m_height = 0;
		//create button object and load texture on to it
		if(imageLocation != ""){
			@m_buttonObject = objectFactory.createPoster(imageLocation);
			m_buttonObject.model.getSurface(0).material.mode = pDM_EMISSIVE;
		}
		@title = Label(aldoFont,_title);
		title.setScale(GLOBAL_UI_SCALE);
		
		// add button to UI scene

		@OnClick = UI_BUTTON_CLICK(this.EmptyFunc);
		

	}

	void EmptyFunc(){
		
	}

	void AddToScene(Scene@ scene){
		if(@m_buttonObject != null) scene.add(m_buttonObject);
		scene.add(title);

	}

	void State(ButtonState state){
		if(m_currentState != state){
			m_currentState = state;
			StateAction();
		}
	}
	Vector3 TempOffset(20,0,0);
	private void StateAction(){
		switch(m_currentState){

			case BS_Passive:
				if(isOffset){
					Position(TempOffset*-1);
					isOffset = false;
				}
			break;

			case BS_Disabled:
			break;

			case BS_Over:

			break;

			case BS_Active:
				if(!isOffset){
					Position(TempOffset);
					isOffset = true;
				}
			break;

			default:


		}
	}

	void UpdateObjectPosition(){
		if(@m_buttonObject != null) m_buttonObject.setPosition(m_translatedPosition);
		title.setPosition(m_translatedPosition);
		//m_buttonObject.setPosition(Vector3(20,0,0));
	}
	
}