#include "ShaderCommon.fx"

Texture2D<float4> InputTexture  : register(t1);
Texture2D<float4> BlurTexture	: register(t2);

cbuffer DOFParams
{
	float4 dofParams;		// x is focal plane distance
							// y is focal width
							// z is attenuation
};

float getBlurFactor(in float depth)
{
	return smoothstep(0.0f, dofParams.y, abs(dofParams.x - (depth * cameraParams.y)));
}

float4 DepthOfFieldPS(FullScreenVertexOut input) : SV_Target
{

	float4 cBlur = BlurTexture.SampleLevel(BilinearClampSampler, input.uv, 0);
	float4 cNoBlur = InputTexture.SampleLevel(PointClampSampler, input.uv, 0);
	float depth = DepthBuffer.Sample(PointClampSampler, input.uv, 0).w;

	float factor = saturate(getBlurFactor(depth));

	return lerp(cNoBlur, cBlur, factor * dofParams.z);
	//return cBlur;
}