#include "ShaderCommon.fx"

Texture2D<float4> InputTexture  : register(t0);
Texture2D<float4> GlowTexture	: register(t1);

cbuffer BloomParams
{
	float4 bloomParams;		// x is luma threshold
							// y is bloom intensity
							// z is bloom saturation
}

float4 ExtractLumaPS(FullScreenVertexOut input) : SV_Target
{
	float4 color = InputTexture.SampleLevel(PointClampSampler, input.uv, 0);

	return saturate(color - bloomParams.x);
}

float4 BloomPS(FullScreenVertexOut input) : SV_Target
{
	float3 c0 = InputTexture.SampleLevel(PointClampSampler, input.uv, 0).xyz;
	float3 c1 = GlowTexture.Sample(BilinearWrapSampler, input.uv).xyz;

	float grey = dot(c1, float3(0.3f, 0.59f, 0.11f));
	c1 = lerp(grey, c1, bloomParams.z) * bloomParams.x;
	return float4(saturate(c0 + c1), 1.0f);
}